
#import <simtoolsgui.h>

#import "SCLDisplay.h"

@implementation SCLDisplay


// code to make a probe for an object at a specific point. This is
// good to make as a button client for Raster widgets
-makeProbeAtX: (int) rasterX Y: (int) rasterY {
  id obj;
  int worldX, worldY;

  worldX = rasterX/8;
  worldY = rasterY/8;
  
  if ((worldX >= 0) && (worldX < [discrete2d getSizeX]) &&
      (worldY >= 0) && (worldY < [discrete2d getSizeY])) {
    obj = [discrete2d getObjectAtX: worldX Y: worldY];
    if (obj)
      [probeDisplayManager createProbeDisplayFor: obj];
    else
      [WarningMessage raiseEvent: 
      "Object2dDisplay: no object at coordinates(%d,%d)\n", 
      worldX, worldY];
  } else {
    [WarningMessage raiseEvent: 
    "Object2dDisplay: invalid coordinates to make probe (%d,%d)\n", 
    worldX, worldY];
  }
  return self;
}
      
@end
