/* 
  ParameterManager.m

  Barry McMullin <mcmullin@eeng.dcu.ie>
  16-OCT-1996

*/

#import <simtools.h>
#import <simtoolsgui.h>

#import "SCLGlobals.h"
#import "VNneighbor.h"
#import "MooreNeighbor.h"
#import "Version.h"

#import "Hole.h"
#import "Substrate.h"
#import "Link.h"
#import "Catalyst.h"
#import "Bond.h"

#import "ParameterManager.h"

@implementation ParameterManager   


-createEnd {
  ParameterManager *finalSelf;
  id <MessageProbe> messageProbe;
  id <ProbeMap> probeMap;

  finalSelf = [super createEnd];

  [finalSelf setCatalystMobilityFactor: 0.05];
  [finalSelf setProductionProbability: 1.0];
  [finalSelf setLinkMobilityFactor: 0.1];
  [finalSelf setDisintegrationProbability: 0.01];
  [finalSelf setChainInitiateProbability: 1.0];
  [finalSelf setChainExtendProbability: 1.0];
  [finalSelf setChainSpliceProbability: 1.0];
  [finalSelf setSubstrateMobilityFactor: 0.5];
  [finalSelf setAbsorptionProbability: 0.5];
  [finalSelf setEmissionProbability: 0.5];
  [finalSelf setHoleMobilityFactor: 0.5];
  [finalSelf setBondDecayProbability: 0.0];
  [finalSelf setChainInhibitBondFlag: YES];
  [finalSelf setCatInhibitBondFlag: NO];
  [finalSelf setMooreNeighbor];

  probeMap = [EmptyProbeMap createBegin: [finalSelf getZone]];
  [probeMap setProbedClass: [finalSelf class]];
  probeMap = [probeMap createEnd];

  messageProbe = 
    [probeLibrary getProbeForMessage: "saveToFileNamed:"
      inClass: [self class]];
  [messageProbe setHideResult: 1];
  [probeMap addProbe: messageProbe];

  messageProbe = 
    [probeLibrary getProbeForMessage: "loadFromFileNamed:"
      inClass: [self class]];
  [messageProbe setHideResult: 1];
  [probeMap addProbe: messageProbe];

  [probeMap addProbe: 
    [probeLibrary getProbeForVariable: "catalystMobilityFactor"
       inClass: [finalSelf class]]];
  [probeMap addProbe: 
    [probeLibrary getProbeForVariable: "productionProbability"
       inClass: [finalSelf class]]];
  [probeMap addProbe: 
    [probeLibrary getProbeForVariable: "linkMobilityFactor"
       inClass: [finalSelf class]]];
  [probeMap addProbe: 
    [probeLibrary getProbeForVariable: "disintegrationProbability"
       inClass: [finalSelf class]]];
  [probeMap addProbe: 
    [probeLibrary getProbeForVariable: "chainInitiateProbability"
       inClass: [finalSelf class]]];
  [probeMap addProbe: 
    [probeLibrary getProbeForVariable: "chainExtendProbability"
       inClass: [finalSelf class]]];
  [probeMap addProbe: 
    [probeLibrary getProbeForVariable: "chainSpliceProbability"
       inClass: [finalSelf class]]];
  [probeMap addProbe: 
    [probeLibrary getProbeForVariable: "absorptionProbability"
       inClass: [finalSelf class]]];
  [probeMap addProbe: 
    [probeLibrary getProbeForVariable: "emissionProbability"
       inClass: [finalSelf class]]];
  [probeMap addProbe: 
    [probeLibrary getProbeForVariable: "substrateMobilityFactor"
       inClass: [finalSelf class]]];
  [probeMap addProbe: 
    [probeLibrary getProbeForVariable: "holeMobilityFactor"
       inClass: [finalSelf class]]];
  [probeMap addProbe: 
    [probeLibrary getProbeForVariable: "bondDecayProbability"
       inClass: [finalSelf class]]];
  [probeMap addProbe: 
    [probeLibrary getProbeForVariable: "chainInhibitBondFlag"
       inClass: [finalSelf class]]];
  [probeMap addProbe: 
    [probeLibrary getProbeForVariable: "catInhibitBondFlag"
       inClass: [finalSelf class]]];
  [probeMap addProbe: 
    [probeLibrary getProbeForVariable: "mooreNeighborFlag"
       inClass: [finalSelf class]]];
  [probeMap addProbe: 
    [probeLibrary getProbeForVariable: "timerKludge"
       inClass: [finalSelf class]]];

  [probeLibrary setProbeMap: probeMap For: [finalSelf class]];

  return (finalSelf);
}


-(void) setCatalystMobilityFactor: (double) mobilityFactor {
  catalystMobilityFactor = mobilityFactor;
  [Catalyst setClassMobilityFactor: catalystMobilityFactor];
}

-(double) getCatalystMobilityFactor {
  catalystMobilityFactor  = [Catalyst getClassMobilityFactor]; // Defensive...

  return catalystMobilityFactor;
}

-(void) setProductionProbability: (double) probability {
  productionProbability = probability;
  [Catalyst setProductionProbability: productionProbability];
}

-(double) getProductionProbability {
  productionProbability = [Catalyst getProductionProbability]; // Defensive...

  return productionProbability;
}

-(void) setLinkMobilityFactor: (double) mobilityFactor {
  linkMobilityFactor = mobilityFactor;
  [Link setClassMobilityFactor: linkMobilityFactor];
}

-(double) getLinkMobilityFactor {
  linkMobilityFactor = [Link getClassMobilityFactor]; // Defensive...

  return linkMobilityFactor;
}

-(void) setChainInhibitBondFlag: (BOOL) value {
  chainInhibitBondFlag = value;
  [Link setChainInhibitBondFlag: chainInhibitBondFlag]; 
}

-(BOOL) getChainInhibitBondFlag {
  chainInhibitBondFlag = 
    [Link getChainInhibitBondFlag]; // Defensive...

  return chainInhibitBondFlag;
}

-(void) setCatInhibitBondFlag: (BOOL) value {
  catInhibitBondFlag = value;
  [Link setCatInhibitBondFlag: catInhibitBondFlag]; 
}

-(BOOL) getCatInhibitBondFlag {
  catInhibitBondFlag = 
    [Link getCatInhibitBondFlag]; // Defensive...

  return catInhibitBondFlag;
}

-(void) setDisintegrationProbability: (double) probability {
  disintegrationProbability = probability;
  [Link setDisintegrationProbability: disintegrationProbability]; 
}

-(double) getDisintegrationProbability {
  disintegrationProbability = 
    [Link getDisintegrationProbability]; // Defensive...

  return disintegrationProbability;
}

-(void)setChainInitiateProbability: (double) probability {
  chainInitiateProbability = probability;
  [Link setChainInitiateProbability: chainInitiateProbability];
}

-(double) getChainInitiateProbability {
  chainInitiateProbability = [Link getChainInitiateProbability]; // Defensive...

  return chainInitiateProbability;
}

-(void) setChainExtendProbability: (double) probability {
  chainExtendProbability = probability;
  [Link setChainExtendProbability: chainExtendProbability];
}

-(double) getChainExtendProbability {
  chainExtendProbability = [Link getChainExtendProbability]; // Defensive...

  return chainExtendProbability;
}

-(void) setChainSpliceProbability: (double) probability {
  chainSpliceProbability = probability;
  [Link setChainSpliceProbability: chainSpliceProbability];
}

-(double) getChainSpliceProbability {
  chainSpliceProbability = [Link getChainSpliceProbability]; // Defensive...

  return chainSpliceProbability;
}

-(void) setAbsorptionProbability: (double) probability {
  absorptionProbability = probability;
  [Link setAbsorptionProbability: absorptionProbability];
}

-(double) getAbsorptionProbability {
  absorptionProbability = [Link getAbsorptionProbability]; // Defensive...

  return absorptionProbability;
}

-(void) setEmissionProbability: (double) probability {
  emissionProbability = probability;
  [Link setEmissionProbability: emissionProbability];
}

-(double) getEmissionProbability {
  emissionProbability = [Link getEmissionProbability]; // Defensive...

  return emissionProbability;
}

-(void) setSubstrateMobilityFactor: (double) mobilityFactor {
  substrateMobilityFactor = mobilityFactor;
  [Substrate setClassMobilityFactor: substrateMobilityFactor];
}

-(double) getSubstrateMobilityFactor {
  substrateMobilityFactor = 
    [Substrate getClassMobilityFactor]; // Defensive...

  return substrateMobilityFactor;
}

-(void) setHoleMobilityFactor: (double) mobilityFactor {
  holeMobilityFactor = mobilityFactor;
  [Hole setClassMobilityFactor: holeMobilityFactor];
}

-(double) getHoleMobilityFactor {
  holeMobilityFactor = [Hole getClassMobilityFactor]; // Defensive...

  return holeMobilityFactor;
}

-(void) setBondDecayProbability: (double) probability {
  bondDecayProbability = probability;
  [Bond setBondDecayProbability: bondDecayProbability];
}

-(double) getBondDecayProbability {
  bondDecayProbability = [Bond getBondDecayProbability]; // Defensive...

  return bondDecayProbability;
}

-(void) setVNneighbor {
  defaultNeighbor = vnNeighbor;
  mooreNeighborFlag = NO;
}

-(void) setMooreNeighbor {
  defaultNeighbor = mooreNeighbor;
  mooreNeighborFlag = YES;
}

-(BOOL) getMooreNeighborFlag {
  mooreNeighborFlag = (defaultNeighbor == mooreNeighbor); // Defensive...

  return mooreNeighborFlag;
}

-(void) setTimerKludge: (unsigned) kludge {
  timerKludge = kludge;
}

-(unsigned) getTimerKludge {
  return timerKludge;
}

-(void) apply {
  [Catalyst setClassMobilityFactor: catalystMobilityFactor];
  [Catalyst setProductionProbability: productionProbability];
  [Link setClassMobilityFactor: linkMobilityFactor];
  [Link setDisintegrationProbability: disintegrationProbability]; 
  [Link setChainInitiateProbability: chainInitiateProbability];
  [Link setChainExtendProbability: chainExtendProbability];
  [Link setChainSpliceProbability: chainSpliceProbability];
  [Link setChainInhibitBondFlag: chainInhibitBondFlag];
  [Link setCatInhibitBondFlag: catInhibitBondFlag];
  [Link setAbsorptionProbability: absorptionProbability];
  [Link setEmissionProbability: emissionProbability];
  [Substrate setClassMobilityFactor: substrateMobilityFactor];
  [Hole setClassMobilityFactor: holeMobilityFactor];
  [Bond setBondDecayProbability: bondDecayProbability];
  if (mooreNeighborFlag) [self setMooreNeighbor];
  else [self setVNneighbor];
}

-(id) step {
  unsigned i, j;
  
  [self apply];

  for (i = 0; i < timerKludge; i++) 
    for (j = 0; j < 100000; j++) ;

}

-saveTo: (id <OutFile>) outFile {
  [self apply]; // Just to be sure!

  [outFile putString: "Parameters...\n"];

  [outFile putString: "mooreNeighborFlag (VN = 0, Moore = 1)\n"];
  [outFile putInt: (int) [self getMooreNeighborFlag]];
  [outFile putNewLine];

  [outFile putString: "holeMobilityFactor:\n"];
  [outFile putDouble: [self getHoleMobilityFactor]];
  [outFile putNewLine];

  [outFile putString: "substrateMobilityFactor:\n"];
  [outFile putDouble: [self getSubstrateMobilityFactor]];
  [outFile putNewLine];

  [outFile putString: "linkMobilityFactor:\n"];
  [outFile putDouble: [self getLinkMobilityFactor]];
  [outFile putNewLine];
  [outFile putString: "chainInitiateProbability:\n"];
  [outFile putDouble: [self getChainInitiateProbability]];
  [outFile putNewLine];
  [outFile putString: "chainExtendProbability:\n"];
  [outFile putDouble: [self getChainExtendProbability]];
  [outFile putNewLine];
  [outFile putString: "chainSpliceProbability:\n"];
  [outFile putDouble: [self getChainSpliceProbability]];
  [outFile putNewLine];
  [outFile putString: "chainInhibitBondFlag (NO = 0, YES = 1):\n"];
  [outFile putInt: (int) [self getChainInhibitBondFlag]];
  [outFile putNewLine];
  [outFile putString: "catInhibitBondFlag (NO = 0, YES = 1):\n"];
  [outFile putInt: (int) [self getCatInhibitBondFlag]];
  [outFile putNewLine];
  [outFile putString: "disintegrationProbability:\n"];
  [outFile putDouble: [self getDisintegrationProbability]];
  [outFile putNewLine];
  [outFile putString: "absorptionProbability:\n"];
  [outFile putDouble: [self getAbsorptionProbability]];
  [outFile putNewLine];
  [outFile putString: "emissionProbability:\n"];
  [outFile putDouble: [self getEmissionProbability]];
  [outFile putNewLine];

  [outFile putString: "catalystMobilityFactor:\n"];
  [outFile putDouble: [self getCatalystMobilityFactor]];
  [outFile putNewLine];
  [outFile putString: "productionProbability:\n"];
  [outFile putDouble: [self getProductionProbability]];
  [outFile putNewLine];

  [outFile putString: "bondDecayProbability:\n"];
  [outFile putDouble: [self getBondDecayProbability]];
  [outFile putNewLine];

  [outFile putString: "timerKludge:\n"];
  [outFile putInt: [self getTimerKludge]];
  [outFile putNewLine];

  return self;
}

-loadFrom: (id <InFile>) inFile {
  int intParm;
  double doubleParm;

  [inFile skipLine]; // "Parameters...\n"

  [inFile skipLine]; // "mooreNeighborFlag (VN = 0, Moore = 1)\n"
  [inFile getInt: &intParm];
  if (intParm == 0)
    [self setVNneighbor];
  else {
    if (intParm == 1) 
      [self setMooreNeighbor];
    else
      [InternalError raiseEvent:
        "Invalid mooreNeigborFlag (%d) encountered.\n",
        intParm];
  }
  [inFile skipLine];

  [inFile skipLine]; // "holeMobilityFactor:\n"
  [inFile getDouble: &doubleParm];
  [self setHoleMobilityFactor: doubleParm];
  [inFile skipLine];

  [inFile skipLine]; // "substrateMobilityFactor:\n"
  [inFile getDouble: &doubleParm];
  [self setSubstrateMobilityFactor: doubleParm];
  [inFile skipLine];

  [inFile skipLine]; // "linkMobilityFactor:\n"
  [inFile getDouble: &doubleParm];
  [self setLinkMobilityFactor: doubleParm];
  [inFile skipLine];
  [inFile skipLine]; // "chainInitiateProbability:\n"
  [inFile getDouble: &doubleParm];
  [self setChainInitiateProbability: doubleParm];
  [inFile skipLine];
  [inFile skipLine]; // "chainExtendProbability:\n"
  [inFile getDouble: &doubleParm];
  [self setChainExtendProbability: doubleParm];
  [inFile skipLine];
  [inFile skipLine]; // "chainSpliceProbability:\n"
  [inFile getDouble: &doubleParm];
  [self setChainSpliceProbability: doubleParm];
  [inFile skipLine];
  [inFile skipLine]; // "chainInhibitBondFlag (NO = 0, YES = 1):\n"
  [inFile getInt: &intParm];
  [self setChainInhibitBondFlag: (BOOL) intParm];
  [inFile skipLine];
  [inFile skipLine]; // "catInhibitBondFlag (NO = 0, YES = 1):\n"
  [inFile getInt: &intParm];
  [self setCatInhibitBondFlag: (BOOL) intParm];
  [inFile skipLine];
  [inFile skipLine]; // "disintegrationProbability:\n"
  [inFile getDouble: &doubleParm];
  [self setDisintegrationProbability: doubleParm];
  [inFile skipLine];
  [inFile skipLine]; // "absorptionProbability:\n"
  [inFile getDouble: &doubleParm];
  [self setAbsorptionProbability: doubleParm];
  [inFile skipLine];
  [inFile skipLine]; // "emissionProbability:\n"
  [inFile getDouble: &doubleParm];
  [self setEmissionProbability: doubleParm];
  [inFile skipLine];

  [inFile skipLine]; //"catalystMobilityFactor:\n"
  [inFile getDouble: &doubleParm];
  [self setCatalystMobilityFactor: doubleParm];
  [inFile skipLine];
  [inFile skipLine]; // "productionProbability:\n"
  [inFile getDouble: &doubleParm];
  [self setProductionProbability: doubleParm];
  [inFile skipLine];

  [inFile skipLine]; // "bondDecayProbability:\n"
  [inFile getDouble: &doubleParm];
  [self setBondDecayProbability: doubleParm];
  [inFile skipLine];

  [inFile skipLine]; // "timerKludge:\n"
  [inFile getInt: &intParm];
  [self setTimerKludge: intParm];
  [inFile skipLine];

  return self;
}

-saveToFileNamed: (char *) filename {
  id <OutFile> outFile;

  [modelSwarm setStateStopped]; // Defensive...

  outFile = [OutFile create: [self getZone] withName: filename];

  [outFile putString: "# "];
  [outFile putString: [Version getVersionString]];
  [outFile putNewLine];

  [self saveTo: outFile];
 
  [outFile drop];

  return self;
}

-loadFromFileNamed: (char *) filename {
  id <InFile> inFile;

  [modelSwarm setStateStopped]; // Defensive...

  inFile = [InFile create: [self getZone] withName: filename];

  [inFile skipLine]; // Version info...
  // Possibly should check for compatibility (;-)

  [self loadFrom: inFile];

  [inFile drop];

  return self;
}



@end
