/* 
  Particle.h

  Barry McMullin <mcmullin@eeng.dcu.ie>
  27-SEP-1996

  This is a general purpose class for "particles" in a 2d
  space. It should be subclassed for distinct "molecular
  species" in an artificial chemistry.

*/

//#import <tkobjc/Raster.h>

#import <gui.h>

#import "Agent2d.h"


@interface Particle: Agent2d {
  BOOL hasMoved;
  Color particleColor;
}

+(void) setClassMobilityFactor: (double) inMobilityFactor;
+(double) getClassMobilityFactor;

-setParticleColor: (Color) c;

-(BOOL) canMove;
-doMotion;
-setHasMoved;
-initialiseStep;
-step;

-drawSelfOn: (id <Raster>) r;


@end
