// Copyright (C) 1995 The Santa Fe Institute.
// No warranty implied, see LICENSE for terms.


#ifndef __CHROMOSOME_P
#define __CHROMOSOME_P

#import <collections.h>

@protocol Chromosome

//@create
-setLength: (unsigned) len;
-setRandomInit;

// to set fitness;
-setFitness: (double) _fitness;

//-setRange: (double *) range;
//-setRange: (double *) range Locus: (unsigned) l; // Range for only one gene

//-setBinaryRep;
//-setCharStringRep: (char *) chars;
//-setFloatArrayRep;
//-setPermutationRep: (unsigned) cardinality;
//@final

// unary operators -- probably changed afterwards into "create" operators
- Clone : (id<Chromosome>) _chrom withMutation: (float) _mutProb;

- Duplicate : (id<Chromosome>) _chrom 
	From: (unsigned) _l1 
	  To: (unsigned) _l2 
withMutation: (float) _mutProb;

- Kill : (id<Chromosome>) _chrom
   From: (unsigned) _l1 
     To: (unsigned) _l2;

- Swap:  (id<Chromosome>) _chrom 
      : (unsigned) _l1 
  with: (unsigned) _l2
  size: (unsigned) _bytes;		// Swap whole byte/loci

- RemoveReinsert : (id<Chromosome>) _chrom 
		 : (unsigned) _l1 
	       To: (unsigned) _l2 
	     size: (unsigned) _bytes;

// binary operators
-Mate: (id<Chromosome>) _chrom1 
  And: (id<Chromosome>) _chrom2
withMutation: (float) _mutationRate ; // 2-point crossover

// - crossOver: (id<Chromosome>) chrom1 
// 	   : (id<Chromosome>) chrom2 
//     withArg: xOverFunc;

// // orgy operators
// - orgy: (id<Collection>) parents  withArg: orgyFunc;

// info functions
- (unsigned) getLength;
- getGenotype;
- (double) getFitness;
- (unsigned char) getGene: (unsigned) offset;
- hexaPrint;			// Print binary chrom in hexa

// Killing functions
- free;
@end

#endif
