// Template application. Copyright (C) 1996 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

// Template main.m: this particular "simulation" just creates an object
// that spins its own counter, prints out numbers occasionally. Take that
// code out and add in your own simulation needs.
// Pay special attention to the word "MODIFY", that's for you to customize.

#import "PopObsSwarm.h"

#define GENLEN 4

float evalFunc( id<Chromosome> a );

int
main(int argc, char ** argv) {
  PopulationObserverSwarm * observerSwarm;

  initSwarm(argc, argv);

  observerSwarm = [PopulationObserverSwarm create: globalZone];
  [observerSwarm setChromLength: GENLEN];
  [observerSwarm setEvaluationFunc: evalFunc];
  [observerSwarm buildObjects];
  [observerSwarm buildActions];
  [observerSwarm activateIn: nil];
  [observerSwarm go];

  return 0;
}

// Evaluation function. Name can be different, but the structure must always
// be the same. This function is called once in the lifetime for each different 
// genome
float evalFunc( id<Chromosome> a ) {
    unsigned i;
    float ones = 0;
    unsigned long gen, mask = 1;

    // Using getGene we retrieve the different bytes of the chromosome. 
    // If one parameter uses several bytes, like here, use shifts and
    // multiplication to get its value.

    gen = ((long)[a getGene:0]<<24) 
      + ((long)[a getGene:1]<<16) + 
      ((long)[ a getGene:2 ]<<8) + [ a getGene:3 ];
//    [a hexaPrint];printf( " Examinando %lx", gen );
    for ( i = 0; i < 8*GENLEN; i ++ ) {
	ones += ( ( mask & gen ) != 0 );
	mask <<= 1;
    }

//    printf ("Numero de unos %.1f\n", ones );
    return ones;
}
