// a database object that either takes the cell or grid2d cells and updates values

#import "DataBase.h"

@implementation DataBase

// initialization of database
-setDataFile: (char *) name
{
  int i=0;
  while (name[i] != '\0') {
    data_file[i] = name[i];
    i++;
    if (i > 40) {
      fprintf(stderr,"Error: file name too long\n");
      exit(-1);
    }
  }
  data_file[i] = '\0';
  if ((fp = fopen(data_file,"r")) == NULL) {
    fprintf(stderr, "Error: can't open %s\n", data_file);
    exit(-1);
  }
  return self;
}

-setSelMethod: (SEL) method
{
  theMethod = method;
  return self;
}

-setDataFileLength: (int) num
{
  data_length = num;
  return self;
}

-setWhichYield: (int) a
{
  which_yield = a;
  return self;
}

-setRandomYield: (int) a
{
  random_yield = a;
  return self;
}

-setWorld: (Grid2d *) w
{
  world = w;
  return self;
}

-createEnd
{
  if (world==nil){
    fprintf(stderr,"ERROR: must set world before ending database creation\n");
    exit(-1);
  }
  // check on the size of the world
  wx = [world getSizeX]; if (wx>227) wx = 227;
  wy = [world getSizeY]; if (wy>200) wy = 200;
  tmp = 0;
  return self;
}

// database actions
-closeDataFile;
{
  fclose(fp);
  return self;
}
      
-updateDataGrid
{
  int x,y;
  int i;
  
  if (data_length < 1){
    if (which_yield == 0) data_length = 400;
    rewind (fp);
  }
  // update yield world
  // data is stored as N-S is columns and W-E os rows
  // hardcoded dimensions of the world 227x200
  for (y=0;y<200;y++) {
    for (x=0;x<227;x++) {
      fscanf(fp,"%d",&i);
      data[y][x] = i;
    }
  }
  data_length--;
  return self;
}

-updateCells
{
  int x,y;
  for (y=0;y<wy;y++) {
    for (x=0;x<wx;x++) {
      Cell * cell;
      cell = [world getObjectAtX: x Y: y];
      [cell perform: theMethod with: (id) data[y][x]];
    }
  }
  return self;
}

-updateRandomCells
{
  int x,y;
  for (y=0;y<wy;y++) {
    for (x=0;x<wx;x++) {
      Cell * cell;
      cell = [world getObjectAtX: x Y: y];
      [cell perform: theMethod
	    with: (id)((int)(data[y][x] * (1.0 + [self gaussian]/4.0)))];
    }
  }
  return self;
}

-updateCellWorld
{
  switch (which_yield){
    case -1: // init data files is folder data
      [self updateDataGrid];
      [self updateCells]; break;
    case 0:
      [self updateDataGrid];
      [self updateCells]; break;
    case 1:
      [self updateRandomCells]; break;
    default:
      break;
      // cases 2,3 should not change with updates
  }
  return self;
}


// yield specific stuff

-initYields
{
  int x,y;

  switch (which_yield){
    case 1:
      for (y=0;y<wy;y++)
	for (x=0;x<wx;x++)
	  data[y][x] = ((int)(random_yield/2.3677)-4)/10;
	  break;
    case 2:
      for (y=0;y<wy;y++)
	for (x=0;x<wx;x++)
	  data[y][x] = ((int)(random_yield/2.3677)-4)/10;
	  break;      
    case 3:
      [self peakIt];
      break;
    default:
      break;
  }
  return self;
}

-peakIt
{
  int i,j;

  for (i=0;i<=wy/2;i++)
    for (j=0;j<wx;j++)
      data[i][j] = i/2+5;
  for (i=wy-1;i>wy/2;i--)
    for (j=0;j<wx;j++)
      data[i][j] = wy/2 - i/2 + 5;
  for (j=0;j<wx/2;j++)
    for (i=j;i<wy-j-1;i++)
      data[i+1][j] = data[i][j];
  for (j=wx-1;j>=wx/2;j--)
    for (i=wx-j-1;i<j-wx+wy;i++)
      data[i+1][j] = data[i][j];
  return self;
}

-(float) gaussian
{
  // Box Muller transformation
  float x1, x2, w;

  if (tmp==0) {
    do {
//    x1 = 2.0 * [uniformRandom rFloat] - 1.0;
//    x2 = 2.0 * [uniformRandom rFloat] - 1.0;
      x1 = 2.0 * [uniformDblRand getDoubleWithMin: 0.0 withMax: 1.0] - 1.0;
      x2 = 2.0 * [uniformDblRand getDoubleWithMin: 0.0 withMax: 1.0] - 1.0;
      w = x1 * x1 + x2 * x2;
    } while ( w >= 1.0 );
    
    w = sqrt( (-2.0 * log( w ) ) / w );
    
    // return two rng mean 0 sd 1
    r1 = x1 * w;
    tmp = 1;
    return (x2 * w);
  } else {
    tmp = 0;
    return (r1);
  }
}

@end
