// Extrinsic.h

// Copyright (C) 1996 The Santa Fe Institute.
// No warranty implied, see LICENSE for terms.

#import <objectbase/SwarmObject.h>

// extrinsic parameters of the camera in a world coordinate system.
// according to the SWARM environment we used and to our aim, the parameters are
// only four: x, y, z (a three D position) and a rotation around the vertical axis.
// We therefore assume the camera is built on top of an agent able to wander around 
// in a two D swarm grid. Therefore the only rotation is around the vertical axis.
//
//    0-----------------> xswarm
//    |
//    | 
//    |
//  . |
//    |
// yswarm 
// 
// from the assumed 2D coordinate system in a swarm grid, we used the virtual 3D system:
// (top view) 
//  X .-----------------> Y
//    |
//    | 
//    |
//  . |
//    |
//    Z
// 

@interface Extrinsic: SwarmObject
{
        // 3D coordinates of the camera, which is located in a 2D swarm grid.
  int x;  // denotes the height (vertical axis)
  int y;  // denotes the width (horizontal axis in a swarm grid: xswarm)
  int z;  // denotes the depth (vertical axis in a swarm grid: yswarm)
  double rotation; // around the vertical axis (referred to as X in the drawing). Convention we used:
  // positive if rotation clockwise, negative if counterclockwise.
}

// initialize from the position into the swarm grid
- initialize: (int)xin: (int)yin: (int)zin: (double)rotin;

// send parameters
- (int)sendx;
- (int)sendy;
- (int)sendz;
- (double)sendtheta;

// modify parameters
- modifyx: (int)newx;
- modifyy: (int)newy;
- modifyz: (int)newz;
- modifytheta: (double)newtheta;

// print extrinsic parameters of Camera
- print:(char *)identifier;

@end
