// Extrinsic.m

// Copyright (C) 1996 The Santa Fe Institute.
// No warranty implied, see LICENSE for terms.

#import "Extrinsic.h"

@implementation Extrinsic

// initialize from the position into the swarm grid
-initialize: (int)xin: (int)yin: (int)zin: (double)rotin
{
  x = xin;
  y = yin;
  z = zin;
  rotation = rotin;
  return self;
}

// send parameters
-(int)sendx
{
  return x;
}

-(int)sendy
{
  return y;
}

-(int)sendz
{
  return z;
}

-(double)sendtheta
{
  return rotation;
}

// modify parameters
-modifyx: (int)newx
{
  x=newx;
  return self;
}

-modifyy: (int)newy
{
  y=newy;
  return self;
}

-modifyz: (int)newz
{
  z=newz;
  return self;
}

-modifytheta: (double)newtheta
{
  rotation=newtheta;
  return self;
}


// print extrinsic parameters of camera
-print: (char *)identifier
{
  printf("\n\nExtrinsic parameters of Camera %s: \nx: %d, y: %d, z: %d, rotation: %g\n", identifier, x, y, z, rotation);
  return self;
}

@end