/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Double
extends Number
implements Comparable {
    private static final int NUM_MANTISSA_BITS = 52;
    private static final long EXPONENT_MASK = 0x7FF0000000000000L;
    private static final long MANTISSA_MASK = 0xFFFFFFFFFFFFFL;
    private static final long NAN_BITS = 9221120237041090560L;
    private static final long POSITIVE_INFINITY_BITS = 0x7FF0000000000000L;
    private static final long NEGATIVE_INFINITY_BITS = -4503599627370496L;
    private static final long MIN_VALUE_BITS = 1L;
    private static final long MAX_VALUE_BITS = 0x7FEFFFFFFFFFFFFFL;
    public static final double POSITIVE_INFINITY = 1.0 / 0.0;
    public static final double NEGATIVE_INFINITY = -1.0 / 0.0;
    public static final double NaN = 0.0 / 0.0;
    public static final double MIN_VALUE = 4.9E-324;
    public static final double MAX_VALUE = 1.7976931348623157E308;
    public static final Class TYPE = Class.getPrimitiveClass("double");
    static final int[] bitsToDecimal = new int[]{1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 6, 6, 6, 7, 7, 7, 7, 8, 8, 8, 9, 9, 9, 10, 10, 10, 10, 11, 11, 11, 12, 12, 12, 13, 13, 13, 13, 14, 14, 14, 15, 15, 15, 16, 16, 16};
    private static final long serialVersionUID = -9172774392245257468L;
    private final double value;

    public static native long doubleToRawLongBits(double var0);

    public static native double longBitsToDouble(long var0);

    static native String toStringWithPrecision(double var0, int var2);

    static native double valueOf0(String var0) throws NumberFormatException;

    public double doubleValue() {
        return this.value;
    }

    public int compareTo(Object object) {
        long l;
        long l2 = Double.doubleToLongBits(this.value);
        return l2 < (l = Double.doubleToLongBits(((Double)object).value)) ? -1 : (l2 == l ? 0 : 1);
    }

    public static String toString(double d) {
        int n;
        if (Double.isNaN(d)) {
            return "NaN";
        }
        if (d == Double.POSITIVE_INFINITY) {
            return "Infinity";
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return "-Infinity";
        }
        long l = Double.doubleToRawLongBits(d);
        if ((l & 0x7FF0000000000000L) == 0L) {
            int n2 = 51;
            while (n2 > 0 && (1L << n2 & l) == 0L) {
                --n2;
            }
            n = bitsToDecimal[n2];
        } else {
            n = bitsToDecimal[51];
        }
        return Double.toStringWithPrecision(d, ++n);
    }

    public String toString() {
        return Double.toString(this.value);
    }

    public boolean equals(Object object) {
        return object instanceof Double && Double.doubleToLongBits(this.value) == Double.doubleToLongBits(((Double)object).value);
    }

    public float floatValue() {
        return (float)this.value;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.value);
        return (int)l ^ (int)(l >> 32);
    }

    public int intValue() {
        return (int)this.value;
    }

    public static long doubleToLongBits(double d) {
        long l = Double.doubleToRawLongBits(d);
        return Double.isNaN(l) ? 9221120237041090560L : l;
    }

    public boolean isInfinite() {
        return Double.isInfinite(this.value);
    }

    public static boolean isInfinite(double d) {
        return d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY;
    }

    public boolean isNaN() {
        return Double.isNaN(Double.doubleToRawLongBits(this.value));
    }

    public static boolean isNaN(double d) {
        return Double.isNaN(Double.doubleToRawLongBits(d));
    }

    private static boolean isNaN(long l) {
        return (l & 0x7FF0000000000000L) == 0x7FF0000000000000L && (l & 0xFFFFFFFFFFFFFL) != 0L;
    }

    public long longValue() {
        return (long)this.value;
    }

    public static Double valueOf(String string) throws NumberFormatException {
        if (string == null) {
            throw new NullPointerException();
        }
        return new Double(Double.valueOf0(string));
    }

    public static double parseDouble(String string) throws NumberFormatException {
        if (string == null) {
            throw new NullPointerException();
        }
        return Double.valueOf0(string);
    }

    public Double(double d) {
        this.value = d;
    }

    public Double(String string) throws NumberFormatException {
        this.value = Double.valueOf((String)string).value;
    }
}

