/*
 * Decompiled with CFR 0.152.
 */
package at.dms.util;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;

public abstract class Options {
    public String[] nonOptions;
    private final String name;

    public boolean parseCommandLine(String[] stringArray) {
        int n;
        Getopt getopt = new Getopt(this.name, stringArray, this.getShortOptions(), this.getLongOptions(), true);
        while ((n = getopt.getopt()) != -1) {
            if (this.processOption(n, getopt)) continue;
            return false;
        }
        this.nonOptions = new String[stringArray.length - getopt.getOptind()];
        System.arraycopy(stringArray, getopt.getOptind(), this.nonOptions, 0, this.nonOptions.length);
        return true;
    }

    public boolean processOption(int n, Getopt getopt) {
        switch (n) {
            case 104: {
                this.help();
                System.exit(0);
                break;
            }
            case 86: {
                this.version();
                System.exit(0);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public String[] getOptions() {
        return new String[]{"  --help, -h:           Displays the help information", "  --version, -V:        Prints out the version information"};
    }

    public void printOptions() {
        String[] stringArray = this.getOptions();
        int n = stringArray.length;
        while (--n >= 0) {
            int n2 = 0;
            while (n2 < n) {
                if (stringArray[n2].compareTo(stringArray[n2 + 1]) > 0) {
                    String string = stringArray[n2];
                    stringArray[n2] = stringArray[n2 + 1];
                    stringArray[n2 + 1] = string;
                }
                ++n2;
            }
        }
        n = 0;
        while (n < stringArray.length) {
            System.out.println(stringArray[n]);
            ++n;
        }
    }

    protected abstract void help();

    protected abstract void version();

    protected abstract void usage();

    protected int getInt(Getopt getopt, int n) {
        try {
            return getopt.getOptarg() != null ? new Integer(getopt.getOptarg()) : n;
        }
        catch (Exception exception) {
            System.err.println("malformed option: " + getopt.getOptarg());
            System.exit(0);
            return 1;
        }
    }

    protected String getString(Getopt getopt, String string) {
        return getopt.getOptarg() != null ? getopt.getOptarg() : string;
    }

    public String getShortOptions() {
        return "hV";
    }

    public LongOpt[] getLongOptions() {
        return new LongOpt[]{new LongOpt("help", 0, null, 104), new LongOpt("version", 0, null, 86)};
    }

    public Options(String string) {
        this.name = string;
    }
}

