/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarException;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class JarFile
extends ZipFile {
    public static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";
    private Manifest manifest;

    private void verifyIfSigned() throws JarException {
    }

    public Manifest getManifest() throws IOException {
        ZipEntry zipEntry;
        if (this.manifest == null && (zipEntry = this.getEntry(MANIFEST_NAME)) != null) {
            this.manifest = new Manifest(this.getInputStream(zipEntry));
        }
        return this.manifest;
    }

    public JarEntry getJarEntry(String string) {
        ZipEntry zipEntry = this.getEntry(string);
        if (zipEntry == null) {
            return null;
        }
        Attributes attributes = null;
        try {
            Manifest manifest = this.getManifest();
            if (manifest != null) {
                attributes = this.getManifest().getAttributes(string);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new JarEntry(zipEntry, attributes);
    }

    public ZipEntry getEntry(String string) {
        return super.getEntry(string);
    }

    public Enumeration entries() {
        Enumeration enumeration = super.entries();
        return new Enumeration(this, enumeration){
            private final /* synthetic */ JarFile this$0;
            private final /* synthetic */ Enumeration val$ents;

            public boolean hasMoreElements() {
                return this.val$ents.hasMoreElements();
            }

            public Object nextElement() {
                ZipEntry zipEntry = (ZipEntry)this.val$ents.nextElement();
                return this.this$0.getJarEntry(zipEntry.getName());
            }
            {
                this.val$ents = enumeration;
                this.this$0 = jarFile;
                this.constructor$0(jarFile);
            }

            private final void constructor$0(JarFile jarFile) {
            }
        };
    }

    public InputStream getInputStream(ZipEntry zipEntry) throws IOException {
        return super.getInputStream(zipEntry);
    }

    public JarFile(String string) throws IOException {
        this(string, true);
    }

    public JarFile(String string, boolean bl) throws IOException {
        super(string);
        if (bl) {
            this.verifyIfSigned();
        }
    }

    public JarFile(File file) throws IOException {
        this(file, true);
    }

    public JarFile(File file, boolean bl) throws IOException {
        super(file);
        if (bl) {
            this.verifyIfSigned();
        }
    }
}

