/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.bind.v2.runtime.unmarshaller;

import com.sun.xml.internal.bind.IDResolver;
import com.sun.xml.internal.bind.api.ClassResolver;
import com.sun.xml.internal.bind.unmarshaller.DOMScanner;
import com.sun.xml.internal.bind.unmarshaller.InfosetScanner;
import com.sun.xml.internal.bind.unmarshaller.Messages;
import com.sun.xml.internal.bind.v2.runtime.AssociationMap;
import com.sun.xml.internal.bind.v2.runtime.JAXBContextImpl;
import com.sun.xml.internal.bind.v2.runtime.JaxBeanInfo;
import com.sun.xml.internal.bind.v2.runtime.unmarshaller.DefaultIDResolver;
import com.sun.xml.internal.bind.v2.runtime.unmarshaller.InterningXmlVisitor;
import com.sun.xml.internal.bind.v2.runtime.unmarshaller.MTOMDecorator;
import com.sun.xml.internal.bind.v2.runtime.unmarshaller.SAXConnector;
import com.sun.xml.internal.bind.v2.runtime.unmarshaller.StAXConnector;
import com.sun.xml.internal.bind.v2.runtime.unmarshaller.StAXEventConnector;
import com.sun.xml.internal.bind.v2.runtime.unmarshaller.StAXStreamConnector;
import com.sun.xml.internal.bind.v2.runtime.unmarshaller.UnmarshallingContext;
import com.sun.xml.internal.bind.v2.runtime.unmarshaller.ValidatingUnmarshaller;
import com.sun.xml.internal.bind.v2.runtime.unmarshaller.XmlVisitor;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.PropertyException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.UnmarshallerHandler;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import javax.xml.bind.helpers.AbstractUnmarshallerImpl;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UnmarshallerImpl
extends AbstractUnmarshallerImpl
implements ValidationEventHandler {
    protected final JAXBContextImpl context;
    private Schema schema;
    public final UnmarshallingContext coordinator;
    private Unmarshaller.Listener externalListener;
    private AttachmentUnmarshaller attachmentUnmarshaller;
    private IDResolver idResolver = new DefaultIDResolver();
    private static final DefaultHandler dummyHandler = new DefaultHandler();
    public static final String FACTORY = "com.sun.xml.internal.bind.ObjectFactory";

    public UnmarshallerImpl(JAXBContextImpl jAXBContextImpl, AssociationMap associationMap) {
        this.context = jAXBContextImpl;
        this.coordinator = new UnmarshallingContext(this, associationMap);
        try {
            this.setEventHandler(this);
        }
        catch (JAXBException jAXBException) {
            throw new AssertionError((Object)jAXBException);
        }
    }

    @Override
    public UnmarshallerHandler getUnmarshallerHandler() {
        return this.getUnmarshallerHandler(true, null);
    }

    private SAXConnector getUnmarshallerHandler(boolean bl, JaxBeanInfo jaxBeanInfo) {
        XmlVisitor xmlVisitor = this.createUnmarshallerHandler(null, false, jaxBeanInfo);
        if (bl) {
            xmlVisitor = new InterningXmlVisitor(xmlVisitor);
        }
        return new SAXConnector(xmlVisitor, null);
    }

    public final XmlVisitor createUnmarshallerHandler(InfosetScanner infosetScanner, boolean bl, JaxBeanInfo jaxBeanInfo) {
        this.coordinator.reset(infosetScanner, bl, jaxBeanInfo, this.idResolver);
        XmlVisitor xmlVisitor = this.coordinator;
        if (this.schema != null) {
            xmlVisitor = new ValidatingUnmarshaller(this.schema, xmlVisitor);
        }
        if (this.attachmentUnmarshaller != null && this.attachmentUnmarshaller.isXOPPackage()) {
            xmlVisitor = new MTOMDecorator(this, xmlVisitor, this.attachmentUnmarshaller);
        }
        return xmlVisitor;
    }

    public static boolean needsInterning(XMLReader xMLReader) {
        try {
            xMLReader.setFeature("http://xml.org/sax/features/string-interning", true);
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        try {
            if (xMLReader.getFeature("http://xml.org/sax/features/string-interning")) {
                return false;
            }
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        return true;
    }

    @Override
    protected Object unmarshal(XMLReader xMLReader, InputSource inputSource) throws JAXBException {
        return this.unmarshal0(xMLReader, inputSource, null);
    }

    protected <T> JAXBElement<T> unmarshal(XMLReader xMLReader, InputSource inputSource, Class<T> clazz) throws JAXBException {
        if (clazz == null) {
            throw new IllegalArgumentException();
        }
        return (JAXBElement)this.unmarshal0(xMLReader, inputSource, this.getBeanInfo(clazz));
    }

    private Object unmarshal0(XMLReader xMLReader, InputSource inputSource, JaxBeanInfo jaxBeanInfo) throws JAXBException {
        SAXConnector sAXConnector = this.getUnmarshallerHandler(UnmarshallerImpl.needsInterning(xMLReader), jaxBeanInfo);
        xMLReader.setContentHandler(sAXConnector);
        xMLReader.setErrorHandler(this.coordinator);
        try {
            xMLReader.parse(inputSource);
        }
        catch (IOException iOException) {
            throw new UnmarshalException(iOException);
        }
        catch (SAXException sAXException) {
            throw this.createUnmarshalException(sAXException);
        }
        Object object = sAXConnector.getResult();
        xMLReader.setContentHandler(dummyHandler);
        xMLReader.setErrorHandler(dummyHandler);
        return object;
    }

    @Override
    public <T> JAXBElement<T> unmarshal(Source source, Class<T> clazz) throws JAXBException {
        if (source instanceof SAXSource) {
            SAXSource sAXSource = (SAXSource)source;
            XMLReader xMLReader = sAXSource.getXMLReader();
            if (xMLReader == null) {
                xMLReader = this.getXMLReader();
            }
            return this.unmarshal(xMLReader, sAXSource.getInputSource(), clazz);
        }
        if (source instanceof StreamSource) {
            return this.unmarshal(this.getXMLReader(), UnmarshallerImpl.streamSourceToInputSource((StreamSource)source), clazz);
        }
        if (source instanceof DOMSource) {
            return this.unmarshal(((DOMSource)source).getNode(), clazz);
        }
        throw new IllegalArgumentException();
    }

    public Object unmarshal0(Source source, JaxBeanInfo jaxBeanInfo) throws JAXBException {
        if (source instanceof SAXSource) {
            SAXSource sAXSource = (SAXSource)source;
            XMLReader xMLReader = sAXSource.getXMLReader();
            if (xMLReader == null) {
                xMLReader = this.getXMLReader();
            }
            return this.unmarshal0(xMLReader, sAXSource.getInputSource(), jaxBeanInfo);
        }
        if (source instanceof StreamSource) {
            return this.unmarshal0(this.getXMLReader(), UnmarshallerImpl.streamSourceToInputSource((StreamSource)source), jaxBeanInfo);
        }
        if (source instanceof DOMSource) {
            return this.unmarshal0(((DOMSource)source).getNode(), jaxBeanInfo);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public final ValidationEventHandler getEventHandler() {
        try {
            return super.getEventHandler();
        }
        catch (JAXBException jAXBException) {
            throw new AssertionError();
        }
    }

    public final boolean hasEventHandler() {
        return this.getEventHandler() != this;
    }

    @Override
    public <T> JAXBElement<T> unmarshal(Node node, Class<T> clazz) throws JAXBException {
        if (clazz == null) {
            throw new IllegalArgumentException();
        }
        return (JAXBElement)this.unmarshal0(node, this.getBeanInfo(clazz));
    }

    @Override
    public final Object unmarshal(Node node) throws JAXBException {
        return this.unmarshal0(node, null);
    }

    @Deprecated
    public final Object unmarshal(SAXSource sAXSource) throws JAXBException {
        return super.unmarshal((Source)sAXSource);
    }

    public final Object unmarshal0(Node node, JaxBeanInfo jaxBeanInfo) throws JAXBException {
        try {
            DOMScanner dOMScanner = new DOMScanner();
            InterningXmlVisitor interningXmlVisitor = new InterningXmlVisitor(this.createUnmarshallerHandler(null, false, jaxBeanInfo));
            dOMScanner.setContentHandler(new SAXConnector(interningXmlVisitor, dOMScanner));
            if (node instanceof Element) {
                dOMScanner.scan((Element)node);
            } else if (node instanceof Document) {
                dOMScanner.scan((Document)node);
            } else {
                throw new IllegalArgumentException("Unexpected node type: " + node);
            }
            Object object = interningXmlVisitor.getContext().getResult();
            interningXmlVisitor.getContext().clearResult();
            return object;
        }
        catch (SAXException sAXException) {
            throw this.createUnmarshalException(sAXException);
        }
    }

    @Override
    public Object unmarshal(XMLStreamReader xMLStreamReader) throws JAXBException {
        return this.unmarshal0(xMLStreamReader, null);
    }

    @Override
    public <T> JAXBElement<T> unmarshal(XMLStreamReader xMLStreamReader, Class<T> clazz) throws JAXBException {
        if (clazz == null) {
            throw new IllegalArgumentException();
        }
        return (JAXBElement)this.unmarshal0(xMLStreamReader, this.getBeanInfo(clazz));
    }

    public Object unmarshal0(XMLStreamReader xMLStreamReader, JaxBeanInfo jaxBeanInfo) throws JAXBException {
        if (xMLStreamReader == null) {
            throw new IllegalArgumentException(Messages.format("Unmarshaller.NullReader"));
        }
        int n = xMLStreamReader.getEventType();
        if (n != 1 && n != 7) {
            throw new IllegalStateException(Messages.format("Unmarshaller.IllegalReaderState", n));
        }
        XmlVisitor xmlVisitor = this.createUnmarshallerHandler(null, false, jaxBeanInfo);
        StAXConnector stAXConnector = StAXStreamConnector.create(xMLStreamReader, xmlVisitor);
        try {
            stAXConnector.bridge();
        }
        catch (XMLStreamException xMLStreamException) {
            throw UnmarshallerImpl.handleStreamException(xMLStreamException);
        }
        Object object = xmlVisitor.getContext().getResult();
        xmlVisitor.getContext().clearResult();
        return object;
    }

    @Override
    public <T> JAXBElement<T> unmarshal(XMLEventReader xMLEventReader, Class<T> clazz) throws JAXBException {
        if (clazz == null) {
            throw new IllegalArgumentException();
        }
        return (JAXBElement)this.unmarshal0(xMLEventReader, this.getBeanInfo(clazz));
    }

    @Override
    public Object unmarshal(XMLEventReader xMLEventReader) throws JAXBException {
        return this.unmarshal0(xMLEventReader, null);
    }

    private Object unmarshal0(XMLEventReader xMLEventReader, JaxBeanInfo jaxBeanInfo) throws JAXBException {
        if (xMLEventReader == null) {
            throw new IllegalArgumentException(Messages.format("Unmarshaller.NullReader"));
        }
        try {
            XMLEvent xMLEvent = xMLEventReader.peek();
            if (!xMLEvent.isStartElement() && !xMLEvent.isStartDocument()) {
                throw new IllegalStateException(Messages.format("Unmarshaller.IllegalReaderState", xMLEvent.getEventType()));
            }
            boolean bl = xMLEventReader.getClass().getName().equals("com.sun.xml.internal.stream.XMLReaderImpl");
            XmlVisitor xmlVisitor = this.createUnmarshallerHandler(null, false, jaxBeanInfo);
            if (!bl) {
                xmlVisitor = new InterningXmlVisitor(xmlVisitor);
            }
            new StAXEventConnector(xMLEventReader, xmlVisitor).bridge();
            return xmlVisitor.getContext().getResult();
        }
        catch (XMLStreamException xMLStreamException) {
            throw UnmarshallerImpl.handleStreamException(xMLStreamException);
        }
    }

    public Object unmarshal0(InputStream inputStream, JaxBeanInfo jaxBeanInfo) throws JAXBException {
        return this.unmarshal0(this.getXMLReader(), new InputSource(inputStream), jaxBeanInfo);
    }

    private static JAXBException handleStreamException(XMLStreamException xMLStreamException) {
        Throwable throwable = xMLStreamException.getNestedException();
        if (throwable instanceof JAXBException) {
            return (JAXBException)throwable;
        }
        if (throwable instanceof SAXException) {
            return new UnmarshalException(throwable);
        }
        return new UnmarshalException(xMLStreamException);
    }

    @Override
    public Object getProperty(String string) throws PropertyException {
        if (string.equals(IDResolver.class.getName())) {
            return this.idResolver;
        }
        return super.getProperty(string);
    }

    @Override
    public void setProperty(String string, Object object) throws PropertyException {
        if (string.equals(FACTORY)) {
            this.coordinator.setFactories(object);
            return;
        }
        if (string.equals(IDResolver.class.getName())) {
            this.idResolver = (IDResolver)object;
            return;
        }
        if (string.equals(ClassResolver.class.getName())) {
            this.coordinator.classResolver = (ClassResolver)object;
            return;
        }
        if (string.equals(ClassLoader.class.getName())) {
            this.coordinator.classLoader = (ClassLoader)object;
            return;
        }
        super.setProperty(string, object);
    }

    @Override
    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public AttachmentUnmarshaller getAttachmentUnmarshaller() {
        return this.attachmentUnmarshaller;
    }

    @Override
    public void setAttachmentUnmarshaller(AttachmentUnmarshaller attachmentUnmarshaller) {
        this.attachmentUnmarshaller = attachmentUnmarshaller;
    }

    @Override
    public boolean isValidating() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setValidating(boolean bl) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <A extends XmlAdapter> void setAdapter(Class<A> clazz, A a) {
        if (clazz == null) {
            throw new IllegalArgumentException();
        }
        this.coordinator.putAdapter(clazz, a);
    }

    @Override
    public <A extends XmlAdapter> A getAdapter(Class<A> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException();
        }
        if (this.coordinator.containsAdapter(clazz)) {
            return this.coordinator.getAdapter(clazz);
        }
        return null;
    }

    @Override
    public UnmarshalException createUnmarshalException(SAXException sAXException) {
        return super.createUnmarshalException(sAXException);
    }

    @Override
    public boolean handleEvent(ValidationEvent validationEvent) {
        return validationEvent.getSeverity() != 2;
    }

    private static InputSource streamSourceToInputSource(StreamSource streamSource) {
        InputSource inputSource = new InputSource();
        inputSource.setSystemId(streamSource.getSystemId());
        inputSource.setByteStream(streamSource.getInputStream());
        inputSource.setCharacterStream(streamSource.getReader());
        return inputSource;
    }

    public <T> JaxBeanInfo<T> getBeanInfo(Class<T> clazz) throws JAXBException {
        return this.context.getBeanInfo(clazz, true);
    }

    @Override
    public Unmarshaller.Listener getListener() {
        return this.externalListener;
    }

    @Override
    public void setListener(Unmarshaller.Listener listener) {
        this.externalListener = listener;
    }

    public UnmarshallingContext getContext() {
        return this.coordinator;
    }
}

