/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.setup.Util;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Window;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;

public class DialogFocusTraversalPolicy
extends FocusTraversalPolicy {
    private JComponent[] order;
    private List list;

    public DialogFocusTraversalPolicy(JComponent[] _order) {
        this.order = _order;
        this.list = Arrays.asList(this.order);
    }

    public Component getFirstComponent(Container focusCycleRoot) {
        return this.order[0];
    }

    public Component getLastComponent(Container focusCycleRoot) {
        return this.order[this.order.length - 1];
    }

    public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
        int index = 0;
        int x = -1;
        index = this.list.indexOf(aComponent);
        if (!this.order[++index % this.order.length].isEnabled() || !this.order[index % this.order.length].isVisible()) {
            x = index;
            index = -1;
            while (x != this.order.length) {
                if (this.order[x].isEnabled() && this.order[x].isVisible()) {
                    index = x;
                    break;
                }
                ++x;
            }
            if (index == -1) {
                x = this.list.indexOf(aComponent);
                for (int y = 0; y <= x; ++y) {
                    if (!this.order[y].isEnabled() || !this.order[x].isVisible()) continue;
                    index = y;
                    break;
                }
            }
        }
        return this.order[index % this.order.length];
    }

    public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
        int index = this.list.indexOf(aComponent);
        int x = -1;
        if (!this.order[(--index + this.order.length) % this.order.length].isEnabled() || !this.order[(index + this.order.length) % this.order.length].isVisible()) {
            x = index;
            index = -1;
            while (x >= 0) {
                if (this.order[x].isEnabled() && this.order[x].isVisible()) {
                    index = x;
                    break;
                }
                --x;
            }
            if (index == -1) {
                x = this.list.indexOf(aComponent);
                for (int y = this.order.length - 1; y >= x; --y) {
                    if (!this.order[y].isEnabled() || !this.order[x].isVisible()) continue;
                    index = y;
                    break;
                }
            }
        }
        return this.order[(index + this.order.length) % this.order.length];
    }

    public Component getDefaultComponent(Container focusCycleRoot) {
        return this.order[0];
    }

    public Component getInitialComponent(Window window) {
        return this.order[0];
    }
}

