/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.setup.Controller;

import org.openoffice.setup.InstallData;
import org.openoffice.setup.Panel.InstallationImminent;
import org.openoffice.setup.PanelController;
import org.openoffice.setup.ResourceManager;
import org.openoffice.setup.SetupData.PackageDescription;
import org.openoffice.setup.SetupData.ProductDescription;
import org.openoffice.setup.SetupData.SetupDataProvider;
import org.openoffice.setup.SetupFrame;
import org.openoffice.setup.Util.InfoCtrl;
import org.openoffice.setup.Util.Informer;
import org.openoffice.setup.Util.LogManager;

public class InstallationImminentCtrl
extends PanelController {
    private String helpFile = "String_Helpfile_InstallationImminent";
    private String htmlInfoText = "";

    public InstallationImminentCtrl() {
        super("InstallationImminent", new InstallationImminent());
    }

    public String getNext() {
        return new String("InstallationOngoing");
    }

    public String getPrevious() {
        InstallData data = InstallData.getInstance();
        if (data.isRootInstallation()) {
            if (data.olderVersionExists()) {
                if (data.hideEula()) {
                    return new String("Prologue");
                }
                return new String("AcceptLicense");
            }
            if (data.sameVersionExists()) {
                return new String("ChooseComponents");
            }
            if (data.getInstallationType().equals(data.getCustomActionCommand())) {
                return new String("ChooseComponents");
            }
            if (data.getInstallationType().equals(data.getTypicalActionCommand())) {
                return new String("ChooseInstallationType");
            }
            System.err.println("Error: Unknown installation type!");
            return new String("Error");
        }
        if (data.olderVersionExists()) {
            return new String("ChooseDirectory");
        }
        if (data.sameVersionExists()) {
            return new String("ChooseComponents");
        }
        if (data.getInstallationType().equals(data.getCustomActionCommand())) {
            return new String("ChooseComponents");
        }
        if (data.getInstallationType().equals(data.getTypicalActionCommand())) {
            return new String("ChooseInstallationType");
        }
        System.err.println("Error: Unknown installation type!");
        return new String("Error");
    }

    public final String getHelpFileName() {
        return this.helpFile;
    }

    public void beforeShow() {
        String StringInstall = ResourceManager.getString("String_Install");
        SetupFrame setupFrame = this.getSetupFrame();
        this.getSetupFrame();
        setupFrame.setButtonText(StringInstall, 1);
        ProductDescription productData = SetupDataProvider.getProductDescription();
        PackageDescription packageData = SetupDataProvider.getPackageDescription();
        this.htmlInfoText = InfoCtrl.setHtmlFrame("header", this.htmlInfoText);
        this.htmlInfoText = InfoCtrl.setReadyToInstallInfoText(productData, this.htmlInfoText);
        this.htmlInfoText = InfoCtrl.setReadyToInstallInfoText(packageData, this.htmlInfoText);
        this.htmlInfoText = InfoCtrl.setHtmlFrame("end", this.htmlInfoText);
        InstallationImminent panel = (InstallationImminent)this.getPanel();
        panel.setInfoText(this.htmlInfoText);
        panel.setCaretPosition();
        InstallData data = InstallData.getInstance();
        if (data.olderVersionExists()) {
            String dialogTitle = ResourceManager.getString("String_InstallationImminent1_Update");
            panel.setTitleText(dialogTitle);
        }
    }

    public void duringShow() {
        InstallationImminent panel = (InstallationImminent)this.getPanel();
        panel.setTabOrder();
    }

    public boolean afterShow(boolean nextButtonPressed) {
        boolean repeatDialog = false;
        if (nextButtonPressed) {
            InstallData data = InstallData.getInstance();
            if (data.getPackagePath() != null) {
                String log = "<b>Packages path:</b> " + data.getPackagePath() + "<br>";
                LogManager.addLogfileComment(log);
            } else {
                String message = ResourceManager.getString("String_InstallationOngoing_PackagePath_Not_Found");
                String title = ResourceManager.getString("String_Error");
                Informer.showErrorMessage(message, title);
                String log = "<b>Error: No path for packages exists!</b><br>";
                LogManager.addLogfileComment(log);
                repeatDialog = true;
            }
        }
        return repeatDialog;
    }
}

