/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp;

import com.sun.jmx.snmp.BerDecoder;
import com.sun.jmx.snmp.BerEncoder;
import com.sun.jmx.snmp.BerException;
import com.sun.jmx.snmp.SnmpEngineId;
import com.sun.jmx.snmp.SnmpMsg;
import com.sun.jmx.snmp.SnmpPdu;
import com.sun.jmx.snmp.SnmpPduBulkType;
import com.sun.jmx.snmp.SnmpPduRequestType;
import com.sun.jmx.snmp.SnmpScopedPduBulk;
import com.sun.jmx.snmp.SnmpScopedPduPacket;
import com.sun.jmx.snmp.SnmpScopedPduRequest;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.SnmpTooBigException;
import com.sun.jmx.trace.Trace;

public class SnmpV3Message
extends SnmpMsg {
    public int msgId = 0;
    public int msgMaxSize = 0;
    public byte msgFlags = 0;
    public int msgSecurityModel = 0;
    public byte[] msgSecurityParameters = null;
    public byte[] contextEngineId = null;
    public byte[] contextName = null;
    public byte[] encryptedPdu = null;
    String dbgTag = "SnmpV3Message";

    public int encodeMessage(byte[] byArray) throws SnmpTooBigException {
        boolean bl = false;
        if (this.isTraceOn()) {
            this.trace("encodeMessage", "Can't encode directly V3Message!!!!! Need a SecuritySubSystem");
        }
        throw new IllegalArgumentException("Can't encode");
    }

    public void decodeMessage(byte[] byArray, int n) throws SnmpStatusException {
        try {
            BerDecoder berDecoder = new BerDecoder(byArray);
            berDecoder.openSequence();
            this.version = berDecoder.fetchInteger();
            berDecoder.openSequence();
            this.msgId = berDecoder.fetchInteger();
            this.msgMaxSize = berDecoder.fetchInteger();
            this.msgFlags = berDecoder.fetchOctetString()[0];
            this.msgSecurityModel = berDecoder.fetchInteger();
            berDecoder.closeSequence();
            this.msgSecurityParameters = berDecoder.fetchOctetString();
            if ((this.msgFlags & 2) == 0) {
                berDecoder.openSequence();
                this.contextEngineId = berDecoder.fetchOctetString();
                this.contextName = berDecoder.fetchOctetString();
                this.data = berDecoder.fetchAny();
                this.dataLength = this.data.length;
                berDecoder.closeSequence();
            } else {
                this.encryptedPdu = berDecoder.fetchOctetString();
            }
            berDecoder.closeSequence();
        }
        catch (BerException berException) {
            berException.printStackTrace();
            throw new SnmpStatusException("Invalid encoding");
        }
        if (this.isTraceOn()) {
            this.trace("decodeMessage", "Unmarshalled message : \nversion :" + this.version + "\n" + "msgId :" + this.msgId + "\n" + "msgMaxSize :" + this.msgMaxSize + "\n" + "msgFlags :" + this.msgFlags + "\n" + "msgSecurityModel :" + this.msgSecurityModel + "\n" + "contextEngineId :" + (this.contextEngineId == null ? null : SnmpEngineId.createEngineId(this.contextEngineId)) + "\n" + "contextName :" + (this.contextName == null ? null : new String(this.contextName)) + "\n" + "data :" + this.data + "\n" + "dat len :" + (this.data == null ? 0 : this.data.length) + "\n" + "encryptedPdu :" + this.encryptedPdu + "\n");
        }
    }

    public int getRequestId(byte[] byArray) throws SnmpStatusException {
        BerDecoder berDecoder = null;
        int n = 0;
        try {
            berDecoder = new BerDecoder(byArray);
            berDecoder.openSequence();
            berDecoder.fetchInteger();
            berDecoder.openSequence();
            n = berDecoder.fetchInteger();
        }
        catch (BerException berException) {
            throw new SnmpStatusException("Invalid encoding");
        }
        try {
            berDecoder.closeSequence();
        }
        catch (BerException berException) {
            // empty catch block
        }
        return n;
    }

    public void encodeSnmpPdu(SnmpPdu snmpPdu, int n) throws SnmpStatusException, SnmpTooBigException {
        SnmpScopedPduPacket snmpScopedPduPacket = (SnmpScopedPduPacket)snmpPdu;
        if (this.isTraceOn()) {
            this.trace("encodeSnmpPdu", "Pdu to marshall: \nsecurity parameters : " + snmpScopedPduPacket.securityParameters + "\n" + "type :" + snmpScopedPduPacket.type + "\n" + "version :" + snmpScopedPduPacket.version + "\n" + "requestId :" + snmpScopedPduPacket.requestId + "\n" + "msgId :" + snmpScopedPduPacket.msgId + "\n" + "msgMaxSize :" + snmpScopedPduPacket.msgMaxSize + "\n" + "msgFlags :" + snmpScopedPduPacket.msgFlags + "\n" + "msgSecurityModel :" + snmpScopedPduPacket.msgSecurityModel + "\n" + "contextEngineId :" + snmpScopedPduPacket.contextEngineId + "\n" + "contextName :" + snmpScopedPduPacket.contextName + "\n");
        }
        this.version = snmpScopedPduPacket.version;
        this.address = snmpScopedPduPacket.address;
        this.port = snmpScopedPduPacket.port;
        this.msgId = snmpScopedPduPacket.msgId;
        this.msgMaxSize = snmpScopedPduPacket.msgMaxSize;
        this.msgFlags = snmpScopedPduPacket.msgFlags;
        this.msgSecurityModel = snmpScopedPduPacket.msgSecurityModel;
        this.contextEngineId = snmpScopedPduPacket.contextEngineId;
        this.contextName = snmpScopedPduPacket.contextName;
        this.securityParameters = snmpScopedPduPacket.securityParameters;
        this.data = new byte[n];
        try {
            BerEncoder berEncoder = new BerEncoder(this.data);
            berEncoder.openSequence();
            this.encodeVarBindList(berEncoder, snmpScopedPduPacket.varBindList);
            switch (snmpScopedPduPacket.type) {
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 166: 
                case 167: 
                case 168: {
                    SnmpPduRequestType snmpPduRequestType = (SnmpPduRequestType)((Object)snmpScopedPduPacket);
                    berEncoder.putInteger(snmpPduRequestType.getErrorIndex());
                    berEncoder.putInteger(snmpPduRequestType.getErrorStatus());
                    berEncoder.putInteger(snmpScopedPduPacket.requestId);
                    break;
                }
                case 165: {
                    SnmpPduBulkType snmpPduBulkType = (SnmpPduBulkType)((Object)snmpScopedPduPacket);
                    berEncoder.putInteger(snmpPduBulkType.getMaxRepetitions());
                    berEncoder.putInteger(snmpPduBulkType.getNonRepeaters());
                    berEncoder.putInteger(snmpScopedPduPacket.requestId);
                    break;
                }
                default: {
                    throw new SnmpStatusException("Invalid pdu type " + String.valueOf(snmpScopedPduPacket.type));
                }
            }
            berEncoder.closeSequence(snmpScopedPduPacket.type);
            this.dataLength = berEncoder.trim();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new SnmpTooBigException();
        }
    }

    public SnmpPdu decodeSnmpPdu() throws SnmpStatusException {
        SnmpScopedPduPacket snmpScopedPduPacket = null;
        BerDecoder berDecoder = new BerDecoder(this.data);
        try {
            int n = berDecoder.getTag();
            berDecoder.openSequence(n);
            switch (n) {
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 166: 
                case 167: 
                case 168: {
                    SnmpScopedPduRequest snmpScopedPduRequest = new SnmpScopedPduRequest();
                    snmpScopedPduRequest.requestId = berDecoder.fetchInteger();
                    snmpScopedPduRequest.setErrorStatus(berDecoder.fetchInteger());
                    snmpScopedPduRequest.setErrorIndex(berDecoder.fetchInteger());
                    snmpScopedPduPacket = snmpScopedPduRequest;
                    break;
                }
                case 165: {
                    SnmpScopedPduBulk snmpScopedPduBulk = new SnmpScopedPduBulk();
                    snmpScopedPduBulk.requestId = berDecoder.fetchInteger();
                    snmpScopedPduBulk.setNonRepeaters(berDecoder.fetchInteger());
                    snmpScopedPduBulk.setMaxRepetitions(berDecoder.fetchInteger());
                    snmpScopedPduPacket = snmpScopedPduBulk;
                    break;
                }
                default: {
                    throw new SnmpStatusException(9);
                }
            }
            snmpScopedPduPacket.type = n;
            snmpScopedPduPacket.varBindList = this.decodeVarBindList(berDecoder);
            berDecoder.closeSequence();
        }
        catch (BerException berException) {
            if (this.isDebugOn()) {
                this.debug("decodeSnmpPdu", berException);
            }
            throw new SnmpStatusException(9);
        }
        snmpScopedPduPacket.address = this.address;
        snmpScopedPduPacket.port = this.port;
        snmpScopedPduPacket.msgFlags = this.msgFlags;
        snmpScopedPduPacket.version = this.version;
        snmpScopedPduPacket.msgId = this.msgId;
        snmpScopedPduPacket.msgMaxSize = this.msgMaxSize;
        snmpScopedPduPacket.msgSecurityModel = this.msgSecurityModel;
        snmpScopedPduPacket.contextEngineId = this.contextEngineId;
        snmpScopedPduPacket.contextName = this.contextName;
        snmpScopedPduPacket.securityParameters = this.securityParameters;
        if (this.isTraceOn()) {
            this.trace("decodeSnmpPdu", "Unmarshalled pdu : \ntype :" + snmpScopedPduPacket.type + "\n" + "version :" + snmpScopedPduPacket.version + "\n" + "requestId :" + snmpScopedPduPacket.requestId + "\n" + "msgId :" + snmpScopedPduPacket.msgId + "\n" + "msgMaxSize :" + snmpScopedPduPacket.msgMaxSize + "\n" + "msgFlags :" + snmpScopedPduPacket.msgFlags + "\n" + "msgSecurityModel :" + snmpScopedPduPacket.msgSecurityModel + "\n" + "contextEngineId :" + snmpScopedPduPacket.contextEngineId + "\n" + "contextName :" + snmpScopedPduPacket.contextName + "\n");
        }
        return snmpScopedPduPacket;
    }

    public String printMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("msgId : " + this.msgId + "\n");
        stringBuffer.append("msgMaxSize : " + this.msgMaxSize + "\n");
        stringBuffer.append("msgFlags : " + this.msgFlags + "\n");
        stringBuffer.append("msgSecurityModel : " + this.msgSecurityModel + "\n");
        if (this.contextEngineId == null) {
            stringBuffer.append("contextEngineId : null");
        } else {
            stringBuffer.append("contextEngineId : {\n");
            stringBuffer.append(SnmpV3Message.dumpHexBuffer(this.contextEngineId, 0, this.contextEngineId.length));
            stringBuffer.append("\n}\n");
        }
        if (this.contextName == null) {
            stringBuffer.append("contextName : null");
        } else {
            stringBuffer.append("contextName : {\n");
            stringBuffer.append(SnmpV3Message.dumpHexBuffer(this.contextName, 0, this.contextName.length));
            stringBuffer.append("\n}\n");
        }
        return stringBuffer.append(super.printMessage()).toString();
    }

    boolean isTraceOn() {
        return Trace.isSelected(1, 512);
    }

    void trace(String string, String string2, String string3) {
        Trace.send(1, 512, string, string2, string3);
    }

    void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    boolean isDebugOn() {
        return Trace.isSelected(2, 512);
    }

    void debug(String string, String string2, String string3) {
        Trace.send(2, 512, string, string2, string3);
    }

    void debug(String string, String string2, Throwable throwable) {
        Trace.send(2, 512, string, string2, throwable);
    }

    void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }

    void debug(String string, Throwable throwable) {
        this.debug(this.dbgTag, string, throwable);
    }
}

