/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.agent;

import com.sun.jmx.snmp.SnmpOid;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.SnmpVarBind;
import com.sun.jmx.snmp.agent.AcmChecker;
import com.sun.jmx.snmp.agent.SnmpMibAgent;
import com.sun.jmx.snmp.agent.SnmpMibNode;
import com.sun.jmx.snmp.agent.SnmpMibOid;
import com.sun.jmx.snmp.agent.SnmpMibRequest;
import com.sun.jmx.snmp.agent.SnmpMibRequestImpl;
import com.sun.jmx.snmp.agent.SnmpMibSubRequest;
import com.sun.jmx.snmp.agent.SnmpMibTable;
import com.sun.jmx.snmp.agent.SnmpRequestTree;
import com.sun.jmx.trace.Trace;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

public abstract class SnmpMib
extends SnmpMibAgent
implements Serializable {
    protected SnmpMibOid root = new SnmpMibOid();
    private transient long[] rootOid = null;

    protected String getGroupOid(String string, String string2) {
        return string2;
    }

    protected ObjectName getGroupObjectName(String string, String string2, String string3) throws MalformedObjectNameException {
        return new ObjectName(string3);
    }

    protected void registerGroupNode(String string, String string2, ObjectName objectName, SnmpMibNode snmpMibNode, Object object, MBeanServer mBeanServer) throws NotCompliantMBeanException, MBeanRegistrationException, InstanceAlreadyExistsException, IllegalAccessException {
        this.root.registerNode(string2, snmpMibNode);
        if (mBeanServer != null && objectName != null && object != null) {
            mBeanServer.registerMBean(object, objectName);
        }
    }

    public abstract void registerTableMeta(String var1, SnmpMibTable var2);

    public abstract SnmpMibTable getRegisteredTableMeta(String var1);

    public void get(SnmpMibRequest snmpMibRequest) throws SnmpStatusException {
        SnmpRequestTree snmpRequestTree = this.getHandlers(snmpMibRequest, false, false, 160);
        SnmpRequestTree.Handler handler = null;
        SnmpMibNode snmpMibNode = null;
        if (SnmpMib.isDebugOn()) {
            SnmpMib.debug("get", "Processing handlers for GET... ");
        }
        Enumeration enumeration = snmpRequestTree.getHandlers();
        while (enumeration.hasMoreElements()) {
            handler = (SnmpRequestTree.Handler)enumeration.nextElement();
            snmpMibNode = snmpRequestTree.getMetaNode(handler);
            int n = snmpRequestTree.getOidDepth(handler);
            Enumeration enumeration2 = snmpRequestTree.getSubRequests(handler);
            while (enumeration2.hasMoreElements()) {
                snmpMibNode.get((SnmpMibSubRequest)enumeration2.nextElement(), n);
            }
        }
    }

    public void set(SnmpMibRequest snmpMibRequest) throws SnmpStatusException {
        SnmpRequestTree snmpRequestTree = null;
        if (snmpMibRequest instanceof SnmpMibRequestImpl) {
            snmpRequestTree = ((SnmpMibRequestImpl)snmpMibRequest).getRequestTree();
        }
        if (snmpRequestTree == null) {
            snmpRequestTree = this.getHandlers(snmpMibRequest, false, true, 163);
        }
        snmpRequestTree.switchCreationFlag(false);
        snmpRequestTree.setPduType(163);
        SnmpRequestTree.Handler handler = null;
        SnmpMibNode snmpMibNode = null;
        if (SnmpMib.isDebugOn()) {
            SnmpMib.debug("set", "Processing handlers for SET... ");
        }
        Enumeration enumeration = snmpRequestTree.getHandlers();
        while (enumeration.hasMoreElements()) {
            handler = (SnmpRequestTree.Handler)enumeration.nextElement();
            snmpMibNode = snmpRequestTree.getMetaNode(handler);
            int n = snmpRequestTree.getOidDepth(handler);
            Enumeration enumeration2 = snmpRequestTree.getSubRequests(handler);
            while (enumeration2.hasMoreElements()) {
                snmpMibNode.set((SnmpMibSubRequest)enumeration2.nextElement(), n);
            }
        }
    }

    public void check(SnmpMibRequest snmpMibRequest) throws SnmpStatusException {
        SnmpRequestTree snmpRequestTree = this.getHandlers(snmpMibRequest, true, true, 253);
        SnmpRequestTree.Handler handler = null;
        SnmpMibNode snmpMibNode = null;
        if (SnmpMib.isDebugOn()) {
            SnmpMib.debug("check", "Processing handlers for CHECK... ");
        }
        Enumeration enumeration = snmpRequestTree.getHandlers();
        while (enumeration.hasMoreElements()) {
            handler = (SnmpRequestTree.Handler)enumeration.nextElement();
            snmpMibNode = snmpRequestTree.getMetaNode(handler);
            int n = snmpRequestTree.getOidDepth(handler);
            Enumeration enumeration2 = snmpRequestTree.getSubRequests(handler);
            while (enumeration2.hasMoreElements()) {
                snmpMibNode.check((SnmpMibSubRequest)enumeration2.nextElement(), n);
            }
        }
        if (snmpMibRequest instanceof SnmpMibRequestImpl) {
            ((SnmpMibRequestImpl)snmpMibRequest).setRequestTree(snmpRequestTree);
        }
    }

    public void getNext(SnmpMibRequest snmpMibRequest) throws SnmpStatusException {
        SnmpRequestTree snmpRequestTree = this.getGetNextHandlers(snmpMibRequest);
        SnmpRequestTree.Handler handler = null;
        SnmpMibNode snmpMibNode = null;
        if (SnmpMib.isDebugOn()) {
            SnmpMib.debug("getNext", "Processing handlers for GET-NEXT... ");
        }
        Enumeration enumeration = snmpRequestTree.getHandlers();
        while (enumeration.hasMoreElements()) {
            handler = (SnmpRequestTree.Handler)enumeration.nextElement();
            snmpMibNode = snmpRequestTree.getMetaNode(handler);
            int n = snmpRequestTree.getOidDepth(handler);
            Enumeration enumeration2 = snmpRequestTree.getSubRequests(handler);
            while (enumeration2.hasMoreElements()) {
                snmpMibNode.get((SnmpMibSubRequest)enumeration2.nextElement(), n);
            }
        }
    }

    public void getBulk(SnmpMibRequest snmpMibRequest, int n, int n2) throws SnmpStatusException {
        this.getBulkWithGetNext(snmpMibRequest, n, n2);
    }

    public long[] getRootOid() {
        if (this.rootOid == null) {
            Vector vector = new Vector(10);
            this.root.getRootOid(vector);
            this.rootOid = new long[vector.size()];
            int n = 0;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Integer n2 = (Integer)enumeration.nextElement();
                this.rootOid[n++] = n2.longValue();
            }
        }
        return this.rootOid;
    }

    private SnmpRequestTree getHandlers(SnmpMibRequest snmpMibRequest, boolean bl, boolean bl2, int n) throws SnmpStatusException {
        SnmpRequestTree snmpRequestTree = new SnmpRequestTree(snmpMibRequest, bl, n);
        int n2 = 0;
        SnmpVarBind snmpVarBind = null;
        int n3 = snmpMibRequest.getVersion();
        Enumeration enumeration = snmpMibRequest.getElements();
        while (enumeration.hasMoreElements()) {
            snmpVarBind = (SnmpVarBind)enumeration.nextElement();
            try {
                this.root.findHandlingNode(snmpVarBind, snmpVarBind.oid.longValue(false), 0, snmpRequestTree);
            }
            catch (SnmpStatusException snmpStatusException) {
                int n4;
                if (SnmpMib.isDebugOn()) {
                    SnmpMib.debug("getHandlers", "Couldn't find a handling node for " + snmpVarBind.oid.toString());
                }
                if (n3 == 0) {
                    if (SnmpMib.isDebugOn()) {
                        SnmpMib.debug("getHandlers", "\tV1: Throwing exception");
                    }
                    SnmpStatusException snmpStatusException2 = new SnmpStatusException(snmpStatusException, n2 + 1);
                    snmpStatusException2.initCause(snmpStatusException);
                    throw snmpStatusException2;
                }
                if (n == 253 || n == 163) {
                    n4 = SnmpRequestTree.mapSetException(snmpStatusException.getStatus(), n3);
                    if (SnmpMib.isDebugOn()) {
                        SnmpMib.debug("getHandlers", "\tSET: Throwing exception");
                    }
                    SnmpStatusException snmpStatusException3 = new SnmpStatusException(n4, n2 + 1);
                    snmpStatusException3.initCause(snmpStatusException);
                    throw snmpStatusException3;
                }
                if (bl2) {
                    if (SnmpMib.isDebugOn()) {
                        SnmpMib.debug("getHandlers", "\tATOMIC: Throwing exception");
                    }
                    SnmpStatusException snmpStatusException4 = new SnmpStatusException(snmpStatusException, n2 + 1);
                    snmpStatusException4.initCause(snmpStatusException);
                    throw snmpStatusException4;
                }
                n4 = SnmpRequestTree.mapGetException(snmpStatusException.getStatus(), n3);
                if (n4 == 224) {
                    if (SnmpMib.isDebugOn()) {
                        SnmpMib.debug("getHandlers", "\tGET: Registering noSuchInstance");
                    }
                    snmpVarBind.value = SnmpVarBind.noSuchInstance;
                }
                if (n4 == 225) {
                    if (SnmpMib.isDebugOn()) {
                        SnmpMib.debug("getHandlers", "\tGET: Registering noSuchObject");
                    }
                    snmpVarBind.value = SnmpVarBind.noSuchObject;
                }
                if (SnmpMib.isDebugOn()) {
                    SnmpMib.debug("getHandlers", "\tGET: Registering global error: " + n4);
                }
                SnmpStatusException snmpStatusException5 = new SnmpStatusException(n4, n2 + 1);
                snmpStatusException5.initCause(snmpStatusException);
                throw snmpStatusException5;
            }
            ++n2;
        }
        return snmpRequestTree;
    }

    private SnmpRequestTree getGetNextHandlers(SnmpMibRequest snmpMibRequest) throws SnmpStatusException {
        SnmpRequestTree snmpRequestTree = new SnmpRequestTree(snmpMibRequest, false, 161);
        snmpRequestTree.setGetNextFlag();
        if (SnmpMib.isDebugOn()) {
            SnmpMib.debug("getGetNextHandlers", "Received MIB request : " + snmpMibRequest);
        }
        AcmChecker acmChecker = new AcmChecker(snmpMibRequest);
        int n = 0;
        SnmpVarBind snmpVarBind = null;
        int n2 = snmpMibRequest.getVersion();
        Object var7_7 = null;
        Enumeration enumeration = snmpMibRequest.getElements();
        while (enumeration.hasMoreElements()) {
            snmpVarBind = (SnmpVarBind)enumeration.nextElement();
            SnmpOid snmpOid = null;
            try {
                if (SnmpMib.isDebugOn()) {
                    SnmpMib.debug("getGetNextHandlers", " Next Oid of :" + snmpVarBind.oid);
                }
                snmpOid = new SnmpOid(this.root.findNextHandlingNode(snmpVarBind, snmpVarBind.oid.longValue(false), 0, 0, snmpRequestTree, acmChecker));
                if (SnmpMib.isDebugOn()) {
                    SnmpMib.debug("getGetNextHandlers", " is :" + snmpOid);
                }
                snmpVarBind.oid = snmpOid;
            }
            catch (SnmpStatusException snmpStatusException) {
                if (n2 == 0) {
                    if (SnmpMib.isDebugOn()) {
                        SnmpMib.debug("getGetNextHandlers", "\tThrowing exception" + snmpStatusException.toString());
                    }
                    throw new SnmpStatusException(snmpStatusException, n + 1);
                }
                if (SnmpMib.isDebugOn()) {
                    SnmpMib.debug("getGetNextHandlers", "Exception : " + snmpStatusException.getStatus());
                }
                snmpVarBind.setSnmpValue(SnmpVarBind.endOfMibView);
            }
            ++n;
        }
        return snmpRequestTree;
    }

    private static final boolean isDebugOn() {
        return Trace.isSelected(2, 256);
    }

    private static final void debug(String string, String string2) {
        Trace.send(2, 256, "SnmpMib", string, string2);
    }
}

