/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.tool;

import gnu.crypto.hash.HashFactory;
import gnu.crypto.hash.IMessageDigest;
import gnu.crypto.util.Util;

public class NessieHashTVEmitter {
    private NessieHashTVEmitter() {
    }

    public static final void main(String[] args) {
        try {
            IMessageDigest md = HashFactory.getInstance(args[0]);
            long time = -System.currentTimeMillis();
            NessieHashTVEmitter.test1(md);
            NessieHashTVEmitter.test2(md);
            NessieHashTVEmitter.test3(md);
            System.out.println();
            System.out.println("End of test vectors");
            System.out.println();
            System.out.println("*** Tests lasted " + (time += System.currentTimeMillis()) + " ms...");
        }
        catch (Exception x) {
            x.printStackTrace(System.err);
        }
    }

    private static void test1(IMessageDigest md) {
        byte[] data = new byte[128];
        System.out.println("Message digests of strings of 0-bits and length L:");
        int i = 0;
        while (i < 128) {
            System.out.print("    L = ");
            String s = "    " + String.valueOf(8 * i);
            System.out.print(s.substring(s.length() - 4));
            System.out.print(": ");
            md.update(data, 0, i);
            byte[] result = md.digest();
            System.out.println(Util.toString(result));
            ++i;
        }
    }

    private static void test2(IMessageDigest md) {
        int bl = md.hashSize();
        byte[] data = new byte[bl];
        System.out.println("Message digests of all " + String.valueOf(8 * bl) + "-bit strings S containing a single 1-bit:");
        int i = 0;
        while (i < bl) {
            int j = 0;
            while (j < 8) {
                data[i] = (byte)(1 << 7 - j);
                System.out.print("    S = " + Util.toString(data) + ": ");
                md.update(data, 0, bl);
                byte[] result = md.digest();
                System.out.println(Util.toString(result));
                data[i] = 0;
                ++j;
            }
            ++i;
        }
    }

    private static void test3(IMessageDigest md) {
        String dummy = System.getProperty("TORTURE");
        if (dummy == null) {
            return;
        }
        int bl = md.hashSize();
        byte[] data = new byte[bl];
        int limit = 100000000;
        System.out.print("Iterated message digest computation (" + String.valueOf(limit) + " times): ");
        int i = 0;
        while (i < limit) {
            md.update(data, 0, bl);
            data = md.digest();
            ++i;
        }
        System.out.println(Util.toString(data));
    }
}

