/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.gnu.crypto.cipher;

import gnu.crypto.cipher.IBlockCipher;
import gnu.crypto.cipher.TripleDES;
import gnu.crypto.util.Util;
import gnu.testlet.TestHarness;
import gnu.testlet.gnu.crypto.cipher.BaseCipherTestCase;
import java.util.HashMap;

public class TestOfTripleDES
extends BaseCipherTestCase {
    static final String[][] E_TV = new String[][]{{"0123456789abcdef0123456789abcdef0123456789abcdef", "4e6f772069732074", "6a2a19f41eca854b"}, {"0123456789abcdef23456789abcdef010123456789abcdef", "4e6f772069732074", "03e69f5bfa58eb42"}, {"0123456789abcdef23456789abcdef01456789abcdef0123", "4e6f772069732074", "dd17e8b8b437d232"}, {"6b085d92976149a46b085d92976149a46b085d92976149a4", "6a2a19f41eca854b", "ce5d6c7b63177c18"}, {"02c4da3d73f226ad1cbce0f2bacd3b1502c4da3d73f226ad", "03e69f5bfa58eb42", "262a60f9743e1fd8"}, {"dc34addf3d9d1fdc976d456702cef4fdad49c2ba0b2f975b", "dd17e8b8b437d232", "3145bcfc1c19382f"}};
    static final String[][] D_TV = new String[][]{{"0123456789abcdef0123456789abcdef0123456789abcdef", "4e6f772069732074", "cdd64f2f9427c15d"}, {"0123456789abcdef23456789abcdef010123456789abcdef", "4e6f772069732074", "6996c8fa47a2abeb"}, {"0123456789abcdef23456789abcdef01456789abcdef0123", "4e6f772069732074", "8325397644091a0a"}, {"cdf40b491c8c0db3cdf40b491c8c0db3cdf40b491c8c0db3", "cdd64f2f9427c15d", "5bb675e3db3a7f3b"}, {"68b58c9dce086704529dce3719e9e0da68b58c9dce086704", "6996c8fa47a2abeb", "6b177e016e6ae12d"}, {"83077c10cda2d6e5296240fd8c834fcd8fdac4fbe5ae978f", "8325397644091a0a", "c67901abdc008c89"}};

    public void test(TestHarness harness) {
        harness.checkPoint("TestOfTripleDES");
        this.cipher = new TripleDES();
        HashMap<String, Object> attrib = new HashMap<String, Object>();
        attrib.put("gnu.crypto.cipher.block.size", new Integer(8));
        attrib.put("gnu.crypto.cipher.key.material", new byte[24]);
        try {
            harness.check(this.validityTest(), "validityTest()");
            harness.check(this.cloneabilityTest(), "cloneabilityTest()");
            harness.check(this.vectorsTest(), "vectorsTest()");
        }
        catch (Exception x) {
            x.printStackTrace();
            harness.debug(x);
            harness.fail("TestOfTripleDES");
        }
    }

    protected boolean cloneabilityTest() throws Exception {
        int blockSize = this.cipher.defaultBlockSize();
        int keySize = this.cipher.defaultKeySize();
        byte[] pt = new byte[blockSize];
        byte[] ct1 = new byte[blockSize];
        byte[] ct2 = new byte[blockSize];
        byte[] kb = new byte[keySize];
        HashMap<String, byte[]> attributes = new HashMap<String, byte[]>();
        attributes.put("gnu.crypto.cipher.key.material", kb);
        this.cipher.reset();
        this.cipher.init(attributes);
        this.cipher.encryptBlock(pt, 0, pt, 0);
        IBlockCipher thomas = (IBlockCipher)this.cipher.clone();
        thomas.init(attributes);
        this.cipher.encryptBlock(pt, 0, ct1, 0);
        thomas.encryptBlock(pt, 0, ct2, 0);
        return Util.areEqual((byte[])ct1, (byte[])ct2);
    }

    protected boolean vectorsTest() throws Exception {
        byte[] ct1;
        byte[] pt;
        byte[] kb;
        HashMap<String, byte[]> attrib = new HashMap<String, byte[]>();
        byte[] ct2 = new byte[8];
        byte[] cpt = new byte[8];
        int i = 0;
        while (i < E_TV.length) {
            kb = Util.toBytesFromString((String)E_TV[i][0]);
            pt = Util.toBytesFromString((String)E_TV[i][1]);
            ct1 = Util.toBytesFromString((String)E_TV[i][2]);
            attrib.put("gnu.crypto.cipher.key.material", kb);
            this.cipher.reset();
            this.cipher.init(attrib);
            this.cipher.encryptBlock(pt, 0, ct2, 0);
            int j = 0;
            while (j < 9999) {
                this.cipher.encryptBlock(ct2, 0, ct2, 0);
                ++j;
            }
            if (!Util.areEqual((byte[])ct1, (byte[])ct2)) {
                return false;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < D_TV.length) {
            kb = Util.toBytesFromString((String)D_TV[i2][0]);
            pt = Util.toBytesFromString((String)D_TV[i2][1]);
            ct1 = Util.toBytesFromString((String)D_TV[i2][2]);
            attrib.put("gnu.crypto.cipher.key.material", kb);
            this.cipher.reset();
            this.cipher.init(attrib);
            this.cipher.decryptBlock(pt, 0, ct2, 0);
            int j = 0;
            while (j < 9999) {
                this.cipher.decryptBlock(ct2, 0, ct2, 0);
                ++j;
            }
            if (!Util.areEqual((byte[])ct1, (byte[])ct2)) {
                return false;
            }
            ++i2;
        }
        return true;
    }
}

