/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.gnu.crypto.prng;

import gnu.crypto.prng.IRandom;
import gnu.crypto.prng.PRNGFactory;
import gnu.crypto.util.Util;
import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.util.HashMap;
import java.util.Map;

public class TestOfARCFour
implements Testlet {
    private byte[] pt;
    private byte[] kb;
    private byte[] ct;
    private HashMap attrib = new HashMap();
    private IRandom keystream;

    public void test(TestHarness harness) {
        int i;
        byte[] cct;
        harness.checkPoint("TestOfARCFour.testVectorOne");
        try {
            this.attrib.clear();
            this.keystream = PRNGFactory.getInstance((String)"arcfour");
            this.pt = new byte[8];
            this.kb = Util.toBytesFromString((String)"0123456789ABCDEF");
            this.ct = Util.toBytesFromString((String)"7494C2E7104B0879");
            this.attrib.put("gnu.crypto.prng.arcfour.key-material", this.kb);
            this.keystream.init((Map)this.attrib);
            byte[] sb = new byte[8];
            this.keystream.nextBytes(sb, 0, 8);
            harness.check(Util.areEqual((byte[])this.ct, (byte[])sb));
        }
        catch (Exception e) {
            harness.debug(e);
            harness.fail("TestOfARCFour.testVectorOne");
        }
        harness.checkPoint("TestOfARCFour.testVectorTwo");
        try {
            this.attrib.clear();
            this.keystream = PRNGFactory.getInstance((String)"arcfour");
            this.pt = Util.toBytesFromString((String)"DCEE4CF92C");
            this.kb = Util.toBytesFromString((String)"618A63D2FB");
            this.ct = Util.toBytesFromString((String)"F13829C9DE");
            this.attrib.put("gnu.crypto.prng.arcfour.key-material", this.kb);
            this.keystream.init((Map)this.attrib);
            cct = new byte[this.pt.length];
            i = 0;
            while (i < this.pt.length) {
                cct[i] = (byte)(this.pt[i] ^ this.keystream.nextByte());
                ++i;
            }
            harness.check(Util.areEqual((byte[])cct, (byte[])this.ct));
        }
        catch (Exception e) {
            harness.debug(e);
            harness.fail("TestOfARCFour.testVectorTwo");
        }
        harness.checkPoint("TestOfARCFour.testVectorThree");
        try {
            this.attrib.clear();
            this.keystream = PRNGFactory.getInstance((String)"arcfour");
            this.pt = Util.toBytesFromString((String)"527569736C696E6E756E206C61756C75206B6F727669737373616E692C2074E4686BE470E46964656E2070E4E46C6CE42074E47973696B75752E204B6573E479F66E206F6E206F6E6E69206F6D616E616E692C206B61736B6973617675756E206C61616B736F7420766572686F75752E20456E206D6120696C6F697473652C20737572652068756F6B61612C206D75747461206D657473E46E2074756D6D757573206D756C6C652074756F6B61612E205075756E746F2070696C76656E2C206D692068756B6B75752C207369696E746F20766172616E207475756C6973656E2C206D69206E756B6B75752E2054756F6B7375742076616E616D6F6E206A61207661726A6F74207665656E2C206E69697374E420737964E46D656E69206C61756C756E207465656E2E202D2045696E6F204C65696E6F");
            this.kb = Util.toBytesFromString((String)"29041972FB42BA5FC7127712F13829C9");
            this.ct = Util.toBytesFromString((String)"358186999001E6B5DAF05ECEEB7EEE21E0689C1F00EEA81F7DD2CAAEE1D2763E68AF0EAD33D66C268BC946C484FBE94C5F5E0B86A59279E4F824E7A640BD223210B0A61160B7BCE986EA65688003596B630A6B90F8E0CAF6912A98EB872176E83C202CAA64166D2CCE57FF1BCA57B213F0ED1AA72FB8EA52B0BE01CD1E412867720B326EB389D011BD70D8AF035FB0D8589DBCE3C666F5EA8D4C7954C50C3F340B0467F81B425961C11843074DF620F208404B394CF9D37FF54B5F1AD8F6EA7DA3C561DFA7281F964463D2CC35A4D1B03490DEC51B0711FBD6F55F79234D5B7C766622A66DE92BE996461D5E4DC878EF9BCA030521E8351E4BAED2FD04F9467368C4AD6AC186D08245B263A2666D1F6C5420F1599DFD9F438921C2F5A463938CE0982265EEF70179BC553F339EB1A4C1AF5F6A547F");
            this.attrib.put("gnu.crypto.prng.arcfour.key-material", this.kb);
            this.keystream.init((Map)this.attrib);
            cct = new byte[this.pt.length];
            i = 0;
            while (i < this.pt.length) {
                cct[i] = (byte)(this.pt[i] ^ this.keystream.nextByte());
                ++i;
            }
            harness.check(Util.areEqual((byte[])cct, (byte[])this.ct));
        }
        catch (Exception e) {
            harness.debug(e);
            harness.fail("TestOfARCFour.testVectorThree");
        }
        harness.checkPoint("TestOfARCFour.testCloneability");
        try {
            this.attrib.clear();
            this.keystream = PRNGFactory.getInstance((String)"arcfour");
            this.attrib.put("gnu.crypto.prng.arcfour.key-material", new byte[0]);
            byte[] b1 = new byte[16];
            byte[] b2 = new byte[16];
            IRandom r1 = PRNGFactory.getInstance((String)"arcfour");
            r1.init((Map)this.attrib);
            r1.nextBytes(b1, 0, b1.length);
            IRandom r2 = (IRandom)r1.clone();
            r1.nextBytes(b1, 0, b1.length);
            r2.nextBytes(b2, 0, b1.length);
            harness.check(Util.areEqual((byte[])b1, (byte[])b2));
        }
        catch (Exception e) {
            harness.debug(e);
            harness.fail("TestOfARCFour.testCloneability");
        }
    }
}

