/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.sig.dss;

import gnu.crypto.hash.IMessageDigest;
import gnu.crypto.hash.Sha160;
import gnu.crypto.sig.BaseSignature;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;

public class DSSSignature
extends BaseSignature {
    public DSSSignature() {
        super("dss", new Sha160());
    }

    private DSSSignature(DSSSignature that) {
        this();
        this.publicKey = that.publicKey;
        this.privateKey = that.privateKey;
        this.md = (IMessageDigest)that.md.clone();
    }

    public Object clone() {
        return new DSSSignature(this);
    }

    protected void setupForVerification(PublicKey k) throws IllegalArgumentException {
        if (!(k instanceof DSAPublicKey)) {
            throw new IllegalArgumentException();
        }
        this.publicKey = (DSAPublicKey)k;
    }

    protected void setupForSigning(PrivateKey k) throws IllegalArgumentException {
        if (!(k instanceof DSAPrivateKey)) {
            throw new IllegalArgumentException();
        }
        this.privateKey = (DSAPrivateKey)k;
    }

    protected Object generateSignature() throws IllegalStateException {
        BigInteger s;
        BigInteger k;
        BigInteger r;
        BigInteger p = ((DSAPrivateKey)this.privateKey).getParams().getP();
        BigInteger q = ((DSAPrivateKey)this.privateKey).getParams().getQ();
        BigInteger g = ((DSAPrivateKey)this.privateKey).getParams().getG();
        BigInteger x = ((DSAPrivateKey)this.privateKey).getX();
        BigInteger m = new BigInteger(1, this.md.digest());
        byte[] kb = new byte[20];
        do {
            this.nextRandomBytes(kb);
            k = new BigInteger(1, kb);
            k.clearBit(159);
        } while ((r = g.modPow(k, p).mod(q)).equals(BigInteger.ZERO) || (s = m.add(x.multiply(r)).multiply(k.modInverse(q)).mod(q)).equals(BigInteger.ZERO));
        return this.encodeSignature(r, s);
    }

    protected boolean verifySignature(Object sig) throws IllegalStateException {
        BigInteger[] dsa = this.decodeSignature(sig);
        BigInteger r = dsa[0];
        BigInteger s = dsa[1];
        BigInteger g = ((DSAPublicKey)this.publicKey).getParams().getG();
        BigInteger p = ((DSAPublicKey)this.publicKey).getParams().getP();
        BigInteger q = ((DSAPublicKey)this.publicKey).getParams().getQ();
        BigInteger y = ((DSAPublicKey)this.publicKey).getY();
        BigInteger w = s.modInverse(q);
        byte[] bytes = this.md.digest();
        BigInteger u1 = w.multiply(new BigInteger(1, bytes)).mod(q);
        BigInteger u2 = r.multiply(w).mod(q);
        BigInteger v = g.modPow(u1, p).multiply(y.modPow(u2, p)).mod(p).mod(q);
        return v.equals(r);
    }

    private Object encodeSignature(BigInteger r, BigInteger s) {
        return new BigInteger[]{r, s};
    }

    private BigInteger[] decodeSignature(Object signature) {
        return (BigInteger[])signature;
    }
}

