/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.sig.rsa;

import java.io.PrintWriter;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;

public class RSA {
    private static final String NAME = "rsa-util";
    private static final boolean DEBUG = false;
    private static final int debuglevel = 9;
    private static final PrintWriter err = new PrintWriter(System.out, true);
    private static final BigInteger ZERO = BigInteger.ZERO;
    private static final BigInteger ONE = BigInteger.ONE;
    private static final BigInteger TWO = BigInteger.valueOf(2L);

    private static void debug(String s) {
        err.println(">>> rsa-util: " + s);
    }

    private RSA() {
    }

    public static BigInteger sign(PrivateKey K, BigInteger m) {
        if (!(K instanceof RSAPrivateKey)) {
            throw new IllegalArgumentException("invalid key");
        }
        BigInteger n = ((RSAPrivateKey)K).getModulus();
        if (m.compareTo(ZERO) < 0 || m.compareTo(n.subtract(ONE)) > 0) {
            throw new IllegalArgumentException("message representative out of range");
        }
        BigInteger result = null;
        if (!(K instanceof RSAPrivateCrtKey)) {
            BigInteger d = ((RSAPrivateKey)K).getPrivateExponent();
            result = m.modPow(d, n);
        } else {
            BigInteger p = ((RSAPrivateCrtKey)K).getPrimeP();
            BigInteger q = ((RSAPrivateCrtKey)K).getPrimeQ();
            BigInteger dP = ((RSAPrivateCrtKey)K).getPrimeExponentP();
            BigInteger dQ = ((RSAPrivateCrtKey)K).getPrimeExponentQ();
            BigInteger qInv = ((RSAPrivateCrtKey)K).getCrtCoefficient();
            BigInteger s1 = m.modPow(dP, p);
            BigInteger s2 = m.modPow(dQ, q);
            BigInteger h = s1.subtract(s2).multiply(qInv).mod(p);
            result = s2.add(q.multiply(h));
        }
        return result;
    }

    public static BigInteger verify(PublicKey K, BigInteger s) {
        if (!(K instanceof RSAPublicKey)) {
            throw new IllegalArgumentException("wrong key");
        }
        BigInteger n = ((RSAPublicKey)K).getModulus();
        BigInteger e = ((RSAPublicKey)K).getPublicExponent();
        if (s.compareTo(ZERO) < 0 || s.compareTo(n.subtract(ONE)) > 0) {
            throw new IllegalArgumentException("signature representative out of range");
        }
        BigInteger result = s.modPow(e, n);
        return result;
    }
}

