/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.util;

import gnu.crypto.util.PRNG;
import java.io.PrintWriter;
import java.math.BigInteger;

public class Prime {
    private static final String NAME = "prime";
    private static final boolean DEBUG = false;
    private static final int debuglevel = 1;
    private static final PrintWriter err = new PrintWriter(System.out, true);
    private static final boolean DO_MILLER_RABIN = false;
    private static final BigInteger ZERO = BigInteger.ZERO;
    private static final BigInteger ONE = BigInteger.ONE;
    private static final BigInteger TWO = BigInteger.valueOf(2L);
    private static final int SMALL_PRIME_COUNT = 1000;
    private static final BigInteger[] SMALL_PRIME = new BigInteger[1000];

    private static void debug(String s) {
        err.println(">>> prime: " + s);
    }

    private Prime() {
    }

    public static boolean hasSmallPrimeDivisor(BigInteger w) {
        int i = 0;
        while (i < 1000) {
            BigInteger prime = SMALL_PRIME[i];
            if (w.mod(prime).equals(ZERO)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean passEulerCriterion(BigInteger w) {
        int k;
        BigInteger A;
        BigInteger w_minus_one;
        BigInteger e = w_minus_one = w.subtract(ONE);
        int l = e.and(BigInteger.valueOf(7L)).intValue();
        int j = 1;
        if ((l & 7) != 0) {
            e = e.shiftRight(1);
            A = TWO.modPow(e, w);
            if ((l & 7) == 6) {
                if (A.bitCount() != 1) {
                    return false;
                }
                k = 1;
            } else {
                if (!(A = A.add(ONE)).equals(w)) {
                    return false;
                }
                k = 1;
                if ((l & 4) != 0) {
                    e = e.shiftRight(1);
                    k = 2;
                }
            }
        } else {
            A = TWO.modPow(e = e.shiftRight(2), w);
            if (A.bitCount() == 1) {
                j = 0;
            } else if (!(A = A.add(ONE)).equals(w)) {
                return false;
            }
            k = e.getLowestSetBit();
            e = e.shiftRight(k);
            k += 2;
        }
        int i = j;
        while (i < 13) {
            A = SMALL_PRIME[i];
            if ((A = A.modPow(e, w)).bitCount() != 1) {
                l = k;
                while (!A.equals(w_minus_one)) {
                    if (--l == 0) {
                        return false;
                    }
                    if ((A = A.modPow(TWO, w)).bitCount() != 1) continue;
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public static boolean passFermatLittleTheorem(BigInteger w) {
        BigInteger w_minus_one = w.subtract(ONE);
        boolean result = TWO.modPow(w_minus_one, w).equals(ONE);
        return result;
    }

    public static boolean passMillerRabin(BigInteger w) {
        int wbitlen = w.bitLength();
        int n = wbitlen < 500 ? 18 : (wbitlen < 550 ? 6 : (wbitlen < 650 ? 5 : (wbitlen < 850 ? 4 : 3)));
        BigInteger w_minus_one = w.subtract(ONE);
        int a = w_minus_one.getLowestSetBit();
        BigInteger m = w_minus_one.shiftRight(a);
        int wlen = wbitlen / 8;
        byte[] kb = new byte[wlen];
        int i = 0;
        while (i < n) {
            BigInteger b;
            do {
                PRNG.nextBytes(kb);
            } while (ONE.compareTo(b = new BigInteger(1, kb)) < 0 && b.compareTo(w) < 0);
            int j = 0;
            BigInteger z = b.modPow(m, w);
            while (!(j == 0 && z.equals(ONE) || z.equals(w_minus_one))) {
                if (j > 0 && z.equals(ONE) || ++j >= a) {
                    return false;
                }
                z = z.modPow(TWO, w);
            }
            ++i;
        }
        return true;
    }

    public static boolean isProbablePrime(BigInteger w) {
        return Prime.isProbablePrime(w, false);
    }

    public static boolean isProbablePrime(BigInteger w, boolean doMillerRabin) {
        if (w.equals(ZERO)) {
            return false;
        }
        if (w.equals(ONE)) {
            return true;
        }
        if (Prime.hasSmallPrimeDivisor(w)) {
            return false;
        }
        if (!Prime.passEulerCriterion(w)) {
            return false;
        }
        return !doMillerRabin || Prime.passMillerRabin(w);
        {
        }
    }

    static {
        long time = -System.currentTimeMillis();
        Prime.SMALL_PRIME[0] = TWO;
        int N = 3;
        int J = 0;
        block0: while (true) {
            Prime.SMALL_PRIME[++J] = BigInteger.valueOf(N);
            if (J >= 999) break;
            block1: while (true) {
                N += 2;
                int K = 1;
                while (true) {
                    int prime;
                    if (N % (prime = SMALL_PRIME[K].intValue()) == 0) continue block1;
                    if (N / prime <= prime) continue block0;
                    ++K;
                }
                break;
            }
            break;
        }
        long l = time + System.currentTimeMillis();
    }
}

