/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.util;

import gnu.crypto.prng.IRandom;
import gnu.crypto.prng.LimitReachedException;
import gnu.crypto.prng.MDGenerator;
import java.util.HashMap;

public class PRNG {
    private static final boolean REPRODUCIBLE = true;
    private static final IRandom singleton = new MDGenerator();

    private PRNG() {
    }

    public static void nextBytes(byte[] buffer) {
        PRNG.nextBytes(buffer, 0, buffer.length);
    }

    public static void nextBytes(byte[] buffer, int offset, int length) {
        try {
            singleton.nextBytes(buffer, offset, length);
        }
        catch (LimitReachedException x) {
            try {
                HashMap map = new HashMap();
                singleton.init(map);
                singleton.nextBytes(buffer, offset, length);
            }
            catch (Exception y) {
                throw new ExceptionInInitializerError(y);
            }
        }
    }

    static {
        try {
            HashMap map = new HashMap();
            singleton.init(map);
        }
        catch (Exception x) {
            throw new ExceptionInInitializerError(x);
        }
    }
}

