/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.hash;

import gnu.crypto.hash.BaseHash;
import gnu.crypto.util.Util;

public class MD2
extends BaseHash {
    private static final int DIGEST_LENGTH = 16;
    private static final int BLOCK_LENGTH = 16;
    private static final byte[] PI = new byte[]{41, 46, 67, -55, -94, -40, 124, 1, 61, 54, 84, -95, -20, -16, 6, 19, 98, -89, 5, -13, -64, -57, 115, -116, -104, -109, 43, -39, -68, 76, -126, -54, 30, -101, 87, 60, -3, -44, -32, 22, 103, 66, 111, 24, -118, 23, -27, 18, -66, 78, -60, -42, -38, -98, -34, 73, -96, -5, -11, -114, -69, 47, -18, 122, -87, 104, 121, -111, 21, -78, 7, 63, -108, -62, 16, -119, 11, 34, 95, 33, -128, 127, 93, -102, 90, -112, 50, 39, 53, 62, -52, -25, -65, -9, -105, 3, -1, 25, 48, -77, 72, -91, -75, -47, -41, 94, -110, 42, -84, 86, -86, -58, 79, -72, 56, -46, -106, -92, 125, -74, 118, -4, 107, -30, -100, 116, 4, -15, 69, -99, 112, 89, 100, 113, -121, 32, -122, 91, -49, 101, -26, 45, -88, 2, 27, 96, 37, -83, -82, -80, -71, -10, 28, 70, 97, 105, 52, 64, 126, 15, 85, 71, -93, 35, -35, 81, -81, 58, -61, 92, -7, -50, -70, -59, -22, 38, 44, 83, 13, 110, -123, 40, -124, 9, -45, -33, -51, -12, 65, -127, 77, 82, 106, -36, 55, -56, 108, -63, -85, -6, 36, -31, 123, 8, 12, -67, -79, 74, 120, -120, -107, -117, -29, 99, -24, 109, -23, -53, -43, -2, 59, 0, 29, 57, -14, -17, -73, 14, 102, 88, -48, -28, -90, 119, 114, -8, -21, 117, 75, 10, 49, 68, 80, -76, -113, -19, 31, 26, -37, -103, -115, 51, -97, 17, -125, 20};
    private static final String DIGEST0 = "8350E5A3E24C153DF2275C9F80692773";
    private static Boolean valid;
    private byte[] checksum;
    private byte[] work;

    public MD2() {
        super("md2", 16, 16);
    }

    private MD2(MD2 md2) {
        this();
        this.count = md2.count;
        this.buffer = (byte[])md2.buffer.clone();
        this.checksum = (byte[])md2.checksum.clone();
        this.work = (byte[])md2.work.clone();
    }

    public Object clone() {
        return new MD2(this);
    }

    protected byte[] getResult() {
        byte[] result = new byte[16];
        this.encryptBlock(this.checksum, 0);
        for (int i = 0; i < 16; ++i) {
            result[i] = this.work[i];
        }
        return result;
    }

    protected void resetContext() {
        this.checksum = new byte[16];
        this.work = new byte[48];
    }

    public boolean selfTest() {
        if (valid == null) {
            valid = new Boolean(DIGEST0.equals(Util.toString(new MD2().digest())));
        }
        return valid;
    }

    protected byte[] padBuffer() {
        int length = 16 - (int)(this.count % (long)16);
        if (length == 0) {
            length = 16;
        }
        byte[] pad = new byte[length];
        for (int i = 0; i < length; ++i) {
            pad[i] = (byte)length;
        }
        return pad;
    }

    protected void transform(byte[] in, int off) {
        this.updateCheckSumAndEncryptBlock(in, off);
    }

    private void encryptBlock(byte[] in, int off) {
        for (int i = 0; i < 16; ++i) {
            byte b;
            this.work[16 + i] = b = in[off + i];
            this.work[32 + i] = this.work[i] ^ b;
        }
        int t = 0;
        for (int i = 0; i < 18; ++i) {
            for (int j = 0; j < 48; ++j) {
                this.work[j] = t = this.work[j] ^ PI[t & 0xFF];
            }
            t = (byte)i + t;
        }
    }

    private void updateCheckSumAndEncryptBlock(byte[] in, int off) {
        int l = this.checksum[15];
        for (int i = 0; i < 16; ++i) {
            byte b;
            this.work[16 + i] = b = in[off + i];
            this.work[32 + i] = this.work[i] ^ b;
            this.checksum[i] = l = this.checksum[i] ^ PI[(b ^ l) & 0xFF];
        }
        int t = 0;
        for (int i = 0; i < 18; ++i) {
            for (int j = 0; j < 48; ++j) {
                this.work[j] = t = this.work[j] ^ PI[t & 0xFF];
            }
            t = (byte)i + t;
        }
    }

    static {
        DIGEST0 = DIGEST0;
    }
}

