/* mapierr.cpp - MAPI error codes
 * Copyright (C) 2019 g10 Code GmbH
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.:
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#include "mapierr.h"

#include <unordered_map>

static std::unordered_map<int, const char *> mapiErrMap = {
  {MAPI_W_NO_SERVICE, "MAPI_W_NO_SERVICE"},
  {MAPI_W_ERRORS_RETURNED, "MAPI_W_ERRORS_RETURNED"},
  {MAPI_W_POSITION_CHANGED, "MAPI_W_POSITION_CHANGED"},
  {MAPI_W_APPROX_COUNT, "MAPI_W_APPROX_COUNT"},
  {MAPI_W_CANCEL_MESSAGE, "MAPI_W_CANCEL_MESSAGE"},
  {MAPI_W_PARTIAL_COMPLETION, "MAPI_W_PARTIAL_COMPLETION"},
  {MAPI_E_INTERFACE_NOT_SUPPORTED, "MAPI_E_INTERFACE_NOT_SUPPORTED"},
  {MAPI_E_CALL_FAILED, "MAPI_E_CALL_FAILED"},
  {MAPI_E_NO_SUPPORT, "MAPI_E_NO_SUPPORT"},
  {MAPI_E_BAD_CHARWIDTH, "MAPI_E_BAD_CHARWIDTH"},
  {MAPI_E_STRING_TOO_LONG, "MAPI_E_STRING_TOO_LONG"},
  {MAPI_E_UNKNOWN_FLAGS, "MAPI_E_UNKNOWN_FLAGS"},
  {MAPI_E_INVALID_ENTRYID, "MAPI_E_INVALID_ENTRYID"},
  {MAPI_E_INVALID_OBJECT, "MAPI_E_INVALID_OBJECT"},
  {MAPI_E_OBJECT_CHANGED, "MAPI_E_OBJECT_CHANGED"},
  {MAPI_E_OBJECT_DELETED, "MAPI_E_OBJECT_DELETED"},
  {MAPI_E_BUSY, "MAPI_E_BUSY"},
  {MAPI_E_NOT_ENOUGH_DISK, "MAPI_E_NOT_ENOUGH_DISK"},
  {MAPI_E_NOT_ENOUGH_RESOURCES, "MAPI_E_NOT_ENOUGH_RESOURCES"},
  {MAPI_E_NOT_FOUND, "MAPI_E_NOT_FOUND"},
  {MAPI_E_VERSION, "MAPI_E_VERSION"},
  {MAPI_E_LOGON_FAILED, "MAPI_E_LOGON_FAILED"},
  {MAPI_E_SESSION_LIMIT, "MAPI_E_SESSION_LIMIT"},
  {MAPI_E_USER_CANCEL, "MAPI_E_USER_CANCEL"},
  {MAPI_E_UNABLE_TO_ABORT, "MAPI_E_UNABLE_TO_ABORT"},
  {MAPI_E_NETWORK_ERROR, "MAPI_E_NETWORK_ERROR"},
  {MAPI_E_DISK_ERROR, "MAPI_E_DISK_ERROR"},
  {MAPI_E_TOO_COMPLEX, "MAPI_E_TOO_COMPLEX"},
  {MAPI_E_BAD_COLUMN, "MAPI_E_BAD_COLUMN"},
  {MAPI_E_EXTENDED_ERROR, "MAPI_E_EXTENDED_ERROR"},
  {MAPI_E_COMPUTED, "MAPI_E_COMPUTED"},
  {MAPI_E_CORRUPT_DATA, "MAPI_E_CORRUPT_DATA"},
  {MAPI_E_UNCONFIGURED, "MAPI_E_UNCONFIGURED"},
  {MAPI_E_FAILONEPROVIDER, "MAPI_E_FAILONEPROVIDER"},
  {MAPI_E_UNKNOWN_CPID, "MAPI_E_UNKNOWN_CPID"},
  {MAPI_E_UNKNOWN_LCID, "MAPI_E_UNKNOWN_LCID"},
  {MAPI_E_PASSWORD_CHANGE_REQUIRED, "MAPI_E_PASSWORD_CHANGE_REQUIRED"},
  {MAPI_E_PASSWORD_EXPIRED, "MAPI_E_PASSWORD_EXPIRED"},
  {MAPI_E_INVALID_WORKSTATION_ACCOUNT, "MAPI_E_INVALID_WORKSTATION_ACCOUNT"},
  {MAPI_E_INVALID_ACCESS_TIME, "MAPI_E_INVALID_ACCESS_TIME"},
  {MAPI_E_ACCOUNT_DISABLED, "MAPI_E_ACCOUNT_DISABLED"},
  {MAPI_E_END_OF_SESSION, "MAPI_E_END_OF_SESSION"},
  {MAPI_E_UNKNOWN_ENTRYID, "MAPI_E_UNKNOWN_ENTRYID"},
  {MAPI_E_MISSING_REQUIRED_COLUMN, "MAPI_E_MISSING_REQUIRED_COLUMN"},
  {MAPI_E_BAD_VALUE, "MAPI_E_BAD_VALUE"},
  {MAPI_E_INVALID_TYPE, "MAPI_E_INVALID_TYPE"},
  {MAPI_E_TYPE_NO_SUPPORT, "MAPI_E_TYPE_NO_SUPPORT"},
  {MAPI_E_UNEXPECTED_TYPE, "MAPI_E_UNEXPECTED_TYPE"},
  {MAPI_E_TOO_BIG, "MAPI_E_TOO_BIG"},
  {MAPI_E_DECLINE_COPY, "MAPI_E_DECLINE_COPY"},
  {MAPI_E_UNEXPECTED_ID, "MAPI_E_UNEXPECTED_ID"},
  {MAPI_E_UNABLE_TO_COMPLETE, "MAPI_E_UNABLE_TO_COMPLETE"},
  {MAPI_E_TIMEOUT, "MAPI_E_TIMEOUT"},
  {MAPI_E_TABLE_EMPTY, "MAPI_E_TABLE_EMPTY"},
  {MAPI_E_TABLE_TOO_BIG, "MAPI_E_TABLE_TOO_BIG"},
  {MAPI_E_INVALID_BOOKMARK, "MAPI_E_INVALID_BOOKMARK"},
  {MAPI_E_WAIT, "MAPI_E_WAIT"},
  {MAPI_E_CANCEL, "MAPI_E_CANCEL"},
  {MAPI_E_NOT_ME, "MAPI_E_NOT_ME"},
  {MAPI_E_CORRUPT_STORE, "MAPI_E_CORRUPT_STORE"},
  {MAPI_E_NOT_IN_QUEUE, "MAPI_E_NOT_IN_QUEUE"},
  {MAPI_E_NO_SUPPRESS, "MAPI_E_NO_SUPPRESS"},
  {MAPI_E_COLLISION, "MAPI_E_COLLISION"},
  {MAPI_E_NOT_INITIALIZED, "MAPI_E_NOT_INITIALIZED"},
  {MAPI_E_NON_STANDARD, "MAPI_E_NON_STANDARD"},
  {MAPI_E_NO_RECIPIENTS, "MAPI_E_NO_RECIPIENTS"},
  {MAPI_E_SUBMITTED, "MAPI_E_SUBMITTED"},
  {MAPI_E_HAS_FOLDERS, "MAPI_E_HAS_FOLDERS"},
  {MAPI_E_HAS_MESSAGES, "MAPI_E_HAS_MESSAGES"},
  {MAPI_E_FOLDER_CYCLE, "MAPI_E_FOLDER_CYCLE"},
  {MAPI_E_STORE_FULL, "MAPI_E_STORE_FULL"},
  {MAPI_E_AMBIGUOUS_RECIP, "MAPI_E_AMBIGUOUS_RECIP"},
  {MAPI_E_INVALID_PARAMETER, "MAPI_E_INVALID_PARAMETER"},
  {MAPI_E_NOT_ENOUGH_MEMORY, "MAPI_E_NOT_ENOUGH_MEMORY"},
  {MAPI_E_NO_ACCESS, "MAPI_E_NO_ACCESS"}
};

const char *mapi_err_to_string (int err) {
  const auto it = mapiErrMap.find (err);
  if (it == mapiErrMap.end ())
    {
      return "unknown mapi err code";
    }
  return it->second;
}
