// SPDX-FileCopyrightText: 2023 g10 code GmbH
// SPDX-Contributor: Carl Schwan <carl.schwan@gnupg.com>
// SPDX-License-Identifier: GPL-2.0-or-later

#pragma once

#include "abstractcontroller.h"

#include <QHttpServerRequest>

class EmailController : public AbstractController
{
public:
    // Request from the web client
    static QHttpServerResponse viewEmailAction(const QHttpServerRequest &request);
    static QHttpServerResponse infoEmailAction(const QHttpServerRequest &request);
    static QHttpServerResponse newEmailAction(const QHttpServerRequest &request);
    static QHttpServerResponse replyEmailAction(const QHttpServerRequest &request);
    static QHttpServerResponse forwardEmailAction(const QHttpServerRequest &request);
    static QHttpServerResponse draftAction(QString draft, const QHttpServerRequest &request);

    /// Forward request from the native client to the web client
    static QHttpServerResponse socketWebAction(const QHttpServerRequest &request);

private:
    static QHttpServerResponse
    abstractEmailAction(const QHttpServerRequest &request, const QString &action, QHttpServerRequest::Method method = QHttpServerRequest::Method::Post);
};
