/* key.h 
 *	Copyright (C) 2000, 2001 Werner Koch (dd9jn), g10 Code GmbH
 *      Copyright (C) 2002-2004 Timo Schulz
 *
 * This file is part of MyGPGME.
 *
 * MyGPGME is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * MyGPGME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#ifndef GPGME_KEY_H
#define GPGME_KEY_H

#include "types.h"
#include "context.h"

struct signature_s {
    struct signature_s * next;
    int algo;
    int stat;
    char keyid[16+1];
    unsigned int created;
    unsigned int expires;    
    int sigclass;
    unsigned int is_local:1;
    unsigned int is_nonrev:1;
    char * issuer;
    char * user_id; /* belongs to this user id */
};

struct revoker_key_s {
    struct revoker_key_s * next;
    unsigned int algo;
    char fpr[41];
};

struct subkey_s {
    struct subkey_s * next;
    unsigned int secret:1;
    struct {
        unsigned int revoked:1;
        unsigned int expired:1;
        unsigned int disabled:1;
        unsigned int invalid:1;
        unsigned int can_encrypt:1;
        unsigned int can_sign:1;
        unsigned int can_certify:1;
	unsigned int can_auth:1;
    } flags;	
    unsigned int key_algo;
    unsigned int key_len;
    char keyid[16+1]; 
    char cardno[32+1];
    char * fingerprint; /* malloced hex digits */
    long timestamp; /* -1 for invalid, 0 for not available */
    long expires;
};

struct mpi_s {
    struct mpi_s * next;
    int bits;
    char * hexval;
};

struct gpgme_key_s {
    struct {
	unsigned int ultimate:1;
        unsigned int revoked:1 ;
        unsigned int expired:1 ;
        unsigned int disabled:1 ;
        unsigned int invalid:1 ;
        unsigned int can_encrypt:1;
        unsigned int can_sign:1;
        unsigned int can_certify:1;
	unsigned int can_auth:1;
	unsigned int is_protected:1;
	unsigned int divert_to_card:1;
    } gloflags;
    struct {
	unsigned used:1;
	unsigned char * d;
	int len;
    } attrib;
    unsigned int ref_count;
    unsigned int secret:1;
    unsigned int otrust;
    unsigned int validity;
    unsigned char * sym_prefs;
    struct subkey_s keys; 
    struct user_id_s * uids;
    struct revoker_key_s * rvks;
    struct signature_s * sigs;
    struct mpi_s * pkey;
};

struct signature_s * _gpgme_key_add_signature( gpgme_key_t key );
struct subkey_s    * _gpgme_key_add_subkey( gpgme_key_t key );
struct subkey_s    * _gpgme_key_add_secret_subkey( gpgme_key_t key );
gpgme_error_t        _gpgme_key_append_name (gpgme_key_t key, const char * s,
					     struct user_id_s ** u);

#endif /* GPGME_KEY_H */
