/* wptKeyEditOwnertrustDlg.cpp - Key onwertrust dialog
 *	Copyright (C) 2003 Timo Schulz
 *
 * This file is part of WinPT.
 *
 * WinPT is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * WinPT is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with WinPT; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <windows.h>
#include <stdio.h>
#include "../resource.h"
#include "wptTypes.h"
#include "wptW32API.h"
#include "wptVersion.h"
#include "wptNLS.h"
#include "wptErrors.h"

static const char * algos[] = {
    "TWOFISH",
    "AES256",
    "AES192",
    "AES",
    "BLOWFISH",
    "CAST5",
    "3DES",
    "MD5",
    "SHA1",
    "ZIP",
    "ZLIB",
    NULL
};

#define MDC_FEATURE 0x01
#define KSNO_FLAG   0x02    


struct prefs_cb_s {
    char * p;
    int flags;
};

static void
load_listbox (HWND dlg)
{
    HWND lb = GetDlgItem (dlg, IDC_SETPREF_PREFLIST);
    const char * s;
    int i;

    for (i=0; (s=algos[i]); i++)
	listbox_add_string (lb, s);
}


static int
copy_listbox_entry (HWND dlg)
{
    int idx=0, ctlid=0, rctlid=0;
    char buf[256];

    if (listbox_get_cursel (GetDlgItem (dlg, IDC_SETPREF_PREFLIST)) != LB_ERR) {	
	ctlid = IDC_SETPREF_PREFLIST;
	rctlid = IDC_SETPREF_LIST;
    }
    else {
	ctlid = IDC_SETPREF_LIST;
	rctlid = IDC_SETPREF_PREFLIST;
    }
    idx = listbox_get_cursel (GetDlgItem (dlg, ctlid));
    if (idx == LB_ERR)	
	return -1;
    SendDlgItemMessage (dlg, ctlid, LB_GETTEXT, (WPARAM)idx, (LPARAM)buf);
    SendDlgItemMessage (dlg, ctlid, LB_DELETESTRING, (WPARAM)idx, 0);
    SendDlgItemMessage (dlg, rctlid, LB_ADDSTRING, 0, (LPARAM)(const char *)buf);    
    return 0;
}


static int
return_pref_flags (HWND dlg)
{
    int flags=0;

    if (IsDlgButtonChecked (dlg, IDC_SETPREF_MDC))
	flags |= MDC_FEATURE;
    if (IsDlgButtonChecked (dlg, IDC_SETPREF_KSNO))
	flags |= KSNO_FLAG;
    return flags;
}


static char *
mk_prefs_from_list (HWND dlg, int flags)
{
    int i, nlist, n=0;
    char * p, buf[32];

    nlist = SendDlgItemMessage (dlg, IDC_SETPREF_LIST, LB_GETCOUNT, 0, 0);
    if (!nlist) {
	msg_box (dlg, _("There are no preferences in the list."), 
		 _("Key Preferences"), MB_ERR);
	return NULL;
    }
    for (i=0; i < nlist; i++)
	n += SendDlgItemMessage (dlg, IDC_SETPREF_LIST, LB_GETTEXTLEN, i, 0);
    if (flags & MDC_FEATURE)
	n += 4;
    if (flags & KSNO_FLAG)
	n += 10;
    p = new char[n+2*nlist+1];
    if (!p)
	BUG (NULL);
    memset (p, 0, n+2*nlist+1);
    for (i=0; i < nlist; i++) {
	SendDlgItemMessage (dlg, IDC_SETPREF_LIST, LB_GETTEXT, i, (LPARAM)(char *)buf);
	strcat (p, buf);
	strcat (p, " ");
    }
    if (flags & MDC_FEATURE)
	strcat (p, "MDC");
    if (flags & KSNO_FLAG) {
	strcat (p, " ");
	strcat (p, "NO-MODIFY");
    }
    return p;
}


BOOL CALLBACK
keyedit_setpref_dlg_proc (HWND dlg, UINT msg, WPARAM wparam, LPARAM lparam)
{
    static struct prefs_cb_s * cb;

    switch (msg) {
    case WM_INITDIALOG:
	cb = (struct prefs_cb_s *)lparam;
	if (!cb)
	    BUG (NULL);
	load_listbox (dlg);	
	CheckDlgButton (dlg, IDC_SETPREF_MDC, BST_CHECKED);
	center_window (dlg);
	SetForegroundWindow (dlg);
	break;

    case WM_COMMAND:
	switch (LOWORD (wparam)) {
	case IDOK:
	    cb->flags = return_pref_flags (dlg);
	    cb->p = mk_prefs_from_list (dlg, cb->flags);
	    if (!cb->p)
		return FALSE;
	    EndDialog (dlg, TRUE);
	    break;

	case IDCANCEL:
	    EndDialog (dlg, FALSE);
	    break;

	case IDC_SETPREF_UPDATE:
	    copy_listbox_entry (dlg);
	    break;
	}
	break;
    }

    return FALSE;
}


void
get_userid_preflist (char ** r_prefs, int * r_flags)
{
    struct prefs_cb_s cb;

    memset (&cb, 0, sizeof cb);
    DialogBoxParam (glob_hinst, (LPCTSTR)IDD_WINPT_KEYEDIT_SETPREF,
		    GetDesktopWindow (), keyedit_setpref_dlg_proc, (LPARAM)&cb);
    *r_prefs = cb.p;
    *r_flags = cb.flags;
}

