/* wptKeyserverSearchDlg.cpp - Keyserver Searching
 *	Copyright (C) 2001-2005 Timo Schulz
 *
 * This file is part of WinPT.
 *
 * WinPT is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * WinPT is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with WinPT; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <windows.h>
#include <stdio.h>

#include "../resource.h"
#include "wptCommonCtl.h"
#include "wptKeyserver.h"
#include "wptErrors.h"
#include "wptTypes.h"
#include "wptGPG.h"
#include "wptContext.h" /* for passphrase_s */
#include "wptDlgs.h"
#include "wptNLS.h"


BOOL CALLBACK
hkpsearch_dlg_proc (HWND dlg, UINT msg, WPARAM wparam, LPARAM lparam)
{
    static listview_ctrl_t lv = NULL;
    static keyserver_ctx * ksc;
    keyserver_key key;
    struct listview_column_s keysearch[] = {
        {0,  48, (char *)_("Size")},
        {1,  64, (char *)_("Key ID")},
        {2,  72, (char *)_("Creation")},
        {3, 256, (char *)_("User ID")},
        {0,   0, NULL}
    };
    char t[32], info[384];
    int i, rc;
    int conn_fd = 0;
    
    switch (msg) 
    {
    case WM_INITDIALOG:
        ksc = (keyserver_ctx *)lparam;
        if (!ksc)
            dlg_fatal_error (dlg, "Could not get dialog param.");
	#ifndef LANG_DE
        SetWindowText (dlg, _("Keyserver Searching"));
	#endif
        SetDlgItemText (dlg, IDC_HKPSEARCH_RECV, _("&Receive"));
        _snprintf (info, sizeof (info) - 1,
		   _("Connect to '%s' to search for \"%s\""),
		   ksc->name, ksc->pattern);
        SetDlgItemText (dlg, IDC_HKPSEARCH_INFO, info);
        listview_new (&lv);
        lv->ctrl = GetDlgItem (dlg, IDC_HKPSEARCH_LIST);
        for (i = 0; keysearch[i].width; i++)
            listview_add_column (lv, &keysearch[i]);
        listview_set_ext_style (lv);
	rc = kserver_search_init (ksc->name, ksc->port, ksc->pattern, &conn_fd);
	if (rc) {
            msg_box (dlg, winpt_strerror (rc), _("Keyserver - search init"), MB_ERR);
	    EndDialog (dlg, FALSE);
            return FALSE;
        }
	rc = kserver_search_chkresp (conn_fd);
	if (rc) {
	    msg_box (dlg, winpt_strerror (rc), _("Keyserver - check response"), MB_ERR);
	    closesocket (conn_fd);
	    EndDialog (dlg, FALSE);
	    return FALSE;
	}
        for (;;) {
            rc = kserver_search (conn_fd, &key);
	    if (rc)
                break;
            if (!key.bits)
                continue;
            _snprintf (t, sizeof (t) - 1, "%d", key.bits);
            listview_add_item (lv, " ");
            listview_add_sub_item (lv, 0, 0, t);
            listview_add_sub_item (lv, 0, 1, key.keyid);
            listview_add_sub_item (lv, 0, 2, key.date);
            listview_add_sub_item (lv, 0, 3, key.uid);
        }
        closesocket (conn_fd);
        SetForegroundWindow (dlg);
        return TRUE;
        
    case WM_DESTROY:
        if (lv) {
            listview_release (lv);
            lv = NULL;
        }
        return FALSE;
        
    case WM_SYSCOMMAND:
        if (LOWORD (wparam) == SC_CLOSE)
            EndDialog (dlg, TRUE);
        return FALSE;
        
    case WM_COMMAND:
        switch (LOWORD (wparam)) {
        case IDOK:
            EndDialog (dlg, TRUE);
            return TRUE;
            
        case IDCANCEL:
            EndDialog (dlg, FALSE);
            return FALSE;
            
        case IDC_HKPSEARCH_RECV:
            if ((i = listview_get_curr_pos (lv)) == -1) {
                msg_box (dlg, _("Please select a key."), _("Keyserver"), MB_ERR);
                return FALSE;
            }
            listview_get_item_text (lv, i, 1, t, sizeof (t) -1);
            hkp_recv_key (dlg, ksc->name, ksc->port, t, 0, 0);
            return TRUE;
        }
        break;
    }
    
    return FALSE;
} /* hkpsearch_dlg_proc */
