/* wptOwnertrust.cpp - Ownertrust im- and export
 *	Copyright (C) 2001, 2002, 2003 Timo Schulz
 *
 * This file is part of WinPT.
 *
 * WinPT is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * WinPT is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with WinPT; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <windows.h>

#include "../resource.h"
#include "wptTypes.h"
#include "wptGPG.h"
#include "wptErrors.h"
#include "wptNLS.h"
#include "wptW32API.h"


BOOL CALLBACK
ownertrust_dlg_proc( HWND dlg, UINT msg, WPARAM wparam, LPARAM lparam )
{
    gpgme_error_t err;
    char fname[256];
    
    switch( msg ) {
    case WM_INITDIALOG:
#ifndef LANG_DE
        SetWindowText( dlg, _("Ownertrust") );
        SetDlgItemText( dlg, IDC_OWNERTRUST_INFO, _("File") );
        SetDlgItemText( dlg, IDC_OWNERTRUST_DESC,
                       _("Here it is possible to save or restore the ownertrust from the "
                         "'trustdb' file. This could be very useful because the values are NOT "
                         "stored in the keyring.") );
#endif
	center_window( dlg );
        SetForegroundWindow( dlg );
        return TRUE;
        
    case WM_SYSCOMMAND:
        if( LOWORD (wparam) == SC_CLOSE )
            EndDialog( dlg, TRUE );
        return FALSE;
        
    case WM_COMMAND:
        switch ( LOWORD( wparam ) ) {
	case IDC_OWNERTRUST_SELFILE:
	    const char * s;
	    s = get_filename_dlg( dlg, 1, _("Please select a filename"), NULL, NULL );
	    if( s && *s )
		SetDlgItemText( dlg, IDC_OWNERTRUST_FILE, s );
	    break;

        case IDC_OWNERTRUST_EXPORT:
            if( !GetDlgItemText( dlg, IDC_OWNERTRUST_FILE, fname, sizeof fname -1 ) ) {
                msg_box( dlg, _("Please enter the filename."), _("Ownertrust"), MB_ERR );
                return FALSE;
            }
	    err = gpgme_op_ownertrust_export_file( fname );
            if( err ) {
                msg_box( dlg, gpgme_strerror( err ), _("Ownertrust"), MB_ERR );
                return FALSE;
            }
            status_box( dlg, _("Ownertrust successfully exported."), _("GnuPG Status") );
            EndDialog( dlg, TRUE );
            return TRUE;

	case IDC_OWNERTRUST_IMPORT:
	    if( !GetDlgItemText( dlg, IDC_OWNERTRUST_FILE, fname, sizeof fname-1 ) ) {
		msg_box( dlg, _("Please enter the filename."), _("Ownertrust"), MB_ERR );
		return FALSE;
	    }
	    err = gpgme_op_ownertrust_import_file( fname );            
	    if( err ) {
		msg_box( dlg, gpgme_strerror( err ), _("Ownertrust"), MB_ERR );
		return FALSE;
	    }
	    status_box( dlg, _("Ownertrust succefully imported."), _("GnuPG Status") );
	    EndDialog( dlg, TRUE );
	    return TRUE;
            
        case IDCANCEL:
            EndDialog( dlg, FALSE );
            return FALSE;
        }
        break;
    }
    
    return FALSE;
} /* ownertrust_dlg_proc */
