#ifndef dlh_h
#define dlh_h

#include <stdio.h>
#include <string.h>

#include "config.h"

#ifndef strndupa
# define strndupa(s, n)				\
    ({						\
      __const char *__old = (s);		\
      char *__new = __builtin_alloca (n + 1);	\
      __new[n] = '\0';				\
      memcpy (__new, __old, n);			\
    })
#endif

#if ENABLE_NLS
# include <libintl.h>
# ifndef _
#  define _(string)	gettext(string)
# endif
#endif

#ifndef _
# define _(string)	string
#endif

#define NELEMS(a)	((long) (sizeof(a) / sizeof(a[0])))

#define ARG_TYPE_BITS	2	/* # of bits to hold an argument type */

#define ARG_MAX_SPECS	(8 * sizeof(unsigned) / ARG_TYPE_BITS)

#define ARG_OPT(pos)	(ARG_OPTIONAL << (ARG_TYPE_BITS * (pos)))
#define ARG_REQ(pos)	(ARG_REQUIRED << (ARG_TYPE_BITS * (pos)))

/* common argument patterns: */

#define ARG_REQ1		(ARG_REQ(0))
#define ARG_REQ2		(ARG_REQ1 | ARG_REQ(1))
#define ARG_REQ3		(ARG_REQ2 | ARG_REQ(2))

#define ARG_OPT1		(ARG_OPT(0))

#define ARG_OPT1_REQ1		(ARG_OPT(0) | ARG_REQ(1))
#define ARG_OPT1_REQ1_OPT1	(ARG_OPT(0) | ARG_REQ(1) | ARG_OPT(2))
#define ARG_REQ1_OPT1		(ARG_REQ(0) | ARG_OPT(1))
#define ARG_REQ1_OPT1_REQ1	(ARG_REQ(0) | ARG_OPT(1) | ARG_REQ(2))
#define ARG_REQ1_OPT1_REQ2	(ARG_REQ1_OPT1_REQ1 | ARG_REQ(3))

enum ArgType {
    ARG_NONE		= 0,
    ARG_OPTIONAL	= 1,	/* optional arg enclosed in [ ] */
    ARG_REQUIRED	= 2	/* required arg enclosed in { } */
};

/*
 * figure:	f
 * footnote:	F
 * index:	i
 * section:	s
 * table:	t
 */

struct cmd;
struct env;

struct call {
    union {
	struct env *	env;
	struct cmd *	cmd;
    } u;
    char **		arg_list;	/* list of required arguments */
};

struct cmd {
    const char *	name;
    unsigned		pat;		/* pattern for argument parsing */
    void		(*op)(struct call *);
    const void *	arg;
};

struct env {
    const char *	name;
    unsigned		pat;		/* pattern for argument parsing */
    void		(*op)(struct call * c, int prologue);
    const char *	pro;
    const char *	epi;
};

struct env_stack {
    struct env_stack *	next;
    struct env *	e;
    int			ncleanup;
    int			nalloced;
    struct cleanup {
	void		(*op)(const void * arg);
	const void *	arg;
    } *cleanup;
};

struct file_stack {
    struct file_stack *	next;
    FILE *		file;
};

/*
 * Specifies how to typeset a column (cell) in a table:
 */
struct table {
    int		num_cols;
    int		want_border;
    struct cellspec {
	char	spec;	/* @, p, l, c, or r */
	char *	arg;	/* text in @{text} */
    } col[128];
};

/*
 * Structure for cross-referencing:
 */
struct xref_def {
    char *		name;		/* xref name, e.g., sec:example */
    char *		value;		/* NULL or, e.g., "3.6.3" */
    int			file_num;	/* defn is in file docFILE_NUM.html */
    /* [f]igure, [t]able, [s]ection, [b]ibliography, or [e]quation: */
    char		type;
};

struct xref_use {
    long		pos;		/* position for value */
    int			def;		/* index of defining cross-reference */
    int			file_num;	/* file to which POS refers to */
};

struct xref_tab {
    int			ndefs;
    int			ndefs_alloced;
    struct xref_def *	def;

    int			nuses;
    int			nuses_alloced;
    struct xref_use *	use;
};

struct dict_entry {
    const char *	key;
    int			file_num;
    int			label;
};

struct dict_tab {
    int			len;
    int			alloced;
    struct dict_entry *	dict;
};

struct counter {
    struct counter *	next;		/* linked list of children */
    struct counter *	children;	/* counters to reset on increment */
    long		value;		/* current value */
};

enum Aux_Flags {
    AUX_INDEX		= 1 << 0,	/* make index */
    AUX_LOF		= 1 << 1,	/* make list of figures */
    AUX_LOT		= 1 << 2,	/* make list of tables */
    AUX_MATH_MODE	= 1 << 3,	/* are we in math-mode? */
    AUX_FORCE		= 1 << 4,	/* force generation of images etc? */
};

enum Style {
    STYLE_NONE = 0,
    STYLE_ARTICLE,
    STYLE_BOOK,
    STYLE_LETTER,
    STYLE_REPORT,
    STYLE_SLIDES,
    STYLE_PROC,
    NUM_STYLES
};

enum Counter {
    CNT_FILE, CNT_TABLE, CNT_FIGURE, CNT_FOOTNOTE, CNT_INDEX_LABEL,
    CNT_CITATION, CNT_EQUATION,
    CNT_MAX
};

extern enum Style	style;		/* document style/class */
extern unsigned		aux_flags;	/* auxiliary flags (AUX_*) */
extern const char *	pos;		/* pointer to next input char */
extern const char *	filename;	/* current input filename */
extern unsigned long	linenum;	/* current input line number */
extern struct env_stack * env;
extern struct env	anonymous_env;	/* anonymous environment, i.e., {} */
extern struct file_stack * out;		/* stack of open output files */
extern int		counter[CNT_MAX]; /* various counters */

extern void select_font (const char * fontname);
extern void cmd_macro (struct call * c);
extern void cmd_emit (struct call * c);
extern void push_env (struct env * e);

#endif /* dlh_h */
