/*-
******************************************************************************
******************************************************************************
**
**  ARCHIVE HEADER INFORMATION
**
**  @C-file{
**      FILENAME    = "checkos.h",
**      VERSION     = "1.00",
**      DATE        = "",
**      TIME        = "",
**
**      AUTHOR      = "Niel Kempson",
**      ADDRESS     = "25 Whitethorn Drive, Cheltenham, GL52 5LL, England",
**      TELEPHONE   = "+44-242 579105",
**      EMAIL       = "kempson@tex.ac.uk (Internet)",
**
**      SUPPORTED   = "yes",
**      ARCHIVED    = "tex.ac.uk, ftp.tex.ac.uk",
**      KEYWORDS    = "VVcode",
**
**      CODETABLE   = "ISO/ASCII",
**      CHECKSUM    = "51492 1481 5732 57976",
**
**      DOCSTRING   = { This file is part of VVcode.
**                  }
**  }
**
**  MODULE CONTENTS
**
**      [tbs]
**
**  COPYRIGHT
**
**      Copyright (c) 1991-1993 by Niel Kempson <kempson@tex.ac.uk>
**
**      This program is free software; you can redistribute it and/or
**      modify it under the terms of the GNU General Public License as
**      published by the Free Software Foundation; either version 1, or
**      (at your option) any later version.
**
**      This program is distributed in the hope that it will be useful,
**      but WITHOUT ANY WARRANTY; without even the implied warranty of
**      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
**      General Public License for more details.
**
**      You should have received a copy of the GNU General Public License
**      along with this program; if not, write to the Free Software
**      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
**      In other words, you are welcome to use, share and improve this
**      program.  You are forbidden to forbid anyone else to use, share
**      and improve what you give them.   Help stamp out software-hoarding!  
**
**  CHANGE LOG
**
******************************************************************************
******************************************************************************
*/


/*-
******************************************************************************
******************************************************************************
**
** OPERATING ENVIRONMENTS SUPPORTED
**
******************************************************************************
******************************************************************************
*/


/*-
**============================================================================
** Reset the operating system macros
**============================================================================
*/
#ifdef  OS_MSDOS
# undef  OS_MSDOS
#endif
#define OS_MSDOS                    0

#ifdef  OS_OS2
# undef  OS_OS2
#endif
#define OS_OS2                      0

#ifdef  OS_UNIX
# undef  OS_UNIX
#endif
#define OS_UNIX                     0

#ifdef  OS_VAXVMS
# undef  OS_VAXVMS
#endif
#define OS_VAXVMS                   0

#ifdef  OS_VMCMS
# undef  OS_VMCMS
#endif
#define OS_VMCMS                    0



/*-
******************************************************************************
******************************************************************************
**
** MS-DOS implementations
**
******************************************************************************
******************************************************************************
*/

/*-
**----------------------------------------------------------------------------
** Reset the MS-DOS specific macros
**----------------------------------------------------------------------------
*/
#ifdef  MSDOS_MSC
# undef  MSDOS_MSC
#endif
#define MSDOS_MSC                   0

#ifdef  MSDOS_TURBOC
# undef  MSDOS_TURBOC
#endif
#define MSDOS_TURBOC                0

/*-
**----------------------------------------------------------------------------
** Microsoft C defines the macros MSDOS and M_I86 but since it also defines
** them under OS/2, we check also that OS2 is not defined.
**----------------------------------------------------------------------------
*/
#ifndef OS2
# ifdef  MSDOS
#  ifdef  M_I86
#   undef  OS_MSDOS
#   define OS_MSDOS                  1
#   undef  MSDOS_MSC
#   define MSDOS_MSC                 1
#  endif			/* M_I86 */
# endif				/* MSDOS */
#endif                          /* NOT OS2 */

/*-
**----------------------------------------------------------------------------
** Borland Turbo C for MS-DOS defines the macros __MSDOS__ and __TURBOC__
**----------------------------------------------------------------------------
*/
#ifdef  __MSDOS__
# ifdef  __TURBOC__
#  undef  OS_MSDOS
#  define OS_MSDOS                  1
#  undef  MSDOS_TURBOC
#  define MSDOS_TURBOC              1
# endif				/* __TURBOC__ */
#endif				/* __MSDOS__ */



/*-
******************************************************************************
******************************************************************************
**
** OS/2 implementations
**
******************************************************************************
******************************************************************************
*/

/*-
**----------------------------------------------------------------------------
** Reset the OS/2 specific macros
**----------------------------------------------------------------------------
*/
#ifdef  OS2_MSC
# undef  OS2_MSC
#endif
#define OS2_MSC                     0

#ifdef  OS2_CSET
# undef  OS2_CSET
#endif
#define OS2_CSET                    0

#ifdef  OS2_EMXGNUC
# undef  OS2_EMXGNUC
#endif
#define OS2_EMXGNUC 	    	    0

#ifdef  OS2_GNUC
# undef  OS2_GNUC
#endif
#define OS2_GNUC                    0

/*-
**----------------------------------------------------------------------------
** The IBM C Set/2 compiler defines the macros __OS2__, __IBMC__ & __32BIT__
** When the migration library is being used, the macro __MIG__ is also
** defined.
**----------------------------------------------------------------------------
*/
#ifdef  __OS2__
# ifdef __IBMC__
#  ifdef __32BIT__
#   ifdef __MIG__
#    undef  OS_OS2
#    define OS_OS2                  1
#    undef  OS2_CSET
#    define OS2_CSET                1
#   endif			/* __MIG__ */
#  endif			/* __32BIT__ */
# endif				/* __IBMC__ */
#endif				/* __OS2__ */

/*-
**----------------------------------------------------------------------------
** The OS2 Makefile defines the macro OS2.  Eberhard Mattes' implementation
** of EMX and GCC 2.1 also defines the macros __GNUC__ and __EMX__.
**----------------------------------------------------------------------------
*/
#ifdef  OS2
# ifdef __GNUC__
#  undef  OS_OS2
#  define OS_OS2                    1
#  undef  OS2_GNUC
#  define OS2_GNUC                  1
#  if __EMX__
#   undef  OS2_EMX
#   define OS2_EMX  	    	    1
#  endif			/* __EMX__ */
# endif				/* __GNUC__ */
#endif				/* OS2 */

/*-
**----------------------------------------------------------------------------
** The OS2 Makefile defines the macro OS2.  The Microsoft C v6.00 compiler
** also defines the macros _MSC_VER and MSDOS (??).
**----------------------------------------------------------------------------
*/
#ifdef  OS2
# ifdef MSDOS
#  ifdef _MSC_VER
#   undef  OS_OS2
#   define OS_OS2                     1
#   undef  OS2_MSC
#   define OS2_MSC                    1
#  endif			/* _MSC_VER */
# endif                         /* MSDOS */
#endif				/* OS2 */



/*-
******************************************************************************
******************************************************************************
**
** Unix implementations
**
******************************************************************************
******************************************************************************
*/

/*-
**----------------------------------------------------------------------------
** Reset the UNIX specific macros
**----------------------------------------------------------------------------
*/
#ifdef  UNIX_BSD
# undef  UNIX_BSD
#endif
#define UNIX_BSD                    0

#ifdef  UNIX_BSD41
# undef  UNIX_BSD41
#endif
#define UNIX_BSD41                  0

#ifdef  UNIX_BSD42
# undef  UNIX_BSD42
#endif
#define UNIX_BSD42                  0

#ifdef  UNIX_BSD43
# undef  UNIX_BSD43
#endif
#define UNIX_BSD43                  0

#ifdef  UNIX_GNUC
# undef  UNIX_GNUC
#endif
#define UNIX_GNUC                   0

#ifdef  UNIX_MSC
# undef  UNIX_MSC
#endif
#define UNIX_MSC                    0

#ifdef  UNIX_SYSV
# undef  UNIX_SYSV
#endif
#define UNIX_SYSV                   0

/*-
**----------------------------------------------------------------------------
** The Unix Makefile defines the macro BSD43 for BSD 4.3 systems.
**----------------------------------------------------------------------------
*/
#ifdef  BSD43
# undef  OS_UNIX
# define OS_UNIX                    1
# undef  UNIX_BSD43
# define UNIX_BSD43                 1
#endif				/* BSD43 */


/*-
**----------------------------------------------------------------------------
** The Unix Makefile defines the macro BSD42 for BSD 4.2 systems.
**----------------------------------------------------------------------------
*/
#ifdef  BSD42
# undef  OS_UNIX
# define OS_UNIX                    1
# undef  UNIX_BSD42
# define UNIX_BSD42                 1
#endif				/* BSD42 */


/*-
**----------------------------------------------------------------------------
** The Unix Makefile defines the macro BSD41 for BSD 4.1 systems
**----------------------------------------------------------------------------
*/
#ifdef  BSD41
# undef  OS_UNIX
# define OS_UNIX                    1
# undef  UNIX_BSD41
# define UNIX_BSD41                 1
#endif				/* BSD41 */


/*-
**----------------------------------------------------------------------------
** The Unix Makefile defines the macro SYSV for Unix System V
**----------------------------------------------------------------------------
*/
#ifdef  SYSV
# undef  OS_UNIX
# define OS_UNIX                    1
# undef  UNIX_SYSV
# define UNIX_SYSV                  1
#endif				/* SYSV */


/*-
**----------------------------------------------------------------------------
** If any of the UNIX_BSDxx macros were set, we define a the macro UNIX_BSD
**----------------------------------------------------------------------------
*/
#if (UNIX_BSD41 || UNIX_BSD42 || UNIX_BSD43)
# undef  UNIX_BSD
# define UNIX_BSD                   1
#endif                          /* (UNIX_BSD41 || UNIX_BSD42 || UNIX_BSD43) */


/*-
**----------------------------------------------------------------------------
** The Unix GNU C compiler defines __GNUC__
**----------------------------------------------------------------------------
*/
#if (OS_UNIX)
# ifdef  __GNUC__
#  undef  UNIX_GNUC
#  define UNIX_GNUC                 1
# endif				/* __GNUC__ */
#endif				/* (OS_UNIX) */


/*-
**----------------------------------------------------------------------------
** The Unix Makefile defines MSC when the SCO Unix Microsoft C compiler
** is used
**----------------------------------------------------------------------------
*/
#if (OS_UNIX)
# ifdef  MSC
#  undef  UNIX_MSC
#  define UNIX_MSC                  1
# endif				/* MSC */
#endif				/* (OS_UNIX) */



/*-
******************************************************************************
******************************************************************************
**
** VAX/VMS implementations
**
******************************************************************************
******************************************************************************
*/

/*-
**----------------------------------------------------------------------------
** Reset the VMS specific macros
**----------------------------------------------------------------------------
*/
#ifdef  VMS_GNUC
# undef  VMS_GNUC
#endif
#define VMS_GNUC                    0

#ifdef  VMS_VAXC
# undef  VMS_VAXC
#endif
#define VMS_VAXC                    0

/*-
**----------------------------------------------------------------------------
** The VAX/VMS C compiler defines the macros VMS and VAXC
**----------------------------------------------------------------------------
*/
#ifdef  VMS
# ifdef  VAXC
#  undef  OS_VAXVMS
#  define OS_VAXVMS                 1
#  undef  VMS_VAXC
#  define VMS_VAXC                  1
# endif				/* VAXC */
#endif				/* VMS */

/*-
**----------------------------------------------------------------------------
** The VAX/VMS GNU C compiler defines the macros VMS and __GNUC__
**----------------------------------------------------------------------------
*/
#ifdef  VMS
# ifdef  __GNUC__
#  undef  OS_VAXVMS
#  define OS_VAXVMS                 1
#  undef  VMS_GNUC
#  define VMS_GNUC                  1
# endif				/* __GNUC__ */
#endif				/* VMS */



/*-
******************************************************************************
******************************************************************************
**
** VM/CMS implementations
**
******************************************************************************
******************************************************************************
*/

/*-
**----------------------------------------------------------------------------
** Reset the VM/CMS specific macros
**----------------------------------------------------------------------------
*/

/*-
**----------------------------------------------------------------------------
** The VM/CMS make EXEC defines the macro VMCMS
**----------------------------------------------------------------------------
*/
#ifdef  VMCMS
# undef  OS_VMCMS
# define OS_VMCMS                   1
#endif				/* VMCMS */
