# nowrap

alpha::mode Igor 1.01 igorMenu { *.igor } {igorMenu electricTab} {
    addMenu igorMenu "284"
}

proc igorMenu {} {}

set igorSig IGR0

Menu -n $igorMenu -p igorMenuProc {
    "/S<U<OswitchToIgor"
    "(-"
    "/K<U<OopenFileInIgor"
    "/K<U<O<BswitchFileToIgor"
}

proc igorMenuProc {menu item} {
    global igorSig
    switch $item {
	switchToIgor {app::launchFore $igorSig}
	openFileInIgor {
	    openAndSendFile $igorSig
	}
	switchFileToIgor {
	    openAndSendFile $igorSig
	    killWindow
	}
    }
}


set Igor::commentCharacters(General) "// "
set Igor::commentCharacters(Paragraph) [list "// " "// " "// "]

newPref v leftFillColumn {3} Igor
newPref v prefixString {//} Igor
newPref f wordWrap {0} Igor
newPref v funcExpr {^[ \t]*([pP]roc.+$|[mM]acro.+$|[fF]unction.+$)} Igor
newPref v parseExpr {\b([_:\w]+)\s*\(} Igor
newPref v wordBreak {[_\w]+} Igor
newPref v wordBreakPreface {[^_\w]} Igor
newPref f autoMark 0 Igor
newPref v stringColor green Igor
newPref v commentColor red Igor
newPref v funcColor yellow Igor
newPref v keywordColor blue Igor

set igorCommentRegexp	{(//|[^%]\|)}
set igorPreRegexp	"^\#\[\t \]*\[a-z\]*"
set igorKeyWords {
    break for if endif do while continue
    return else end variable string wave NVAR SVAR
    function proc macro
}

regModeKeywords -e {//} -c red -f yellow -k blue -s green Igor $igorKeyWords

unset igorKeyWords

proc Igor::MarkFile {} {
    global IgormodeVars
    set pos [minPos]
    
    while {![catch {search -s -f 1 -r 1 -m 0 -i 1 $IgormodeVars(funcExpr) $pos} res]} {
	set start [lindex $res 0]
	set end [pos::math [lindex $res 1] + 1]
	set text [getText $start $end]
	set inds($text) [list $start [pos::math $start + [string length $text]]]
	set pos $end
    }
    
    set pos [minPos]
    set markExpr {(^[ \t]*[Mm]enu.*$|===[^=]+===\s*$)}
    while {![catch {search -s -f 1 -r 1 -m 0 -i 1 -- "$markExpr" $pos} res]} {
	set start [lindex $res 0]
	set end [pos::math [lindex $res 1] - 1]
	set text [string trimright [getText $start $end] ]
	set inds($text) [list $start [pos::math $start + [string length $text]]]
	set pos $end
    }
    if {[info exists inds]} {
	foreach f [array names inds] {
	    set res $inds($f)
	    setNamedMark $f [lineStart [lindex $res 0]] [lindex $res 0] [lindex $res 1]
	}
    }
    namedMarkProc {namedMarks} {sortByPosition}
}


