# (install)
##################################################################
# 
# BibTeX to HTML converter.
# 
# Pierre BASSO 
# email:basso@lim.univ-mrs.fr
#
# 
# This procedure is inserted as a command in the menu mode BibTeX.
# You use this command in selecting all a bib file  or only a part,
# bibToHtml will convert the selected part. All the bib entries
# will be analyzed and converted in a html bibliographic reference.
# If you convert a file 'fooname.bib' you'll get a file 'fooname.html'
# in the same folder. 
#  When bibToHtml ends, it asks for directly sending the html file
#  to the browser, else it displays this file as a front window.
#  You may improve this html file, in adding titles, figures or
#  any fancies, for example, before sending to the browser.
# 
#  WARNING: this procedure requires working on correct bib files,
#           i.e. devoid of any  syntactical bibtex error. Before 
#           this conversion the bib file can be sorted  by "Sort
#           by" command in the Bib mode of Alpha.
#  
# I borrowed from "Convert LaTeX to accents" the table of regular 
# expressions for conversion of LaTeX characters. 
# Thanks to F. Miguel Dionsio 
# 
#
#
#################################################################


alpha::extension bibToHtml 1.14 {
    menu::insert bibtexMenu items end "bibToHtml"
} maintainer {
    "Pierre Basso" <basso@lim.univ-mrs.fr>
}


proc rexp  {c} {
	set ws {[ \t]*}
	set reg $ws\($c|{$ws$c$ws}\)
	return "$reg"
}


########################################################
#
# Search for any cross reference \cite in a field of 
# a bibtex entry. Then resolving this cross reference 
# by scanning all the bib files in the current directory.
#
#

proc ParsingField {id buff} {
	set buff [string trim $buff]
	set begin [string  index $buff 0]
	if {$begin == "\{"} {
		set buff [string trimleft $buff "\{"]
		set braces 1
		set text ""
		while {$braces > 0} {
		   set lenbuff [string length $buff]
		   set j 0
		   while {$j < $lenbuff} {
			   set char [string index $buff $j]
			   if {$char == "\{" } {incr braces}
			   if {$char == "\}" } {incr braces -1}
			   incr j}
		   append text " $buff"
	      if {$braces > 0} {
			  if {$id < 0} {
			        set pos11 [getPos]
				    set pos11 [nextLineStart $pos11]
					goto $pos11
				    endOfLine
				    set pos21 [getPos]
				    set buff [getText $pos11 $pos21]
				  } else {gets $id buff}
		      set buff [string trim $buff]
		  }
		}
		set text [string trimright $text ","]
		set text [string trimright $text "\}"]
		set text [string trimleft $text ]
		return $text
	 }
#
	set quote {"}
	if {$begin == $quote} {
		set buff [string trimleft $buff $quote]
		set text ""
		set endquote -1
		while {$endquote < 0} {
		   set endquote [string first $quote $buff]
		   append text " $buff"
	       if {$endquote < 0} {
		       if {$id < 0} {
			        set pos11 [getPos]
				    set pos11 [nextLineStart $pos11]
					goto $pos11
				    endOfLine
				    set pos21 [getPos]
				    set buff [getText $pos11 $pos21]
				  } else {gets $id buff}
		       set buff [string trim $buff]
		   }
		}
		set text [string trimright $text ","]
		set text [string trimright $text $quote]
		set text [string trimleft $text ]
		return $text
	 }
#
	 set text [string range $buff 0 end]
	 set text [string trimright $text ","]
	 return $text
}


############
#
proc ResolveCiteRef {reference} {
	set bibfile [lindex [winNames -f] 0]
    set currentDir [file dirname $bibfile]
	set ext ".bib"
	set listbibfiles [glob -nocomplain "$currentDir:*$ext"]
    set bibTopPat {@([a-zA-Z]+)[\{\(][ 	]*}
 	set cid [scancontext create]
 	scanmatch $cid $bibTopPat$reference {
 		set found "$matchInfo(offset)"
 	}
 	set found ""	
	foreach f $listbibfiles {
		if {![catch {set fid [open $f]}]} {
			scanfile $cid $fid
			close $fid
			if {$found != ""} {
				open $f 
			    read $fid $found
				gets $fid bufferfid
		        set endsearch 0
				set buffauthor ""
				set buffeditor ""
				set buffyear ""
				while {$endsearch == 0} {
					set eofile [gets $fid bufferfid]
					if {$eofile == -1} {
						 set endsearch 1
						 continue}
					set bufferfid [string trim $bufferfid]
					set values [ParsingEntry $bufferfid]
		            set endsearch [lindex $values 0]
					if {$endsearch == 1} {continue}
					scan $bufferfid %s fieldname
					set fieldname [string tolower $fieldname]
					if {$fieldname == "author"} {
						  set index [string first "=" $bufferfid]
						  set bufferfid [string range $bufferfid [expr $index + 1] end]
					      set buffauthor [ParsingField $fid $bufferfid]
						#  set buffauthor $bufferfid
					      continue}
					if {$fieldname == "editor"} {
						  set index [string first "=" $bufferfid]
						  set bufferfid [string range $bufferfid [expr $index + 1] end]
					      set buffeditor [ParsingField $fid $bufferfid]
					#	  set buffeditor $bufferfid
					      continue}
					if {$fieldname == "year"} {
					      set index [string first "=" $bufferfid]
						  set bufferfid [string range $bufferfid [expr $index + 1] end]
					      set buffyear [ParsingField $fid $bufferfid]
					#	  set buffyear $bufferfid
					      continue}
			       }
			      close $fid
				  if {$buffauthor != ""} {
				       set reference "$buffauthor ($buffyear)"
		               return $reference}
				  if {$buffeditor != ""} {
				       set reference "$buffeditor ($buffyear)"
		               return $reference}
				 set reference "(undefined: $reference)"
				 return $reference
		    }
		}
	 continue   
	}
	
	message "Entry '$reference' not found."
	set reference "(undefined: $reference)"
	return $reference

}

##
#
proc SearchCite {} {
	global fieldtext
	set index1 ""
	while {$index1 != -1 } {
		 set index1 [string first "\\cite\{" $fieldtext]
	     if {$index1 == -1} {continue}
		 set lenfield [string length $fieldtext]
 	     set buftmp [string range $fieldtext 0 [expr $index1 - 1]]
	     set crossref [string range $fieldtext  [expr $index1 + 6] $lenfield]
	     set index2 [string first "\}" $crossref]
	     set crossref [string range $crossref 0 [expr $index2 - 1]]
		 set crossref [ResolveCiteRef $crossref]
	     append buftmp " $crossref"
     	 append buftmp [string range $fieldtext  [expr $index1 + $index2 + 7] [expr $lenfield]]
		 set fieldtext $buftmp
	}	 
}


#
###########################################
#
# Search for the beginning of a next 
# bib entry
#
proc SearchNextEntry {beginentry} {
	global endselection entries
	set pos10 $beginentry
	while {$pos10 < $endselection} {
		  endOfLine
	      set pos20 [getPos]
	      set line [getText $pos10 $pos20]
		  set values [ParsingEntry $line]
		  set ii [lindex $values 0]
		  if {$ii == 1} {
			  set endentry [expr $pos10 - 1]
			  goto $beginentry
			  return $endentry}
	      set pos10 [nextLineStart $pos20]
	      goto $pos10
    }
	set endentry $endselection
    goto $beginentry
    return $endentry
}

###################################################
# Parsing a line of a bib file and search 
# for a bib entry as @article, @book, and so on.
# If an entry is found a list of values is returned:
#    values 0  is a flag 1
#    values 1  is the entry bib name: article, book,...
#    values 2  is the label of this entry 
#
# If no entry is found values is set off
#
proc ParsingEntry {line} {
   global entries
   set line [string trim $line]
   set char [string index $line 0]
   if {$char != "@"} {set flag 0
	                  return $flag}
   set line [string  range $line 1 end]
   set line [string trim $line]
   set i 0
   set startentries [array names entries]
   set len [llength $startentries]
   while {$i < $len} {
        set ent [lindex $startentries $i]
		set entlen [string length $ent]
		set char [string range  $line 0 [expr $entlen-1]]
		set char [string tolower $char]
		if {[string compare $char $ent] == 0} {
			lappend values 1
			lappend values $char
			set label [string range $line $entlen end]
			set label [string trim $label]
			set label [string trimleft $label "\{"]
			set label [string trimright $label ","]
			lappend values $label
		    return $values}
		incr i
   }
   lappend values 0
   return $values
}


#
#
#########################################################
#
#

proc bibToHtml {} {
  global fields idhtml labelname countbibentries endselection
  global fieldtext bufferhtml entries
  global  tabHtmlChar tabRegExpr HtmlGreek GreekExpr
  global LatexStyles HtmlStyles endHtmlStyles

# Beginning to end of selection
  set aa [getSelect]
  set lselect [string length $aa]
  if {$lselect != 0} {
      set endselection [selEnd]
      beginningOfLine 
      set pos1 [getPos]} else {
	     endOfBuffer
	     set endselection [getPos]
	     set pos1 0}
  goto $pos1

#
# Initialise file html
  set bibfile [lindex [winNames -f] 0]
  set htmlfile [file rootname $bibfile]
  append htmlfile ".html"
  set idhtml [open $htmlfile w]
  set quote {"}
  set bufferhtml "<HTML>\r <HEAD>\r <TITLE> Bibliography</TITLE>\r </HEAD>\r"
  append bufferhtml "<BODY BGCOLOR=$quote#ffffff$quote LINK=$quote#cc0000$quote" 
  append bufferhtml "VLINK=$quote#005522$quote ALINK=$quote#ff3300$quote" 
  append bufferhtml "topmargin=$quote 5$quote leftmargin=$quote 5$quote>\r\r<DL>\r"
#  puts $idhtml $bufferhtml
#  set bufferhtml ""
  set countbibentries 0


##############################################################
#
# All this part is devoted to analyze each entry  of bib file.
# When a bib entry is found, all the corresponding fields 
# are copied in a table "entries"
#     
#  
# Conversion tables
# 
 					   

 set tabHtmlChar [list  "\\&agrave;" "\\&aacute;" "\\&acirc;" "\\&atilde;" "\\&auml;" "\\&aring;"\
					    "\\&Agrave;" "\\&Aacute;" "\\&Acirc;" "\\&Atilde;" "\\&Auml;" "\\&Aring;"\
					    "\\&egrave;" "\\&eacute;" "\\&ecirc;"  "\\&euml;" \
					    "\\&Egrave;" "\\&Eacute;" "\\&Ecirc;"  "\\&Euml;" \
						"\\&igrave;" "\\&iacute;" "\\&icirc;"  "\\&iuml;" \
						"\\&Igrave;" "\\&Iacute;" "\\&Icirc;"  "\\&Iuml;" \
						"\\&ograve;" "\\&oacute;" "\\&ocirc;" "\\&otilde;" "\\&ouml;" \
						"\\&Ograve;" "\\&Oacute;" "\\&Ocirc;" "\\&Otilde;" "\\&Ouml;" \
						"\\&ugrave;" "\\&uacute;" "\\&ucirc;"  "\\&uuml;" \
						"\\&Ugrave;" "\\&Uacute;" "\\&Ucirc;"  "\\&Uuml;" \
						"" ""  "\\&aelig;" "\\&Aelig;" "\\&oslash;"  "\\&Oslash;"\
						"\\&ccedil;" "\\&ntilde;" "\\&Ccedil;" "\\&Ntilde;"\
						"\\&yacute;" "\\&yuml;"  "\\&Yacute;" "\\&Yuml;" ]
				   
					  
	
 set ws {[ \t]*}
 set sp {[ \t]}
 set sep { *( |\b)}
 set seplater {\\\\sepsep//}
 set a [rexp a]
 set regas  [list  "\\\\`$a" "\\\\'$a" "\\\\\\^$a"  "\\\\~$a"  "\\\\\\$quote$a" "\\\\aa$sep"]
 set a [rexp A]
 set regcas [list  "\\\\`$a" "\\\\'$a" "\\\\\\^$a"  "\\\\~$a"  "\\\\\\$quote$a" "\\\\AA$sep"]
 set e [rexp e]
 set reges  [list  "\\\\`$e"  "\\\\'$e" "\\\\\\^$e"  "\\\\\\$quote$e"]
 set e [rexp E]
 set regces [list  "\\\\`$e"  "\\\\'$e" "\\\\\\^$e"  "\\\\\\$quote$e"]
 set i [rexp \\i$ws]
 set regis  [list  "\\\\`$i" "\\\\'$i"  "\\\\\\^$i"  "\\\\$quote$i"]
 set i [rexp I]
 set regcis  [list "\\\\`$i" "\\\\'$i"  "\\\\\\^$i"  "\\\\$quote$i"]
 set o [rexp o]
 set regos   [list "\\\\`$o" "\\\\'$o"  "\\\\\\^$o"  "\\\\~$o"  "\\\\$quote$o"]
 set o [rexp O]
 set regcos   [list "\\\\`$o" "\\\\'$o"  "\\\\\\^$o"  "\\\\~$o"  "\\\\$quote$o"]
 set u [rexp u]
 set regus    [list "\\\\`$u" "\\\\'$u"  "\\\\\\^$u"  "\\\\$quote$u"]
 set u [rexp U]
 set regcus   [list "\\\\`$u" "\\\\'$u"  "\\\\\\^$u"  "\\\\$quote$u"]
 set reglig   [list "\\\\oe$sep"  "\\\\OE$sep" "\\\\ae$sep" "\\\\AE$sep" "\\\\o$sep" "\\\\O$sep"]
 set regoth1  [list "\\\\c$sp[rexp c]|\\\\c{$ws\(c\)$ws}"  "\\\\~[rexp n]" "\\\\c$sp[rexp C]|\\\\c{$ws\(C\)$ws}"  "\\\\~[rexp N]" ] 
 set regoth2  [list "\\\\\\'[rexp y]" "\\\\\\$quote[rexp y]" "\\\\\\'[rexp Y]" "\\\\\\$quote[rexp Y]"]
		
 set tabRegExpr [concat $regas $regcas $reges $regces $regis $regcis $regos $regcos $regus $regcus\
              $reglig $regoth1  $regoth2 ]

 set GreekExpr [list "\(\\\$\)\\\\\(alpha\)\(\\\$\)" "\(\\\$\)\\\\\(beta\)\(\\\$\)"\
                     "\(\\\$\)\\\\\(chi\)\(\\\$\)" "\(\\\$\)\\\\\(delta\)\(\\\$\)"\
                     "\(\\\$\)\\\\\(epsilon\)\(\\\$\)" "\(\\\$\)\\\\\(phi\)\(\\\$\)"\
					 "\(\\\$\)\\\\\(gamma\)\(\\\$\)" "\(\\\$\)\\\\\(eta\)\(\\\$\)"\
					 "\(\\\$\)\\\\\(iota\)\(\\\$\)" "\(\\\$\)\\\\\(varphi\)\(\\\$\)"\
					 "\(\\\$\)\\\\\(kappa\)\(\\\$\)" "\(\\\$\)\\\\\(lambda\)\(\\\$\)"\
					 "\(\\\$\)\\\\\(mu\)\(\\\$\)" "\(\\\$\)\\\\\(nu\)\(\\\$\)"\
					 "\(\\\$\)\\\\\(pi\)\(\\\$\)" "\(\\\$\)\\\\\(theta\)\(\\\$\)"\
					 "\(\\\$\)\\\\\(rho\)\(\\\$\)" "\(\\\$\)\\\\\(sigma\)\(\\\$\)"\
					 "\(\\\$\)\\\\\(tau\)\(\\\$\)" "\(\\\$\)\\\\\(upsilon\)\(\\\$\)"\
					 "\(\\\$\)\\\\\(varpi\)\(\\\$\)" "\(\\\$\)\\\\\(omega\)\(\\\$\)"\
					 "\(\\\$\)\\\\\(xi\)\(\\\$\)" "\(\\\$\)\\\\\(psi\)\(\\\$\)"\
					 "\(\\\$\)\\\\\(zeta\)\(\\\$\)" "\(\\\$\)\\\\\(Delta\)\(\\\$\)"\
					 "\(\\\$\)\\\\\(Phi\)\(\\\$\)" "\(\\\$\)\\\\\(Gamma\)\(\\\$\)"\
					 "\(\\\$\)\\\\\(vartheta\)\(\\\$\)" "\(\\\$\)\\\\\(Lambda\)\(\\\$\)"\
					 "\(\\\$\)\\\\\(Pi\)\(\\\$\)" "\(\\\$\)\\\\\(Theta\)\(\\\$\)"\
					 "\(\\\$\)\\\\\(Sigma\)\(\\\$\)" "\(\\\$\)\\\\\(varsigma\)\(\\\$\)"\
					 "\(\\\$\)\\\\\(Omega\)\(\\\$\)" "\(\\\$\)\\\\\(Xi\)\(\\\$\)"\
					 "\(\\\$\)\\\\\(Psi\)\(\\\$\)"]

 set HtmlGreek [list "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">a</FONT>"\
                     "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">b</FONT>"\
					 "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">c</FONT>"\
					 "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">d</FONT>"\
					 "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">e</FONT>"\
					 "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">f</FONT>"\
					 "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">g</FONT>"\
					 "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">h</FONT>"\
					 "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">i</FONT>"\
					 "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">j</FONT>"\
					 "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">k</FONT>"\
					 "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">l</FONT>"\
					 "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">m</FONT>"\
					 "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">n</FONT>"\
					 "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">p</FONT>"\
					 "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">q</FONT>"\
					 "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">r</FONT>"\
					 "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">s</FONT>"\
					 "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">t</FONT>"\
					 "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">u</FONT>"\
					 "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">v</FONT>"\
					 "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">w</FONT>"\
					 "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">x</FONT>"\
					 "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">y</FONT>"\
					 "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">z</FONT>"\
					 "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">D</FONT>"\
				     "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">F</FONT>"\
					 "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">G</FONT>"\
					 "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">J</FONT>"\
					 "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">L</FONT>"\
					 "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">P</FONT>"\
					 "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">Q</FONT>"\
					 "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">S</FONT>"\
					 "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">V</FONT>"\
					 "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">W</FONT>"\
					 "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">X</FONT>"\
					 "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">Y</FONT>"]

 set LatexStyles [list 	"(\\\{\\\\it|\\\\textit\{)" "(\\\{\\\\em|\\\\emph\{)"\
                        "(\\\{\\\\bf|\\\\textbf\{)" "(\\\{\\\\tt|\\\\texttt\{)"\
						"(\\\\underline\{)"]
					  
 set HtmlStyles  [list  "<I>" "<EM>" "<B>"	"<TT>" "<U>"]	
 
 set endHtmlStyles [list  "</I>" "</EM>" "</B>"	"</TT>" "</U>"]
					 
 set tabfieldnames [list "address" "annote" "author" "booktitle" "chapter" "city" "crossref"\
	                     "edition" "editor" "howpublished" "institution" "isbn" "journal"\
						 "key" "language" "month" "note" "number" "organization" "pages" "publisher"\
						 "school" "series" "title" "type" "volume" "year"]					 
			
    set entries(article) "articleHtml"
	set entries(book) "bookHtml"
	set entries(booklet) "bookletHtml"
	set entries(conference) "conferenceHtml"
	set entries(inbook) "inbookHtml"
	set entries(incollection) "incollectionHtml"
	set entries(inproceedings) "inproceedingsHtml"
	set entries(manual) "manualHtml"
	set entries(mastersthesis) "mastersthesisHtml"
	set entries(misc) "miscHtml"
	set entries(phdthesis) "phdthesisHtml"
	set entries(proceedings) "proceedingsHtml"
	set entries(techreport) "techreportHtml"
	set entries(unpublished) "unpublishedHtml"
# Home bib entries

    set countbibentries 0
	
		while {$pos1 < $endselection} {
			set pos2 [expr $pos1 + 1]
			set char [getText $pos1 $pos2]

#	
# look for the beginning of a bib entry. Keep the label  and  the name
# of this bib entry: article, book, ...
			if {$char == "@"} {
				goto $pos1
				endOfLine
				set pos2 [getPos]
				set line [getText $pos1 $pos2]
				set values [ParsingEntry $line]
				set entryname [lindex $values 1]
				incr countbibentries
				set labelname [lindex $values 2]
#		alertnote "entree bib = $entryname"
 #		alertnote "etiquette =  $labelname"
		
       # Search for end of the entry
				beginningOfLine
				nextLine
				set pos1 [getPos]
				set endentry [SearchNextEntry $pos1]
		        set lenfields [llength $tabfieldnames] 
	            set i 0
                while {$i < $lenfields} {
	                  set fi [lindex $tabfieldnames $i]
			          set fields($fi) ""		     
		              incr i}


# Parsing of the different fields of an entry. Search for field name: author, title, ...
				while {$pos1 < $endentry} {
		           set values [search -n -l $endentry "="  $pos1]
				   if {$values == ""} {
						set pos1 $endentry
						continue}
				   set pos2 [lindex $values 0]
				   set fieldname [getText $pos1 $pos2]
				   set fieldname [string trim $fieldname]
				   set fieldname [string tolower $fieldname]
# Search for beginning   of text of the field
				   set pos1  [lindex $values 1] 
				   endOfLine
				   set pos2 [getPos]
				   set buffield [getText $pos1 $pos2]
			       set buffield [string trim $buffield ]  
			       set begcharfield [string index $buffield 0]			       
		# the field is enclosed between two braces, searching for ending brace 
			       if {$begcharfield == "\{" } {
					   set buffield [string range $buffield 1 end]
		               set lenbuff [string length $buffield]
	                   set fieldtext "" 
					   set countbraces "1"
                       while {$countbraces > 0 } {
		                     set j 0
	                      	 while {$j < $lenbuff} {
		                         set char [string index $buffield $j]
		                         if {$char == "\{" } {incr countbraces 1}
		                         if {$char == "\}" } {incr countbraces -1}
		                         incr j}
		                     append fieldtext " $buffield"
							 if {$countbraces > 0 } {
								 beginningOfLine
								 nextLine
								 set pos1 [getPos]
								 endOfLine
				                 set pos2 [getPos]
				                 set buffield [getText $pos1 $pos2]
			                     set buffield [string trim $buffield ]
							     set lenbuff [string length $buffield]}
	                   }
                       set fieldtext [string trimright $fieldtext ","]
					   set fieldtext [string trimleft $fieldtext]
					   set lenfieldtext [string length $fieldtext]
					   set fieldtext [string range $fieldtext 0 [expr $lenfieldtext - 2]]
			       }
	  # the field is enclosed between two quotes, searching for ending quote
		           if {$begcharfield == $quote} {
					   set buffield [string range $buffield 1 end]
	                   set fieldtext ""
					   set lastchar ""
					   while {$lastchar != $quote} {
						   append fieldtext " $buffield"
						   set lenbuff [string length $buffield]
						   set value0 [string index $buffield [expr $lenbuff - 2]]
						   set value1 [string index $buffield [expr $lenbuff - 1]]
						   if {$value1 == $quote} {set lastchar $quote}
					       if {$value0 == $quote && $value1 == ","} {set lastchar $quote}
						   if {$value0 != $quote && $value1 != $quote} {
							     beginningOfLine
								 nextLine
								 set pos1 [getPos]
								 endOfLine
				                 set pos2 [getPos]
				                 set buffield [getText $pos1 $pos2]
			                     set buffield [string trim $buffield ]}   
						}
						set fieldtext [string trimright $fieldtext ","]
						set fieldtext [string trimright $fieldtext $quote]
				   }
			   
           # No enclosing mark for the field (page, year, volume, number ?),
		   # search for ending "," or RC or space
		          if {$begcharfield != $quote && $begcharfield != "\{" } { 
					  set fieldtext [string trimright $buffield ","]}
		   # End of field, position to following field
				   set pos1 [expr $pos2 + 1]
			       goto $pos1		
# Keep the content of each field
					SearchCite 
                    set fields($fieldname) $fieldtext 		
	          }
		  eval $entries($entryname)
		  }
       incr pos1 
      }
   append bufferhtml "</DL>\r\r</BODY>\r </HTML>"
   puts $idhtml $bufferhtml
   close $idhtml
   goto 0
   set values [dialog -w 400 -h 140\
	          -r "Do you want send the html file to browser?" 1 10 20 340 40\
	          -r "Do you want edit the html file?"  0 10 60 280 80\
	          -b OK 50 100 115 120 -b Cancel 200 100 265 120]
   set cancel [string trim [lindex $values 3]]
   if {$cancel == 1} {
          beep
	      return}
   set browse [string trim [lindex $values 0]]
   set edithtml [string trim [lindex $values 1]]
   if {$browse == 1}  {
	   htmlSendWindow $htmlfile
	   return} 
   if {$edithtml == 1} {
        edit $htmlfile}
   
 }	


#
#		
###################################################
#
# This part converts each  bib entry in html.
# This conversion processes european letters
# as , , , , , and so on. 
# 


#
# This procedure is called for conversion of  any field
# of a bib entry. The characters in LaTeX format are converted
# in HTML. All remaining characters as CR or LF or braces are removed
 
proc convert::txt2html {index} {
	global  tabHtmlChar tabRegExpr fields
	global HtmlGreek GreekExpr
	global LatexStyles HtmlStyles endHtmlStyles
#	
	regsub -all "\r" $fields($index) "" fields($index)
	regsub -all "\b" $fields($index) "" fields($index)
	regsub -all "\f" $fields($index) "" fields($index)
	regsub -all "\n" $fields($index) " " fields($index)
	regsub -all "" $fields($index) "\\&#176;" fields($index)  
	set indicbs [string first "\\" $fields($index) ]
	if {$indicbs == -1} {
		regsub -all "\{" $fields($index) "" fields($index)
 	    regsub -all "\}" $fields($index) "" fields($index)
		return}
    set len [llength $tabRegExpr]
	set i 0
    while {$i < $len} {
	      set c [lindex $tabRegExpr $i]
		  set s [lindex $tabHtmlChar $i]
		  regsub -all "$c" $fields($index) "$s" fields($index) 
		  incr i}
# Searches for and converts greek letters in title of mathematical articles
   	set indicbs [string first "\\" $fields($index) ]
	if {$indicbs == -1} {
		regsub -all "\{" $fields($index) "" fields($index)
 	    regsub -all "\}" $fields($index) "" fields($index)
		return}
    set len [llength $GreekExpr]
	set i 0
    while {$i < $len} {
	       set c [lindex $GreekExpr $i]
		   set s [lindex $HtmlGreek $i]
		   regsub -all "$c" $fields($index) "$s" fields($index) 
		   incr i}
    
# Searches for styles italic, emphasized, typewriter, bold, underlined.
	set indicbs [string first "\\" $fields($index) ]
	if {$indicbs == -1} {
		regsub -all "\{" $fields($index) "" fields($index)
 	    regsub -all "\}" $fields($index) "" fields($index)
		return}
    set len [llength $LatexStyles]
	set j 0
    while {$j < $len} {
		   set style [lindex $LatexStyles $j]
           set found [regexp -indices $style $fields($index) values]
		   if {$found == 1} {
				  set begtext  [lindex $values 0]
				  set bufftmp [string range $fields($index) 0 [expr $begtext - 1]]
				  set htmlconv [lindex $HtmlStyles $j]
				  append bufftmp " $htmlconv"
				  set i 0
				  set braces 1
				  set lentmp [expr [string length  $fields($index) ] - [lindex $values 1]]
				  while {$i < $lentmp} {
					  set char [string index $fields($index) [expr [lindex $values 1] + $i + 1]]
					  if {$char == "\{"} {incr braces}
					  if {$char == "\}"} {incr braces -1
					                      if {$braces == 0} {
										       set char [lindex $endHtmlStyles $j]
											   set ii [expr $i+1]
										       set i $lentmp} 
					  }
				      append bufftmp $char
					  incr i
				  }
		         append bufftmp [string range $fields($index) [expr [lindex $values 1]+$ii+1] end]
				 set fields($index) $bufftmp
			  }
			  incr j
     }
# Searches for and converts \uppercase commands
	 set uppercase [string first "\\uppercase" $fields($index)]
	 while {$uppercase >= 0} {
		 set bufftmp [string  range $fields($index) 0 [expr $uppercase-1]]
		 set fields($index) [string range $fields($index) [expr $uppercase+11] end]
		 set closbrace [string first "\}" $fields($index)]
		 set char [string range $fields($index) 0  $closbrace]
		 set char [string trimright $char "\}"]
		 set char [string toupper $char]
		 append bufftmp $char
		 append bufftmp [string  range $fields($index) [expr $closbrace+1] end]
		 set fields($index) $bufftmp
		 set uppercase [string first "\\uppercase" $fields($index)]
	 }
# Converts possible \bullet latex commands.
	regsub -all "\(\\\$\)\\\\\(bullet\)\(\\\$\)" $fields($index) "\\&#176;" fields($index)
# Clears all possible remaining backslashes
	regsub -all "\\\\" $fields($index) "" fields($index)
# Clears possible remaining braces and backslashes.
	regsub -all "\{" $fields($index) "" fields($index)
    regsub -all "\}" $fields($index) "" fields($index)
	return 
}




#############################################
#
# This procedure is called for processing a 
# crossref field in a bib entry
#

proc crossrefField {reference} {
  goto 0
  endOfBuffer
  set pos20 [getPos]
  set endofwin $pos20
  set reference "\{$reference,"
  set values [search -n -l $pos20 $reference  0]
  set pos20 [lindex $values 1]  
  set endsearch 0
  set buffauthor ""
  set buffeditor ""
  set buffkey ""
  set bufftitle ""
  set buffyear ""
  set id -1
  while {$endsearch == 0} {
	  set pos10 [nextLineStart $pos20]
	  if {$pos10 == $endofwin} {
		    set endsearch 1
			continue}
	  goto $pos10
	  endOfLine
	  set pos20 [getPos]
	  set line [getText $pos10 $pos20]
	  set line [string trim $line]
	  set values [ParsingEntry $line]
	  set endsearch [lindex $values 0]
	  if {$endsearch == 1} {continue}
	  scan $line %s fieldname
	  set fieldname [string tolower $fieldname]
	  if {$fieldname == "author"} {
		  set index [string first "=" $line]
		  set line [string range $line [expr $index + 1] end]
		  set buffauthor [ParsingField $id $line]
		  continue}
	  if {$fieldname == "editor"} {
		   set index [string first "=" $line]
		   set line [string range $line [expr $index + 1] end]
		   set buffeditor [ParsingField $id $line]
		   continue}
	  if {$fieldname == "key"} {
		   set index [string first "=" $line]
		   set line [string range $line [expr $index + 1] end]
		   set buffkey [ParsingField $id $line]
		   continue}
	  if {$fieldname == "title"} {
		   set index [string first "=" $line]
		   set line [string range $line [expr $index + 1] end]
		   set bufftitle [ParsingField $id $line]
		   continue}
	  if {$fieldname == "year"} {
		   set index [string first "=" $line]
		   set line [string range $line [expr $index + 1] end]
		   set buffyear [ParsingField $id $line]
		   continue}
	}
	if {$buffauthor != ""} {
			set reference "$buffauthor, $buffyear"
		    return $reference}
    if {$buffeditor != ""} {
			set reference "$buffeditor, $buffyear"
		    return $reference}
	if {$buffkey != ""} {
			set reference "$buffkey, $buffyear, \{\\it $bufftitle\}"
		    return $reference}
	set reference [string trimleft $reference "\{"]
	set reference [string trimright $reference ","]
	set reference   "undefined: $reference"
    return $reference
}


#
##################################################
#
#
# Processing of current bib entries
#
#

	
#
# Articles in journal

proc articleHtml {} {
	global fields idhtml labelname countbibentries 
	global bufferhtml
	set quote {"}
	append bufferhtml "<DT><A NAME=$quote$labelname$quote></A><B>$countbibentries</B>\r"
	convert::txt2html author
	append  bufferhtml "<DD> $fields(author).  <BR>\r"
    convert::txt2html title
	append  bufferhtml  "$fields(title). <BR>\r"
    convert::txt2html journal
	append  bufferhtml "<I>$fields(journal),</I> "
    set FlagVolNum 0
	if {$fields(volume) != ""} {
		set FlagVolNum 1
		append  bufferhtml  "<B>$fields(volume)</B>"
		}
	if {$fields(number) != ""} {
		set FlagVolNum 1
		append  bufferhtml "($fields(number))"
		}
	if 	{$fields(month) != ""} {
	     convert::txt2html month
		 set monthyear "$fields(month) $fields(year)"} else {
			                      set monthyear "$fields(year)"
	}
	if {$FlagVolNum == 1} {
	       append  bufferhtml  ", $monthyear"} else {
			              append  bufferhtml  " $monthyear"}
	if {$fields(pages) != ""} {
		set hyphenfound [string first "-" $fields(pages) ]
		if {$hyphenfound != -1} {
			 regsub  {(--)+} $fields(pages) "-" fields(pages)
			 set fields(pages) "pp. $fields(pages)"
			}  else {set fields(pages) "p. $fields(pages)"}
		append  bufferhtml ", $fields(pages)"
		}
     
    append  bufferhtml ".<BR>\r"
	if {$fields(note) != ""} {
	   convert::txt2html note
	   append  bufferhtml  $fields(note) ".<BR>\r"
	   }
	append  bufferhtml "<BR>\r\r"
 return
}


#
# Books

proc bookHtml {} {
	global fields idhtml labelname countbibentries
	global bufferhtml
	set quote {"}
	append bufferhtml "<DT><A NAME=$quote$labelname$quote></A><B>$countbibentries</B>\r"
	convert::txt2html author
	append  bufferhtml "<DD> $fields(author).  <BR>\r"
    convert::txt2html title
    if {$fields(series) != ""} {
		convert::txt2html series
		append  bufferhtml "<I>$fields(title),</I> $fields(series). <BR>\r"} else {
			           append  bufferhtml "<I>$fields(title).</I><BR>\r"}
	if {$fields(publisher) != ""} {
	    convert::txt2html publisher
	    append  bufferhtml "$fields(publisher), "}
	if {$fields(address) != ""} {
	     convert::txt2html address
       	 append  bufferhtml "$fields(address), "}
	if 	{$fields(month) != ""} {
	     convert::txt2html month
		 set monthyear "$fields(month) $fields(year)"} else {
			                      set monthyear "$fields(year)"
	}
	append  bufferhtml  "$monthyear"
	if {$fields(edition) != ""} {
	     convert::txt2html edition
       	 append  bufferhtml ", $fields(edition) edition"
	 }
	append  bufferhtml  ".<BR>\r"
	if {$fields(note) != ""} {
	   convert::txt2html note
	   append  bufferhtml  "$fields(note).<BR>\r"
	   }
	append  bufferhtml "<BR>\r\r"
 return
}


#
# Booklets

proc bookletHtml {} {
	global fields idhtml labelname countbibentries
	global bufferhtml
	set quote {"}
	append bufferhtml "<DT><A NAME=$quote$labelname$quote></A><B>$countbibentries</B>\r"
    if 	{$fields(author) != ""} {
	       convert::txt2html author
	       append  bufferhtml "<DD> $fields(author).<BR>\r"} else {
			                    if 	{$fields(key) != ""} {
									  convert::txt2html key
									  append  bufferhtml "<DD> $fields(key).<BR>\r"} else {
										                  append  bufferhtml "<DD>"}
	}
    convert::txt2html title
	append  bufferhtml "<I>$fields(title)"
	if {$fields(howpublished) != ""} {
	   convert::txt2html howpublished
	   append  bufferhtml  ".</I><BR>\r $fields(howpublished), "
	   } else {append  bufferhtml  ".</I><BR>\r"}
	if 	{$fields(month) != ""} {
	     convert::txt2html month
		 set monthyear "$fields(month) $fields(year)"} else {
			                      set monthyear "$fields(year)"
	}
	append  bufferhtml  " $monthyear<BR>\r"
	if {$fields(note) != ""} {
	   convert::txt2html note
	   append  bufferhtml  "$fields(note).<BR>\r"
	   }
	append  bufferhtml "<BR>\r\r"
 return
}

#
# Conferences 
#
proc conferenceHtml {} {
	global fields idhtml labelname countbibentries
	global bufferhtml
	set quote {"}
	append bufferhtml "<DT><A NAME=$quote$labelname$quote></A><B>$countbibentries</B>\r"
	convert::txt2html author
	append  bufferhtml "<DD> $fields(author).  <BR>\r"
    convert::txt2html title
	append  bufferhtml  "$fields(title). <BR>\r"
	if {$fields(crossref) != ""} {
		set fields(crossref) [crossrefField $fields(crossref)]
	    convert::txt2html crossref
	    append  bufferhtml  "In ($fields(crossref))"} else {
 	                     convert::txt2html booktitle
	                     append  bufferhtml "In <I>$fields(booktitle)"
						 if {$fields(editor) != ""} {
	                            convert::txt2html editor
	                     append  bufferhtml ",</I> $fields(editor) Ed."}
	                     if {$fields(organization) != ""} {
	                            convert::txt2html organization
	                     append  bufferhtml ",</I> $fields(organization)"}
                         if {$fields(series) != ""} {
		                        append  bufferhtml ",</I> $fields(series)"}
	                     append  bufferhtml ".</I> <BR>\r"
	                     if {$fields(publisher) != ""} {	  
	                               convert::txt2html publisher
	                               append  bufferhtml " $fields(publisher), "
		                  }
	                      if {$fields(address) != ""} {		 
	                               convert::txt2html address
	                               append  bufferhtml "$fields(address), "
		                  }
						  if 	{$fields(month) != ""} {
	                                 convert::txt2html month
		                             set monthyear "$fields(month) $fields(year)"} else {
			                                set monthyear "$fields(year)"
	                      }
	                      append  bufferhtml  "$monthyear"
	}
	if {$fields(pages) != ""} {
		set hyphenfound [string first "-" $fields(pages) ]
		if {$hyphenfound != -1} {
			 regsub  {(--)+} $fields(pages) "-" fields(pages)
			 append  bufferhtml  ", pp. $fields(pages)"
			}  else {append  bufferhtml  ", p. $fields(pages)"}
		}
	append  bufferhtml  ".<BR>\r"
	if {$fields(note) != ""} {
	   convert::txt2html note
	   append  bufferhtml  "$fields(note).<BR>\r"
	   }
	append  bufferhtml "<BR>\r\r"
 return
}


#
# In books

proc inbookHtml {} {
	global fields idhtml labelname countbibentries
	global bufferhtml
	set quote {"}
	append bufferhtml "<DT><A NAME=$quote$labelname$quote></A><B>$countbibentries</B>\r"
	convert::txt2html author
	append  bufferhtml "<DD> $fields(author).  <BR>\r"
	if {$fields(crossref) != ""} {
		set fields(crossref) [crossrefField $fields(crossref)]
	    convert::txt2html crossref
	    append  bufferhtml  "In ($fields(crossref)), "} else {
                  convert::txt2html title
	              append  bufferhtml  "<I>$fields(title),</I> "   
	              if {$fields(chapter) != ""} {
	                   append  bufferhtml  "chapter $fields(chapter). <BR>\r"}
		convert::txt2html publisher
	    append  bufferhtml "$fields(publisher), "
	    convert::txt2html address
	    append  bufferhtml "$fields(address), "
		if 	{$fields(month) != ""} {
	     convert::txt2html month
		 set monthyear "$fields(month) $fields(year)"} else {
			                      set monthyear "$fields(year)"
  	    }
		append  bufferhtml  "$monthyear, "
	 }
	 if {$fields(pages) != ""} {
		set hyphenfound [string first "-" $fields(pages) ]
		if {$hyphenfound != -1} {
			 regsub  {(--)+} $fields(pages) "-" fields(pages)
			 append  bufferhtml  " pp. $fields(pages)"
			}  else {append  bufferhtml  " p. $fields(pages)"}
		} 
     if {$fields(chapter) != ""} {
	    append  bufferhtml " chap.$fields(chapter)"
	}
	if {$fields(edition) != ""} {
	     convert::txt2html edition
       	 append  bufferhtml ", $fields(edition) edition"
	 }
	append  bufferhtml  ".<BR>\r"
	if {$fields(note) != ""} {
	   convert::txt2html note
	   append  bufferhtml  "$fields(note).<BR>\r"
	   }
	append  bufferhtml "<BR>\r\r"
 return
}

#
# In collections

proc incollectionHtml {} {
	global fields idhtml labelname countbibentries
	global bufferhtml
	set quote {"}
	append bufferhtml "<DT><A NAME=$quote$labelname$quote></A><B>$countbibentries</B>\r"
	convert::txt2html author
	append  bufferhtml "<DD> $fields(author).  <BR>\r"
    convert::txt2html title
	append  bufferhtml  "$fields(title), <BR>\r"
	if {$fields(crossref) != ""} {
		set fields(crossref) [crossrefField $fields(crossref)]
	    convert::txt2html crossref
	    append  bufferhtml  "In ($fields(crossref))"} else {
	            convert::txt2html booktitle
	            append  bufferhtml "In <I>$fields(booktitle)"
	            if {$fields(editor) != ""} {
	                convert::txt2html editor
	                append  bufferhtml ",</I> $fields(editor), Ed"
	             }
	            if {$fields(series) != ""} {
                    append  bufferhtml  ",</I> $fields(series)"
				}
	            if {$fields(volume) != ""} {
	                if {$fields(chapter) != ""} {
	                    append  bufferhtml  ",</I> <B>$fields(volume),</B>" 
					    append  bufferhtml  "chap. $fields(chapter)"} else {
			                        append  bufferhtml  ",</I> <B>$fields(volume),</B>"}	
		            } else {if {$fields(chapter) != ""} {
					             append  bufferhtml  ",</I>  chap. $fields(chapter)"} 
                 }	     
               append  bufferhtml ".</I> <BR>\r"
               convert::txt2html publisher
	           append  bufferhtml "$fields(publisher), "
	           if {$fields(address) != ""} {
    	            convert::txt2html address
	                append  bufferhtml "$fields(address), "}
	}
	if 	{$fields(month) != ""} {
	     convert::txt2html month
		 set monthyear "$fields(month) $fields(year)"} else {
			                      set monthyear "$fields(year)"
	}
	append  bufferhtml  "$monthyear, "
	if {$fields(pages) != ""} {
		set hyphenfound [string first "-" $fields(pages) ]
		if {$hyphenfound != -1} {
			 regsub  {(--)+} $fields(pages) "-" fields(pages)
			 append  bufferhtml  "pp. $fields(pages).<BR>\r"
			}  else {append  bufferhtml  "p. $fields(pages).<BR>\r"}
		}
	if {$fields(note) != ""} {
	   convert::txt2html note
	   append  bufferhtml  "$fields(note).<BR>\r"
	   }
	append  bufferhtml "<BR>\r\r"
 return
}


#
# Articles in conference procedings

proc inproceedingsHtml {} {
	global fields idhtml labelname countbibentries
	global bufferhtml
	set quote {"}
	append bufferhtml "<DT><A NAME=$quote$labelname$quote></A><B>$countbibentries</B>\r"
	convert::txt2html author
	append  bufferhtml "<DD> $fields(author).  <BR>\r"
    convert::txt2html title
	append  bufferhtml  "$fields(title). <BR>\r"
	if {$fields(crossref) != ""} {
		set fields(crossref) [crossrefField $fields(crossref)]
	    convert::txt2html crossref
	    append  bufferhtml  "In ($fields(crossref))"} else {
 	                     convert::txt2html booktitle
	                     append  bufferhtml "In <I>$fields(booktitle)"
						 if {$fields(editor) != ""} {
	                            convert::txt2html editor
	                     append  bufferhtml ",</I> $fields(editor) Ed."}
	                     if {$fields(organization) != ""} {
	                            convert::txt2html organization
	                     append  bufferhtml ",</I> $fields(organization)"}
                         if {$fields(series) != ""} {
		                        append  bufferhtml ",</I> $fields(series)"}
	                     append  bufferhtml ".</I> <BR>\r"
	                     if {$fields(publisher) != ""} {	  
	                               convert::txt2html publisher
	                               append  bufferhtml " $fields(publisher), "
		                  }
	                      if {$fields(address) != ""} {		 
	                               convert::txt2html address
	                               append  bufferhtml "$fields(address), "
		                  }
						  if 	{$fields(month) != ""} {
	                                 convert::txt2html month
		                             set monthyear "$fields(month) $fields(year)"} else {
			                                set monthyear "$fields(year)"
	                      }
	                      append  bufferhtml  "$monthyear"
	}
	if {$fields(pages) != ""} {
		set hyphenfound [string first "-" $fields(pages) ]
		if {$hyphenfound != -1} {
			 regsub  {(--)+} $fields(pages) "-" fields(pages)
			 append  bufferhtml  ", pp. $fields(pages)"
			}  else {append  bufferhtml  ", p. $fields(pages)"}
		}
	append  bufferhtml  ".<BR>\r"
	if {$fields(note) != ""} {
	   convert::txt2html note
	   append  bufferhtml  "$fields(note).<BR>\r"
	   }
	append  bufferhtml "<BR>\r\r"
 return
}

#
# Manual: technical documentation

proc manualHtml {} {
	global fields idhtml labelname countbibentries
	global bufferhtml
	set quote {"}
	append bufferhtml "<DT><A NAME=$quote$labelname$quote></A><B>$countbibentries</B>\r"
    if 	{$fields(author) != ""} {
	       convert::txt2html author
	       append  bufferhtml "<DD> $fields(author).<BR>\r"} else {
			                    if 	{$fields(key) != ""} {
									  convert::txt2html key
									  append  bufferhtml "<DD> $fields(key).<BR>\r"} else {
										                  append  bufferhtml "<DD>"}
	}
    convert::txt2html title
	if 	{$fields(month) != ""} {
	     convert::txt2html month
		 set monthyear "$fields(month) $fields(year)"} else {
			                      set monthyear "$fields(year)"
	}
	append  bufferhtml  "<I>$fields(title).</I><BR>\r"
	if {$fields(organization) != ""} {
	     convert::txt2html organization
	     append  bufferhtml " $fields(organization),"
	}
	append  bufferhtml "$monthyear<BR>\r"
    if {$fields(edition) != ""} {
	     convert::txt2html edition
       	 append  bufferhtml ", $fields(edition) edition.<BR>"
	 }
	if {$fields(note) != ""} {
	   convert::txt2html note
	   append  bufferhtml  "$fields(note).<BR>\r"
	   }
	append  bufferhtml "<BR>\r\r"
 return
}


#
# Master's thesis

proc mastersthesisHtml {} {
	global fields idhtml labelname countbibentries
	global bufferhtml
	set quote {"}
	append bufferhtml "<DT><A NAME=$quote$labelname$quote></A><B>$countbibentries</B>\r"
	convert::txt2html author
	append  bufferhtml "<DD> $fields(author).<BR>\r"
    convert::txt2html title
	append  bufferhtml  "<I>$fields(title).</I><BR>\r"
	if {$fields(type) != ""} {
	   convert::txt2html type
	   append  bufferhtml  "$fields(type), "
	   } else {append  bufferhtml "Master's thesis, "}
	if {$fields(school) != ""} {
	   convert::txt2html school
	   append  bufferhtml  "$fields(school), "
	   }
	if {$fields(address) != ""} {
	   convert::txt2html address
	   append  bufferhtml  "$fields(address), "
	   }
	if 	{$fields(month) != ""} {
	     convert::txt2html month
		 set monthyear "$fields(month) $fields(year)"} else {
			                      set monthyear "$fields(year)"
	}   
	append  bufferhtml "$monthyear.<BR>\r"
	if {$fields(note) != ""} {
	   convert::txt2html note
	   append  bufferhtml  "$fields(note).<BR>\r"
	   }
	append  bufferhtml "<BR>\r\r"
 return
}


#
# Misc

proc miscHtml {} {
	global fields idhtml labelname countbibentries
	global bufferhtml
	set quote {"}
	append bufferhtml "<DT><A NAME=$quote$labelname$quote></A><B>$countbibentries</B>\r"
	if 	{$fields(author) != ""} {
	       convert::txt2html author
	       append  bufferhtml "<DD> $fields(author).<BR>\r"} else {
			                     if {$fields(key) != ""} {
									 convert::txt2html key
									 append  bufferhtml "<DD> $fields(key).<BR>\r"} else {
										  append  bufferhtml "<DD>"}
	}
    if 	{$fields(title) != ""} {
	       convert::txt2html title
	       append  bufferhtml "<I>$fields(title),</I><BR>\r"}
    if {$fields(howpublished) != ""} {
	   convert::txt2html howpublished
	   append  bufferhtml  "$fields(howpublished),\r"
	   }
	if 	{$fields(month) != ""} {
	     convert::txt2html month
		 set monthyear "$fields(month) $fields(year)"} else {
			                      set monthyear "$fields(year)"
	}
	append  bufferhtml  " $monthyear.<BR>\r"
	if {$fields(note) != ""} {
	   convert::txt2html note
	   append  bufferhtml  "$fields(note).<BR>\r"
	   }
	append  bufferhtml "<BR>\r\r"
 return
}

#
# PhD thesis

proc phdthesisHtml {} {
	global fields idhtml labelname countbibentries
	global bufferhtml
	set quote {"}
	append bufferhtml "<DT><A NAME=$quote$labelname$quote></A><B>$countbibentries</B>\r"
	convert::txt2html author
	append  bufferhtml "<DD> $fields(author).  <BR>\r"
    convert::txt2html title
	append  bufferhtml  "<I>$fields(title).</I><BR>\r"
	if {$fields(type) != ""} {
	   convert::txt2html type
	   append  bufferhtml  "$fields(type), "
	   } else {append  bufferhtml "PhD thesis, "}
	if {$fields(school) != ""} {
	   convert::txt2html school
	   append  bufferhtml  "$fields(school), "
	   }
	if {$fields(address) != ""} {
	   convert::txt2html address
	   append  bufferhtml  "$fields(address), "
	   }
	if 	{$fields(month) != ""} {
	     convert::txt2html month
		 set monthyear "$fields(month) $fields(year)"} else {
			                      set monthyear "$fields(year)"
	}   
	append  bufferhtml "$monthyear.<BR>\r"
	if {$fields(note) != ""} {
	   convert::txt2html note
	   append  bufferhtml  "$fields(note).<BR>\r"
	   }
	append  bufferhtml "<BR>\r\r"
 return
}

#
# Procedings

proc proceedingsHtml {} {
	global fields idhtml labelname countbibentries
	global bufferhtml
	set quote {"}
	append bufferhtml "<DT><A NAME=$quote$labelname$quote></A><B>$countbibentries</B>\r"
	if 	{$fields(editor) != ""} {
	       convert::txt2html editor
	       append  bufferhtml "<DD> $fields(editor), Ed.<BR>\r"} else {
			                   if {$fields(key) != ""} {
								   convert::txt2html key
								   append  bufferhtml "<DD> $fields(key).<BR>\r"} else {
										                        append  bufferhtml "<DD>"}
	}
    convert::txt2html title
	if {$fields(series) != ""} {
		append  bufferhtml  "<I>$fields(title),</I> $fields(series). <BR>\r"
        } else {append  bufferhtml  "<I>$fields(title).</I> <BR>\r"}
	if {$fields(organization) != ""} {
	    convert::txt2html organization
	    append  bufferhtml "$fields(organization), "}
	set hyphenfound [string first "--" $fields(pages) ]
	if {$fields(pages) != ""} {
		set hyphenfound [string first "--" $fields(pages) ]
		if {$hyphenfound != -1} {
			 regsub  {(--)+} $fields(pages) "-" fields(pages)
			 append  bufferhtml  "pages $fields(pages). <BR>\r"
			}  else {append  bufferhtml  "page $fields(pages). <BR>\r"}
		}
	if {$fields(publisher) != ""} {	  
	     convert::txt2html publisher
	     append  bufferhtml "$fields(publisher), "
		 }
	if {$fields(address) != ""} {		 
	     convert::txt2html address
	     append  bufferhtml "$fields(address), "
		 }
	if 	{$fields(month) != ""} {
	     convert::txt2html month
		 set monthyear "$fields(month) $fields(year)"} else {
			                      set monthyear "$fields(year)"
	}
	append  bufferhtml  "$monthyear.<BR>\r"
	if {$fields(note) != ""} {
	   convert::txt2html note
	   append  bufferhtml  "$fields(note).<BR>\r"
	   }
	append  bufferhtml "<BR>\r\r"
 return
}

#
# Technical report

proc techreportHtml {} {
	global fields idhtml labelname countbibentries
	global bufferhtml
	set quote {"}
	append bufferhtml "<DT><A NAME=$quote$labelname$quote></A><B>$countbibentries</B>\r"
	convert::txt2html author
	append  bufferhtml "<DD> $fields(author).  <BR>\r"
    convert::txt2html title
	if {$fields(series) != ""} {
	   append  bufferhtml  "<I>$fields(title),</I> $fields(series).<BR>\r"
	   } else {append  bufferhtml  "<I>$fields(title).</I><BR>\r"}
    if 	{$fields(type) != ""} {
	     convert::txt2html type
		 set techreportname "$fields(type)"} else {
			                      set techreportname "Tech. Rep."}
	if {$fields(number) != ""} {
	   append  bufferhtml  "$techreportname $fields(number), "
	   }
	if {$fields(institution) != ""} {
		convert::txt2html institution
	    append  bufferhtml  "$fields(institution), "
	   }
	if 	{$fields(month) != ""} {
	     convert::txt2html month
		 set monthyear "$fields(month) $fields(year)"} else {
			                      set monthyear "$fields(year)"
	}
	append  bufferhtml "$monthyear.<BR>\r"
	if {$fields(note) != ""} {
	   convert::txt2html note
	   append  bufferhtml  "$fields(note).<BR>\r"
	   }
	append  bufferhtml "<BR>\r\r"
 return
}


#
# Unpublished

proc unpublishedHtml {} {
	global fields idhtml labelname countbibentries
	global bufferhtml
	set quote {"}
	append bufferhtml "<DT><A NAME=$quote$labelname$quote></A><B>$countbibentries</B>\r"
	convert::txt2html author
	append  bufferhtml "<DD> $fields(author).  <BR>\r"
    convert::txt2html title
	if 	{$fields(month) != ""} {
	     convert::txt2html month
		 set monthyear "$fields(month) $fields(year)"} else {
			                      set monthyear "$fields(year)"
	}
	append  bufferhtml  "<I>$fields(title),</I> $monthyear.<BR>\r"
	if {$fields(note) != ""} {
	   convert::txt2html note
	   append  bufferhtml  "$fields(note).<BR>\r"
	   }
	append  bufferhtml "<BR>\r\r"
 return
}


##########################################################
#
# Home bib entries can be added. These new entries
# have to be created in bibteXMode.tcl file, then the list
# "entries" of bibToHtml has to be increased and, at last,
# some procedures for conversion in html are needed.
# 
##########################################################




