## -*-Tcl-*-
 # ###################################################################
 #  None - none
 # 
 #  FILE: "tkdiffControl.tcl"
 #                                    created: 04/29/98 {01:10:14 AM} 
 #                                last update: 08/06/1999 {09:14:22 AM} 
 #  Author: Vince Darley
 #  E-mail: vince@biosgroup.com
 #    mail: Bios Group
 #          617 Paseo de Peralta, Santa Fe, NM 87501
 #     www: http://www.biosgroup.com/
 #  
 # ###################################################################
 ##



alpha::feature tkdiffControl 0.1 global-only {
    alpha::package require scriptRunner
    namespace eval Diff {}
    set Diff::handlers(Tkdiff) Diff::tkrun
} {} {} uninstall {
    removeFile "$pkg_file"
    removeFile [file join ${HOME} Tools "tkdiff.tcl"]
} maintainer {
    "Vince Darley" darley@fas.harvard.edu <http://www.fas.harvard.edu/~darley/>
} help {
    See Tkdiff help
}


proc Diff::tkrun {} {
    global Diff::1 Diff::2 DiffSig tcl_platform
    if {$tcl_platform(platform) == "windows" } {
	regsub -all "\\\\" [set Diff::1] "/" Diff::1
	regsub -all "\\\\" [set Diff::2] "/" Diff::2
    }
    if {[file exists $DiffSig]} {
	eval script::run tkdiff [list -script \
	  [list set env(diffcmd) $DiffSig] [stripNameCount ${Diff::1}] \
	  [stripNameCount ${Diff::2}]]
    } else {
	eval script::run tkdiff [list -script \
	  [list set env(diffcmd) [nameFromAppl $DiffSig]] \
	  [stripNameCount ${Diff::1}] [stripNameCount ${Diff::2}]]
    }
}





