/* -*-C++-*-
 * ###################################################################
 *	Cpptcl - Integrating C++ with Tcl
 * 
 *	FILE: "cpxTutorial.h"
 *									  created: 8/12/96 {11:48:51 pm} 
 *								  last update: 29/10/97 {10:42:56 am} 
 *	Author:	Vince Darley
 *	E-mail:	<darley@fas.harvard.edu>
 *	  mail:	Division of	Applied	Sciences, Harvard University
 *			Oxford Street, Cambridge MA	02138, USA
 *	   www:	<http://www.fas.harvard.edu/~darley/>
 *	
 *	Description: 
 * 
 * 
 *	History
 * 
 *	modified by	 rev reason
 *	-------- --- --- -----------
 *	9/12/96	 VMD 1.0 original
 * ###################################################################
 */

#ifndef _cpxTutorial_
#define _cpxTutorial_

// Only necessary on MacOS
#include "cpptcl.h"
//@Section: Demonstration classes
//@Man: 
/** 
 * -------------------------------------------------------------------------
 *   
 * "A" --
 *  
 *  Class with:
 *   trivial constructor,
 *   a single member function,
 *   no data members.
 *   
 *  Notice how we've added a piece of
 *  help text with the triple comment '///'.  If we did (in Tcl)
 *  the following: 'A a ; a foo -help' we are returned that segment
 *  of help text.
 * -------------------------------------------------------------------------
 */
class A {
  public:
	A(void);
	~A(void);
	
	/// solves the world's problems
	void foo(void);
};

//@Section: Demonstration classes
//@Man: 
/** 
 * -------------------------------------------------------------------------
 *   
 * "B" --
 *  
 *  Class with:
 *   trivial constructor,
 *   a single member function,
 *   a data member.
 *   
 *  'b' is available in Tcl as a data member.
 * -------------------------------------------------------------------------
 */
class B {
  public:
	B(void);
	~B(void);
	
	float b;
	void foo(void);
};

//@Section: Demonstration classes
//@Man: 
/** 
 * -------------------------------------------------------------------------
 *   
 * "C" --
 *  
 *  Class with:
 *   trivial constructor,
 *   a variety of data members and member functions.
 *  
 *  This is a more complex class, with member functions which both return
 *  values and have arguments.  Cpptcl handles all of this automatically.
 *  It also lets us do things like this:
 *    tclsh
 *    % package require Demothree
 *    1.0
 *    % C c    # creates object of type 'C'
 *    c
 *    % c configure -c1 1.23 -c4 true -c2 -0.35 -c3 353
 *    353
 *    % c listMembers
 *    ...
 *  
 * -------------------------------------------------------------------------
 */
class C {
  public:
	C(void);
	~C(void);
	
	float c1;
	double c2;
	int c3;
	int c4;
	
	void foo1(void);
	long foo2(long a, long b);
	float foo3(void);
};

//@Section: Demonstration classes
//@Man: 
/** 
 * -------------------------------------------------------------------------
 *   
 * "D" --
 *  
 *  Class with:
 *   non-trivial constructor,
 *   data and function members.
 *   
 *  With a non-trivial constructor, the process of deriving argument values
 *  from Tcl requires that the object is indirectly derived.  So wrapped
 *  object 'D_tcl' contains a pointer to a 'D', and automatically initialises
 *  and destroys that pointer for us.  This is transparent to the user, but
 *  perhaps useful for those interested in implementation.
 * -------------------------------------------------------------------------
 */
class D {
  public:
	D(long d1, float d2);
	~D(void);
	
	int d3;
	bool foo(bool d);
};

#endif

