procedure LoadLigStruct(var FLigNew, FLigEnd : ptrLigRecord;
			 var RState : ReadState;
			 var IDent : string;
			 var NBuf : integer;
			 var Buf : BufRecord);
var FLigH : ptrLigRecord;
var s, sbuf : string;
var icn, ichar : byte;
begin
      FLigNew:=nil; FLigEnd:=nil;
  {--------- LIGTABLE --------------------}
      if NBuf > 0 then
      begin
           ErrorLog('*** Warning : LIGTABLE string parameter is ignored');
           LogReadState;
      end;

      if RState = OpenBrace then icn:=1
      else begin
           icn:=0;
           ErrorLog('*** Warning : LIGTABLE without list parameters');
           LogReadState;
      end;

      while (icn > 0) do
      begin
           RState:=NoCommRead(IDent,NBuf,Buf);
           FLigH:=nil;

           case RState of
           OpenBrace : begin
               icn:=icn+1;
               ErrorLog('*** Error : LIGTABLE cannot have list sub-parameters');
               ErrorLog('            Parameter '+IDent+' is ignored');
               LogReadState; FlagError:=true;
           end;
           CloseBrace : begin
               if icn = 1 then
               begin
                    if IDent = 'LABEL' then
                    begin
                        New(FLigH);
                        with FLigH^ do
                        begin
                           TTLig:=TLabel;
                           s:=PackBuf(NBuf,Buf);
                           s:=UpCaseString(s);
                           if (s = 'BOUNDARYCHAR') or (s = 'BCHAR')
                              then TTLig:=TLabelBoundary
                              else begin
                                   sbuf:=PackBuf(NBuf,Buf);
                                   LigChar:=ConvFromByte(sbuf,true);
                              end;
                        end;
                    end
                    else if IDent = 'STOP' then
                    begin
                        New(FLigH);
                        with FLigH^ do
                        begin
                           TTLig:=TStop;
                        end;
                        if NBuf > 0 then
                        begin
                             ErrorLog('*** Warning : Rest of operator LIGTABLE/STOP is ignored :');
                             LogReadState;
                        end;
                    end
                    else if IDent = 'SKIP' then
                    begin
                        New(FLigH);
                        with FLigH^ do
                        begin
                           TTLig:=TSkip;
                           sbuf:=PackBuf(NBuf,Buf);
                           SKipNum:=ConvFromByte(sbuf,true);
                        end;
                    end
                    else if IDent = 'KRN' then
                    begin
                        s:=DelSpaces(PackBuf(NBuf,Buf));
                        New(FLigH);
                        with FLigH^ do
                        begin
                           TTLig:=TKern;
                           KernChar:=ConvFromByte(s,false);
                           KernValue:=ConvFromReal(s,true);
                           DummyChar:=0;
                        end;
                    end
                    else begin
                         if IDent = 'LIG'          then ichar:=1
                         else if IDent = '/LIG'    then ichar:=2
                         else if IDent = '/LIG>'   then ichar:=3
                         else if IDent = 'LIG/'    then ichar:=4
                         else if IDent = 'LIG/>'   then ichar:=5
                         else if IDent = '/LIG/'   then ichar:=6
                         else if IDent = '/LIG/>'  then ichar:=7
                         else if IDent = '/LIG/>>' then ichar:=8
                         else ichar:=0;

                         if ichar = 0 then
                         begin
                            ErrorLog('*** Error : Unknown LIGTABLE sub-operator is ignored :'+Ident);
                            LogReadState; FlagError:=true;
                         end
                         else begin
                            new(FLigH);
                            s:=DelSpaces(PackBuf(NBuf,Buf));
                            with FLigH^ do
                            begin
                                 case ichar of
                                 1 : TTLig:=TLig;
                                 2 : TTLig:=TSLig;
                                 3 : TTLig:=TSLigH;
                                 4 : TTLig:=TLigS;
                                 5 : TTLig:=TLigSH;
                                 6 : TTLig:=TSLigS;
                                 7 : TTLig:=TSLigSH;
                                 8 : TTLig:=TSLigSHH;
                                 else begin
                                      TTLig:=TLigType(ichar+4);
                                      ErrorLog('*** Internal Error : TLig = '+ConvInt(ichar+4));
                                      LogReadState;
                                 end;
                                 end; {case}
                                 NextChar:=ConvFromByte(s,false);
                                 InsChar:=ConvFromByte(s,true);
                            end;
                         end;
                    end;
               end;
           end;
           CloseLex   : begin
               icn:=icn-1;
           end;
           EndFile    : begin
               ErrorLog('*** Error : Unfinished operator (end-of-file)');
               icn:=0; FlagError:=true;
           end;
           end; {case}

           if FLigH <> nil then
           begin
              FLigH^.ptrNext:=nil;
              FLigH^.marked:=LigNotUsed;
              if FLigNew = nil then
              begin
                   FLigNew:=FLigH; FLigEnd:=FLigH;
              end
              else begin
                   FLigEnd^.ptrNext:=FLigH;
                   FLigEnd:=FLigH;
              end;
           end;

      end; {while}

end; {LoadLigStruct}


procedure LoadFDimStruct(flheader : boolean;
                         var FDim   : FontDimenRec;
			 var HFlags : FontHeadFlags;
			 var RState : ReadState;
			 var IDent : string;
			 var NBuf : integer;
			 var Buf : BufRecord);
var icn    : integer;
    sbuf   : string;
    res    : float;
begin
      if NBuf > 0 then
      begin
	   ErrorLog('*** Error : FONTDIMEN with string parameter');
	   LogReadState; FlagError:=true;
      end;

      if RState = OpenBrace then icn:=1
      else begin
	   icn:=0;
	   ErrorLog('*** Warning : FONTDIMEN without list parameters');
	   LogReadState;
      end;

      while (icn > 0) do
      begin
	   RState:=NoCommRead(IDent,NBuf,Buf);
	   case RState of
	   OpenBrace : begin
		icn:=icn+1;
		ErrorLog('*** Error : FONTDIMEN cannot have list parameters');
		ErrorLog('            with sub-lists. Parameter '+IDent+' is ignored');
		LogReadState; FlagError:=true;
	   end;
	   CloseBrace : begin
	      if icn = 1 then
	      begin
                   if RState <> CloseBrace
			  then FileFix11('FONTDIMEN/'+IDent);
                   sbuf:=PackBuf(NBuf,Buf);
                   res:=ConvFromReal(sbuf,true);
		   if IDent = 'SLANT' then
		   begin
                       if (not flheader) or (not HFlagsGlb.FlSlant) then
                       begin
		            FDim.Slant:=res; HFlags.FlSlant:=true;
                       end;
		   end
		   else if IDent = 'SPACE' then
		   begin
                       if (not flheader) or (not HFlagsGlb.FlSpace) then
                       begin
		            FDim.Space:=res; HFlags.FlSpace:=true;
                       end;
		   end
		   else if IDent = 'STRETCH' then
		   begin
                       if (not flheader) or (not HFlagsGlb.FlStretch) then
                       begin
		            FDim.Stretch:=res; HFlags.FlStretch:=true;
                       end;
		   end
		   else if IDent = 'SHRINK' then
		   begin
                       if (not flheader) or (not HFlagsGlb.FlShrink) then
                       begin
		            FDim.Shrink:=res; HFlags.FlShrink:=true;
                       end;
		   end
		   else if IDent = 'XHEIGHT' then
		   begin
                       if (not flheader) or (not HFlagsGlb.FlXHeight) then
                       begin
		            FDim.XHeight:=res; HFlags.FlXHeight:=true;
                       end;
		   end
		   else if IDent = 'QUAD' then
		   begin
                       if (not flheader) or (not HFlagsGlb.FlQuad) then
                       begin
		            FDim.Quad:=res; HFlags.FlQuad:=true;
                       end;
		   end
		   else if IDent = 'EXTRASPACE' then
		   begin
                       if (not flheader) or (not HFlagsGlb.FlExtraSpace) then
                       begin
		            FDim.ExtraSpace:=res; HFlags.FlExtraSpace:=true;
                       end;
		   end
		   else if (IDent = 'NUM1')
			    or (IDent = 'DEFAULTRULETHICKNESS')
		   then begin
                       if (not flheader) or (not HFlagsGlb.FlNum1) then
                       begin
		            FDim.Num1:=res; HFlags.FlNum1:=true;
                       end;
		   end
		   else if (IDent = 'NUM2')
			   or (IDent = 'BIGOPSPACING1')
		   then begin
                       if (not flheader) or (not HFlagsGlb.FlNum2) then
                       begin
		            FDim.Num2:=res; HFlags.FlNum2:=true;
                       end;
		   end
		   else if (IDent = 'NUM3')
			   or (IDent = 'BIGOPSPACING2')
		   then begin
                       if (not flheader) or (not HFlagsGlb.FlNum3) then
                       begin
		            FDim.Num3:=res; HFlags.FlNum3:=true;
                       end;
		   end
		   else if (IDent = 'DENOM1')
			   or (IDent = 'BIGOPSPACING3')
		   then begin
                       if (not flheader) or (not HFlagsGlb.FlDenom1) then
                       begin
		            FDim.Denom1:=res; HFlags.FlDenom1:=true;
                       end;
		   end
		   else if (IDent = 'DENOM2')
			   or (IDent = 'BIGOPSPACING4')
		   then begin
                       if (not flheader) or (not HFlagsGlb.FlDenom2) then
                       begin
		            FDim.Denom2:=res; HFlags.FlDenom2:=true;
                       end;
		   end
		   else if (IDent = 'SUP1')
			   or (IDent = 'BIGOPSPACING5')
		   then begin
                       if (not flheader) or (not HFlagsGlb.FlSup1) then
                       begin
		            FDim.Sup1:=res; HFlags.FlSup1:=true;
                       end;
		   end
		   else if IDent = 'SUP2' then
		   begin
                       if (not flheader) or (not HFlagsGlb.FlSup2) then
                       begin
		            FDim.Sup2:=res; HFlags.FlSup2:=true;
                       end;
		   end
		   else if IDent = 'SUP3' then
		   begin
                       if (not flheader) or (not HFlagsGlb.FlSup3) then
                       begin
		            FDim.Sup3:=res; HFlags.FlSup3:=true;
                       end;
		   end
		   else if IDent = 'SUB1' then
		   begin
                       if (not flheader) or (not HFlagsGlb.FlSub1) then
                       begin
		            FDim.Sub1:=res; HFlags.FlSub1:=true;
                       end;
		   end
		   else if IDent = 'SUB2' then
		   begin
                       if (not flheader) or (not HFlagsGlb.FlSub2) then
                       begin
		            FDim.Sub2:=res; HFlags.FlSub2:=true;
                       end;
		   end
		   else if IDent = 'SUPDROP' then
		   begin
                       if (not flheader) or (not HFlagsGlb.FlSupDrop) then
                       begin
		            FDim.SupDrop:=res; HFlags.FlSupDrop:=true;
                       end;
		   end
		   else if IDent = 'SUBDROP' then
		   begin
                       if (not flheader) or (not HFlagsGlb.FlSubDrop) then
                       begin
		            FDim.SubDrop:=res; HFlags.FlSubDrop:=true;
                       end;
		   end
		   else if IDent = 'DELIM1' then
		   begin
                       if (not flheader) or (not HFlagsGlb.FlDelim1) then
                       begin
		            FDim.Delim1:=res; HFlags.FlDelim1:=true;
                       end;
		   end
		   else if IDent = 'DELIM2' then
		   begin
                       if (not flheader) or (not HFlagsGlb.FlDelim2) then
                       begin
		            FDim.Delim2:=res; HFlags.FlDelim2:=true;
                       end;
		   end
		   else if IDent = 'AXISHEIGHT' then
		   begin
                       if (not flheader) or (not HFlagsGlb.FlAxisHeight) then
                       begin
		            FDim.AxisHeight:=res; HFlags.FlAxisHeight:=true;
                       end;
		   end
		   else if IDent = 'PARAMETER' then
		   begin
		       ErrorLog('*** Warning : FONTDIMEN/PARAMETER is ignored');
                       LogReadState;
		   end
		   else begin
			ErrorLog('*** Error : Unknown FONTDIMEN sub-operator is ignored :'+Ident);
			LogReadState; FlagError:=true;
		   end;
	      end;
	  end;
	  CloseLex   : begin
	      icn:=icn-1;
	  end;
	  EndFile    : begin
	      ErrorLog('*** Error : Unfinished operator (end-of-file)');
	      icn:=0; FlagError:=true;
	  end;
	  end; {case}
     end; {while}
end; {LoadFDimStruct}


procedure LoadHeadFile(ss : string;
		       var FParam : FontParamRec;
		       var FDim   : FontDimenRec;
		       var HFlags : FontHeadFlags);
var i        : integer;
    res      : float;
var sh, sbuf : string;
var NBuf     : integer;
    Buf      : BufRecord;
    Ident    : string;
    RState   : ReadState;
    icn      : integer;
    ichar    : byte;
    fl	     : boolean;

begin

    sh:=FindFileLoc(ss,'.PL');
    if sh = '' then
    begin
	 ErrorLog('*** Unable to open file : '+ss);
	 FlagError:=true; FlagSevere:=true;
	 exit;
    end
    else begin
	 ErrorLog('File '+sh+' is used to load HEADER data');
    end;

    StartRead(sh);

    while not EndOfRead do
    begin
	 RState:=NoCommRead(IDent,NBuf,Buf);
	 case RState of
	 OpenBrace,
	 CloseBrace : begin

	    if IDent = 'CHECKSUM' then
	    begin
	    {--------- CHECKSUM --------------------}
		 if RState <> CloseBrace then FileFix11(IDent);
                 (*
                 sbuf:=PackBuf(NBuf,Buf);
		 FParam.FontCheckSum:=ConvFromLongInt(sbuf,true);
		 HFlags.FlFontCheckSum:=true;
                 *)
	    {--------- end CHECKSUM --------------------}
	    end
	    else if IDent = 'DESIGNSIZE' then
	    begin
	    {--------- DESIGNSIZE --------------------}
		 if RState <> CloseBrace then FileFix11(IDent);
                 sbuf:=PackBuf(NBuf,Buf);
		 res:=ConvFromReal(sbuf,true);
                 if res <= 0.0 then
                 begin
                      ErrorLog('*** Error : DESIGNSIZE <= 0.0');
                      LogReadState;
                      FlagError:=true;
                 end
                 else if not HFlagsGlb.FlFontDesignSize then
                 begin
		      FParam.FontDesignSize:=res;
                      HFlags.FlFontDesignSize:=true;
                 end;
	    {--------- end DESIGNSIZE --------------------}
	    end
	    else if IDent = 'DESIGNUNITS' then
	    begin
	    {--------- DESIGNUNITS --------------------}
		 if RState <> CloseBrace then FileFix11(IDent);
                 sbuf:=PackBuf(NBuf,Buf);
		 res:=ConvFromReal(sbuf,true);
                 if res <= 0.0 then
                 begin
                      ErrorLog('*** Error : DESIGNUNITS <= 0.0');
                      LogReadState;
                      FlagError:=true;
                 end
                 else if not HFlagsGlb.FlFontDesignUnits then
                 begin
                      FParam.FontDesignUnits:=res;
                      HFlags.FlFontDesignUnits:=true;
                 end;
	    {--------- end DESIGNUNITS --------------------}
	    end
	    else if IDent = 'CODINGSCHEME' then
	    begin
	    {--------- CODINGSCHEME --------------------}
		 if RState <> CloseBrace then FileFix11(IDent);
                 if not HFlagsGlb.FlFontCoding then
                 begin
		      FParam.FontCoding:=DelSpaces(PackBuf(NBuf,Buf));
		      HFlags.FlFontCoding:=true;
                 end;
	    {--------- end CODINGSCHEME --------------------}
	    end
	    else if IDent = 'FAMILY' then
	    begin
	    {--------- FAMILY --------------------}
		 if RState <> CloseBrace then FileFix11(IDent);
                 if not HFlagsGlb.FlFontFamily then
                 begin
			 FParam.FontFamily:=DelSpaces(PackBuf(NBuf,Buf));
		         HFlags.FlFontFamily:=true;
                 end;
	    {--------- end FAMILY --------------------}
	    end
	    else if IDent = 'FACE' then
	    begin
	    {--------- FACE --------------------}
		 if RState <> CloseBrace then FileFix11(IDent);
                 sbuf:=PackBuf(NBuf,Buf);
                 if not HFlagsGlb.FlFontFace then
                 begin
	                 FParam.FontFace:=ConvFromByte(sbuf,true);
		         HFlags.FlFontFace:=true;
                 end;
	    {--------- end FACE --------------------}
	    end
	    else if IDent = 'SEVENBITSAFEFLAG' then
	    begin
	    {--------- SEVENBITSAFEFLAG --------------------}
		 if RState <> CloseBrace then FileFix11(IDent);
		 ErrorLog('*** Warning : SEVENBITSAFEFLAG is ignored');
		 LogReadState;
	    {--------- end SEVENBITSAFEFLAG --------------------}
	    end
	    else if IDent = 'HEADER' then
	    begin
	    {--------- HEADER --------------------}
		 if RState <> CloseBrace then FileFix11(IDent);
		 ErrorLog('*** Warning : HEADER is ignored');
                 LogReadState;
	    {--------- end HEADER --------------------}
	    end
	    else if IDent = 'FONTDIMEN' then
	    begin
	    {--------- FONTDIMEN --------------------}
                 LoadFDimStruct(true, FDim, HFlags,
			 RState, IDent, NBuf, Buf);
                 FlFontDimen:=true;
	    {--------- end FONTDIMEN --------------------}
	    end
	    else begin
	    {--------- COMMENT ? --------------------}
		if (IDent <> 'BOUNDARYCHAR') and
		   (IDent <> 'BCHAR') and
		   (IDent <> 'LIGTABLE') and
		   (IDent <> 'CHARACTER') and
		   (IDent <> 'CHAR') and
		   (IDent <> 'COMMENT')
		then begin
		     ErrorLog('*** Error : Unknown operator is ignored :'+Ident);
		     LogReadState; FlagError:=true;
		end;

                SkipOp(RState,Buf);

	    {--------- end COMMENT ? --------------------}
	    end;

	 end;
	 CloseLex : begin
	    ErrorLog('*** Error : Illegal ")" is ignored');
	    LogReadState; FlagError:=true;
	 end;
	 EndFile : begin
	    if (Ident <> '') or (NBuf > 0) then
	    begin
		 ErrorLog('*** Error : Unfinished operator (end-of-file)');
		 FlagError:=true;
	    end;
	 end;
	 end; {case}
    end; {while}

end; {LoadHeadFile}

