/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.gc.replication;

import com.google.protobuf.InvalidProtocolBufferException;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Scope;
import java.time.Duration;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.replication.ReplicationTable;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.log.WalStateManager;
import org.apache.accumulo.server.replication.StatusUtil;
import org.apache.accumulo.server.replication.proto.Replication;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class CloseWriteAheadLogReferences
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(CloseWriteAheadLogReferences.class);
    private static final String RFILE_SUFFIX = ".rf";
    private final ServerContext context;

    public CloseWriteAheadLogReferences(ServerContext context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Duration duration;
        long startTime;
        if (!ReplicationTable.isOnline((AccumuloClient)this.context)) {
            log.debug("Replication table isn't online, not attempting to clean up wals");
            return;
        }
        HashSet<String> closed = null;
        Span span = TraceUtil.startSpan(this.getClass(), (String)"findReferencedWals");
        try (Scope findWalsSpan = span.makeCurrent();){
            startTime = System.nanoTime();
            closed = this.getClosedLogs();
            duration = Duration.ofNanos(System.nanoTime() - startTime);
        }
        finally {
            span.end();
        }
        log.info("Found {} WALs referenced in metadata in {}", (Object)closed.size(), (Object)duration);
        long recordsClosed = 0L;
        Span updateReplicationSpan = TraceUtil.startSpan(this.getClass(), (String)"updateReplicationTable");
        try (Scope updateReplicationScope = updateReplicationSpan.makeCurrent();){
            startTime = System.nanoTime();
            recordsClosed = this.updateReplicationEntries((AccumuloClient)this.context, closed);
            duration = Duration.ofNanos(System.nanoTime() - startTime);
        }
        finally {
            updateReplicationSpan.end();
        }
        log.info("Closed {} WAL replication references in replication table in {}", (Object)recordsClosed, (Object)duration);
    }

    protected HashSet<String> getClosedLogs() {
        WalStateManager wals = new WalStateManager(this.context);
        HashSet<String> result = new HashSet<String>();
        try {
            for (Map.Entry entry : wals.getAllState().entrySet()) {
                if (entry.getValue() != WalStateManager.WalState.UNREFERENCED && entry.getValue() != WalStateManager.WalState.CLOSED) continue;
                Path path = (Path)entry.getKey();
                log.debug("Found closed WAL " + String.valueOf(path));
                result.add(path.toString());
            }
        }
        catch (WalStateManager.WalMarkerException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    protected long updateReplicationEntries(AccumuloClient client, Set<String> closedWals) {
        long recordsClosed = 0L;
        try (BatchWriter bw = client.createBatchWriter(MetadataTable.NAME);
             BatchScanner bs = client.createBatchScanner(MetadataTable.NAME, Authorizations.EMPTY, 4);){
            bs.setRanges(Collections.singleton(Range.prefix((CharSequence)MetadataSchema.ReplicationSection.getRowPrefix())));
            bs.fetchColumnFamily(MetadataSchema.ReplicationSection.COLF);
            Text replFileText = new Text();
            for (Map.Entry entry : bs) {
                Replication.Status status;
                try {
                    status = Replication.Status.parseFrom((byte[])((Value)entry.getValue()).get());
                }
                catch (InvalidProtocolBufferException e) {
                    log.error("Could not parse Status protobuf for {}", entry.getKey(), (Object)e);
                    continue;
                }
                MetadataSchema.ReplicationSection.getFile((Key)((Key)entry.getKey()), (Text)replFileText);
                String replFile = replFileText.toString();
                boolean isClosed = closedWals.contains(replFile);
                if (status.getClosed() || replFile.endsWith(RFILE_SUFFIX) || !isClosed) continue;
                try {
                    this.closeWal(bw, (Key)entry.getKey());
                    ++recordsClosed;
                }
                catch (MutationsRejectedException e) {
                    log.error("Failed to submit delete mutation for {}", entry.getKey());
                }
            }
        }
        catch (TableNotFoundException e) {
            log.error("Replication table was deleted", (Throwable)e);
        }
        catch (MutationsRejectedException e) {
            log.error("Failed to write delete mutations for replication table", (Throwable)e);
        }
        return recordsClosed;
    }

    protected void closeWal(BatchWriter bw, Key k) throws MutationsRejectedException {
        log.debug("Closing unreferenced WAL ({}) in metadata table", (Object)k.toStringNoTruncate());
        Mutation m = new Mutation(k.getRow());
        m.put(k.getColumnFamily(), k.getColumnQualifier(), StatusUtil.fileClosedValue());
        bw.addMutation(m);
    }
}

