/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.manager.tableOps.tableImport;

import org.apache.accumulo.core.fate.Repo;
import org.apache.accumulo.core.manager.state.tables.TableState;
import org.apache.accumulo.manager.Manager;
import org.apache.accumulo.manager.tableOps.ManagerRepo;
import org.apache.accumulo.manager.tableOps.Utils;
import org.apache.accumulo.manager.tableOps.tableImport.ImportedTableInfo;
import org.apache.hadoop.fs.Path;
import org.slf4j.LoggerFactory;

class FinishImportTable
extends ManagerRepo {
    private static final long serialVersionUID = 1L;
    private ImportedTableInfo tableInfo;

    public FinishImportTable(ImportedTableInfo ti) {
        this.tableInfo = ti;
    }

    @Override
    public long isReady(long tid, Manager environment) {
        return 0L;
    }

    @Override
    public Repo<Manager> call(long tid, Manager env) throws Exception {
        if (!this.tableInfo.keepMappings) {
            for (ImportedTableInfo.DirectoryMapping dm : this.tableInfo.directories) {
                env.getVolumeManager().deleteRecursively(new Path(dm.importDir, "mappings.txt"));
            }
        }
        if (this.tableInfo.onlineTable) {
            env.getTableManager().transitionTableState(this.tableInfo.tableId, TableState.ONLINE);
        }
        Utils.unreserveNamespace(env, this.tableInfo.namespaceId, tid, false);
        Utils.unreserveTable(env, this.tableInfo.tableId, tid, true);
        for (ImportedTableInfo.DirectoryMapping dm : this.tableInfo.directories) {
            Utils.unreserveHdfsDirectory(env, new Path(dm.exportDir).toString(), tid);
        }
        env.getEventCoordinator().event("Imported table %s ", this.tableInfo.tableName);
        LoggerFactory.getLogger(FinishImportTable.class).debug("Imported table " + this.tableInfo.tableId + " " + this.tableInfo.tableName);
        return null;
    }

    @Override
    public String getReturn() {
        return this.tableInfo.tableId.canonical();
    }

    @Override
    public void undo(long tid, Manager env) {
    }
}

