/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.cli;

import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.converters.IParameterSplitter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import org.apache.accumulo.core.cli.ConfigOpts;
import org.apache.accumulo.core.cli.Help;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.clientImpl.ClientInfoImpl;
import org.apache.accumulo.core.conf.ClientProperty;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.ColumnVisibility;

public class ClientOpts
extends Help {
    private String legacyClientOpts = "-p -tc --tokenClass -i --instance --site-file --keytab --debug -fake --mock --ssl --sasl";
    @Parameter(names={"-p", "-tc", "--tokenClass", "-i", "--instance", "--site-file", "--keytab"}, hidden=true)
    private String legacyOpts = null;
    @Parameter(names={"--debug", "-fake", "--mock", "--ssl", "--sasl"}, hidden=true)
    private boolean legacyOptsBoolean = false;
    @Parameter(names={"-u", "--user"}, description="Connection user")
    public String principal = null;
    @Parameter(names={"--password"}, converter=PasswordConverter.class, description="connection password (can be specified as '<password>', 'pass:<password>', 'file:<local file containing the password>' or 'env:<variable containing the pass>')", password=true)
    private String securePassword = null;
    @Parameter(names={"-auths", "--auths"}, converter=AuthConverter.class, description="the authorizations to use when reading or writing")
    public Authorizations auths = Authorizations.EMPTY;
    @Parameter(names={"-c", "--config-file"}, description="Read the given client config file. If omitted, the classpath will be searched for file named accumulo-client.properties")
    private String clientConfigFile = null;
    @Parameter(names={"-o"}, splitter=NullSplitter.class, description="Overrides property in accumulo-client.properties. Expected format: -o <key>=<value>")
    private List<String> overrides = new ArrayList<String>();
    @Parameter(names={"--trace"}, description="turn on distributed tracing")
    public boolean trace = false;
    private Properties cachedProps = null;

    public AuthenticationToken getToken() {
        return ClientProperty.getAuthenticationToken(this.getClientProps());
    }

    public Map<String, String> getOverrides() {
        return ConfigOpts.getOverrides(this.overrides);
    }

    @Override
    public void parseArgs(String programName, String[] args, Object ... others) {
        super.parseArgs(programName, args, others);
        if (this.legacyOpts != null || this.legacyOptsBoolean) {
            StringBuilder badOptions = new StringBuilder();
            for (String arg : args) {
                if (!this.legacyClientOpts.contains(arg)) continue;
                badOptions.append(arg).append(" ");
            }
            throw new IllegalArgumentException("The Client options: " + badOptions + "have been dropped. Use accumulo-client.properties for any connection or token options. See '-c, --config-file' option.");
        }
    }

    public String getClientConfigFile() {
        URL clientPropsUrl;
        if (this.clientConfigFile == null && (clientPropsUrl = ClientOpts.class.getClassLoader().getResource("accumulo-client.properties")) != null) {
            this.clientConfigFile = clientPropsUrl.getFile();
        }
        return this.clientConfigFile;
    }

    public Properties getClientProps() {
        if (this.cachedProps == null) {
            this.cachedProps = new Properties();
            if (this.getClientConfigFile() != null) {
                this.cachedProps = ClientInfoImpl.toProperties(this.getClientConfigFile());
            }
            if (this.principal != null) {
                this.cachedProps.setProperty(ClientProperty.AUTH_PRINCIPAL.getKey(), this.principal);
            }
            if (this.securePassword != null) {
                ClientProperty.setPassword(this.cachedProps, this.securePassword.toString());
            }
            this.getOverrides().forEach((k, v) -> this.cachedProps.put(k, v));
            ClientProperty.validate(this.cachedProps);
        }
        return this.cachedProps;
    }

    public static class PasswordConverter
    implements IStringConverter<String> {
        public static final String STDIN = "stdin";

        public String convert(String value) {
            for (KeyType keyType : KeyType.values()) {
                if (!keyType.matches(value)) continue;
                return keyType.convert(value);
            }
            return value;
        }

        private static enum KeyType {
            PASS("pass:"),
            ENV("env:"){

                @Override
                String process(String value) {
                    return System.getenv(value);
                }
            }
            ,
            FILE("file:"){

                @Override
                @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="app is run in same security context as user providing the filename")
                String process(String value) {
                    Scanner scanner = new Scanner(new File(value), StandardCharsets.UTF_8);
                    try {
                        String string = scanner.nextLine();
                        scanner.close();
                        return string;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                scanner.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw new ParameterException((Throwable)e);
                        }
                    }
                }
            }
            ,
            STDIN("stdin"){

                @Override
                public boolean matches(String value) {
                    return this.prefix.equals(value);
                }

                @Override
                public String convert(String value) {
                    return this.prefix;
                }
            };

            String prefix;

            private KeyType(String prefix) {
                this.prefix = prefix;
            }

            public boolean matches(String value) {
                return value.startsWith(this.prefix);
            }

            public String convert(String value) {
                return this.process(value.substring(this.prefix.length()));
            }

            String process(String value) {
                return value;
            }
        }
    }

    public static class NullSplitter
    implements IParameterSplitter {
        public List<String> split(String value) {
            return Collections.singletonList(value);
        }
    }

    public static class VisibilityConverter
    implements IStringConverter<ColumnVisibility> {
        public ColumnVisibility convert(String value) {
            return new ColumnVisibility(value);
        }
    }

    public static class AuthConverter
    implements IStringConverter<Authorizations> {
        public Authorizations convert(String value) {
            return new Authorizations(value.split(","));
        }
    }
}

