/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.clientImpl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.TabletLocator;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.hadoop.io.Text;

public class SyncingTabletLocator
extends TabletLocator {
    private volatile TabletLocator locator;
    private final Supplier<TabletLocator> getLocatorFunction;

    public SyncingTabletLocator(Supplier<TabletLocator> getLocatorFunction) {
        this.getLocatorFunction = getLocatorFunction;
        this.locator = getLocatorFunction.get();
    }

    public SyncingTabletLocator(ClientContext context, TableId tableId) {
        this(() -> TabletLocator.getLocator(context, tableId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TabletLocator syncLocator() {
        TabletLocator loc = this.locator;
        if (!loc.isValid()) {
            SyncingTabletLocator syncingTabletLocator = this;
            synchronized (syncingTabletLocator) {
                if (this.locator == loc) {
                    loc = this.locator = this.getLocatorFunction.get();
                }
            }
        }
        return loc;
    }

    @Override
    public TabletLocator.TabletLocation locateTablet(ClientContext context, Text row, boolean skipRow, boolean retry) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        return this.syncLocator().locateTablet(context, row, skipRow, retry);
    }

    @Override
    public <T extends Mutation> void binMutations(ClientContext context, List<T> mutations, Map<String, TabletLocator.TabletServerMutations<T>> binnedMutations, List<T> failures) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        this.syncLocator().binMutations(context, mutations, binnedMutations, failures);
    }

    @Override
    public List<Range> binRanges(ClientContext context, List<Range> ranges, Map<String, Map<KeyExtent, List<Range>>> binnedRanges) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        return this.syncLocator().binRanges(context, ranges, binnedRanges);
    }

    @Override
    public void invalidateCache(KeyExtent failedExtent) {
        this.syncLocator().invalidateCache(failedExtent);
    }

    @Override
    public void invalidateCache(Collection<KeyExtent> keySet) {
        this.syncLocator().invalidateCache(keySet);
    }

    @Override
    public void invalidateCache() {
        this.syncLocator().invalidateCache();
    }

    @Override
    public void invalidateCache(ClientContext context, String server) {
        this.syncLocator().invalidateCache(context, server);
    }
}

