/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.file;

import java.util.stream.Stream;

public enum FilePrefix {
    BULK_IMPORT("I"),
    MINOR_COMPACTION("F"),
    MAJOR_COMPACTION("C"),
    MAJOR_COMPACTION_ALL_FILES("A");

    String prefix;

    private FilePrefix(String prefix) {
        this.prefix = prefix;
    }

    public static FilePrefix fromPrefix(String prefix) {
        return Stream.of(FilePrefix.values()).filter(p -> p.prefix.equals(prefix)).findAny().orElseThrow(() -> new IllegalArgumentException("Unknown prefix type: " + prefix));
    }

    public String toPrefix() {
        return this.prefix;
    }
}

