/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.file.rfile;

import com.beust.jcommander.IParameterValidator;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.google.auto.service.AutoService;
import java.util.ArrayList;
import java.util.List;
import org.apache.accumulo.core.cli.Help;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.file.FileSKVWriter;
import org.apache.accumulo.core.file.rfile.RFileOperations;
import org.apache.accumulo.core.file.rfile.bcfile.Compression;
import org.apache.accumulo.core.metadata.UnreferencedTabletFile;
import org.apache.accumulo.core.spi.crypto.NoCryptoServiceFactory;
import org.apache.accumulo.core.spi.file.rfile.compression.NoCompression;
import org.apache.accumulo.start.spi.KeywordExecutable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={KeywordExecutable.class})
public class CreateEmpty
implements KeywordExecutable {
    private static final Logger log = LoggerFactory.getLogger(CreateEmpty.class);

    public static void main(String[] args) throws Exception {
        new CreateEmpty().execute(args);
    }

    public String keyword() {
        return "create-empty";
    }

    public String description() {
        return "Creates an empty rfile";
    }

    public void execute(String[] args) throws Exception {
        Configuration conf = new Configuration();
        Opts opts = new Opts();
        opts.parseArgs("accumulo create-empty", args, new Object[0]);
        for (String arg : opts.files) {
            UnreferencedTabletFile file = UnreferencedTabletFile.of(conf, new Path(arg));
            log.info("Writing to file '{}'", (Object)file);
            FileSKVWriter writer = new RFileOperations().newWriterBuilder().forFile(file, file.getPath().getFileSystem(conf), conf, NoCryptoServiceFactory.NONE).withTableConfiguration(DefaultConfiguration.getInstance()).withCompression(opts.codec).build();
            writer.close();
        }
    }

    static class Opts
    extends Help {
        @Parameter(names={"-c", "--codec"}, description="the compression codec to use.", validateWith={IsSupportedCompressionAlgorithm.class})
        String codec = new NoCompression().getName();
        @Parameter(description=" <path> { <path> ... } Each path given is a URL. Relative paths are resolved according to the default filesystem defined in your Hadoop configuration, which is usually an HDFS instance.", required=true, validateWith={NamedLikeRFile.class})
        List<String> files = new ArrayList<String>();

        Opts() {
        }
    }

    public static class IsSupportedCompressionAlgorithm
    implements IParameterValidator {
        public void validate(String name, String value) throws ParameterException {
            List<String> algorithms = Compression.getSupportedAlgorithms();
            if (!algorithms.contains(value)) {
                throw new ParameterException("Compression codec must be one of " + algorithms);
            }
        }
    }

    public static class NamedLikeRFile
    implements IParameterValidator {
        public void validate(String name, String value) throws ParameterException {
            if (!value.endsWith(".rf")) {
                throw new ParameterException("File must end with .rf and '" + value + "' does not.");
            }
        }
    }
}

