/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iteratorsImpl.system;

import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.ServerWrappingIterator;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;

public class StatsIterator
extends ServerWrappingIterator {
    private int numRead = 0;
    private AtomicLong seekCounter;
    private AtomicLong scanCounter;
    private LongAdder serverScanCounter;

    public StatsIterator(SortedKeyValueIterator<Key, Value> source, AtomicLong seekCounter, AtomicLong tabletScanCounter, LongAdder serverScanCounter) {
        super(source);
        this.seekCounter = seekCounter;
        this.scanCounter = tabletScanCounter;
        this.serverScanCounter = serverScanCounter;
    }

    @Override
    public void next() throws IOException {
        this.source.next();
        ++this.numRead;
        if (this.numRead % 23 == 0) {
            this.scanCounter.addAndGet(this.numRead);
            this.serverScanCounter.add(this.numRead);
            this.numRead = 0;
        }
    }

    @Override
    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        return new StatsIterator(this.source.deepCopy(env), this.seekCounter, this.scanCounter, this.serverScanCounter);
    }

    @Override
    public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
        this.source.seek(range, columnFamilies, inclusive);
        this.seekCounter.incrementAndGet();
        this.scanCounter.addAndGet(this.numRead);
        this.serverScanCounter.add(this.numRead);
        this.numRead = 0;
    }

    public void report() {
        this.scanCounter.addAndGet(this.numRead);
        this.serverScanCounter.add(this.numRead);
        this.numRead = 0;
    }
}

