/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.manager.balancer;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.accumulo.core.data.TabletId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.dataImpl.TabletIdImpl;
import org.apache.accumulo.core.manager.balancer.TServerStatusImpl;
import org.apache.accumulo.core.manager.balancer.TabletServerIdImpl;
import org.apache.accumulo.core.manager.thrift.TabletServerStatus;
import org.apache.accumulo.core.metadata.TServerInstance;
import org.apache.accumulo.core.spi.balancer.TabletBalancer;
import org.apache.accumulo.core.spi.balancer.data.TServerStatus;
import org.apache.accumulo.core.spi.balancer.data.TabletServerId;

public class AssignmentParamsImpl
implements TabletBalancer.AssignmentParameters {
    private final SortedMap<TabletServerId, TServerStatus> currentStatus;
    private final Map<TabletId, TabletServerId> unassigned;
    private final Map<TabletId, TabletServerId> assignmentsOut;
    private final SortedMap<TServerInstance, TabletServerStatus> thriftCurrentStatus;
    private final Map<KeyExtent, TServerInstance> thriftUnassigned;
    private final Map<KeyExtent, TServerInstance> thriftAssignmentsOut;

    public static AssignmentParamsImpl fromThrift(SortedMap<TServerInstance, TabletServerStatus> currentStatus, Map<KeyExtent, TServerInstance> unassigned, Map<KeyExtent, TServerInstance> assignmentsOut) {
        TreeMap currentStatusNew = new TreeMap();
        currentStatus.forEach((tsi, status) -> currentStatusNew.put(new TabletServerIdImpl((TServerInstance)tsi), TServerStatusImpl.fromThrift(status)));
        HashMap unassignedNew = new HashMap();
        unassigned.forEach((ke, tsi) -> unassignedNew.put(new TabletIdImpl((KeyExtent)ke), TabletServerIdImpl.fromThrift(tsi)));
        return new AssignmentParamsImpl(Collections.unmodifiableSortedMap(currentStatusNew), Collections.unmodifiableMap(unassignedNew), currentStatus, unassigned, assignmentsOut);
    }

    public AssignmentParamsImpl(SortedMap<TabletServerId, TServerStatus> currentStatus, Map<TabletId, TabletServerId> unassigned, Map<TabletId, TabletServerId> assignmentsOut) {
        this.currentStatus = currentStatus;
        this.unassigned = unassigned;
        this.assignmentsOut = assignmentsOut;
        this.thriftCurrentStatus = null;
        this.thriftUnassigned = null;
        this.thriftAssignmentsOut = null;
    }

    private AssignmentParamsImpl(SortedMap<TabletServerId, TServerStatus> currentStatus, Map<TabletId, TabletServerId> unassigned, SortedMap<TServerInstance, TabletServerStatus> thriftCurrentStatus, Map<KeyExtent, TServerInstance> thriftUnassigned, Map<KeyExtent, TServerInstance> thriftAssignmentsOut) {
        this.currentStatus = currentStatus;
        this.unassigned = unassigned;
        this.assignmentsOut = null;
        this.thriftCurrentStatus = thriftCurrentStatus;
        this.thriftUnassigned = thriftUnassigned;
        this.thriftAssignmentsOut = thriftAssignmentsOut;
    }

    @Override
    public SortedMap<TabletServerId, TServerStatus> currentStatus() {
        return this.currentStatus;
    }

    @Override
    public Map<TabletId, TabletServerId> unassignedTablets() {
        return this.unassigned;
    }

    @Override
    public void addAssignment(TabletId tabletId, TabletServerId tabletServerId) {
        if (this.assignmentsOut != null) {
            this.assignmentsOut.put(tabletId, tabletServerId);
        }
        if (this.thriftAssignmentsOut != null) {
            this.thriftAssignmentsOut.put(KeyExtent.fromTabletId(tabletId), TabletServerIdImpl.toThrift(tabletServerId));
        }
    }

    public SortedMap<TServerInstance, TabletServerStatus> thriftCurrentStatus() {
        return this.thriftCurrentStatus;
    }

    public Map<KeyExtent, TServerInstance> thriftUnassigned() {
        return this.thriftUnassigned;
    }

    public Map<KeyExtent, TServerInstance> thriftAssignmentsOut() {
        return this.thriftAssignmentsOut;
    }
}

