/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.rpc;

import com.google.common.net.HostAndPort;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.channels.ClosedByInterruptException;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.rpc.ProtocolOverridingSSLSocketFactory;
import org.apache.accumulo.core.rpc.SaslConnectionParams;
import org.apache.accumulo.core.rpc.SslConnectionParams;
import org.apache.accumulo.core.rpc.TTimeoutTransport;
import org.apache.accumulo.core.rpc.TraceProtocolFactory;
import org.apache.accumulo.core.rpc.UGIAssumingTransport;
import org.apache.accumulo.core.rpc.clients.ThriftClientTypes;
import org.apache.accumulo.core.util.LazySingletons;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.thrift.TException;
import org.apache.thrift.TServiceClient;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TSSLTransportFactory;
import org.apache.thrift.transport.TSaslClientTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.TTransportFactory;
import org.apache.thrift.transport.layered.TFramedTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftUtil {
    private static final Logger log = LoggerFactory.getLogger(ThriftUtil.class);
    private static final TraceProtocolFactory protocolFactory = new TraceProtocolFactory();
    private static final TFramedTransport.Factory transportFactory = new TFramedTransport.Factory(Integer.MAX_VALUE);
    private static final Map<Integer, TTransportFactory> factoryCache = new HashMap<Integer, TTransportFactory>();
    public static final String GSSAPI = "GSSAPI";
    public static final String DIGEST_MD5 = "DIGEST-MD5";
    private static final int RELOGIN_MAX_BACKOFF = 5000;

    public static TProtocolFactory protocolFactory() {
        return protocolFactory;
    }

    public static TTransportFactory transportFactory() {
        return transportFactory;
    }

    public static <T extends TServiceClient> T createClient(ThriftClientTypes<T> type, TTransport transport) {
        return type.getClient(protocolFactory.getProtocol(transport));
    }

    public static <T extends TServiceClient> T getClientNoTimeout(ThriftClientTypes<T> type, HostAndPort address, ClientContext context) throws TTransportException {
        return ThriftUtil.getClient(type, address, context, 0L);
    }

    public static <T extends TServiceClient> T getClient(ThriftClientTypes<T> type, HostAndPort address, ClientContext context) throws TTransportException {
        TTransport transport = context.getTransportPool().getTransport(address, context.getClientTimeoutInMillis(), context);
        return ThriftUtil.createClient(type, transport);
    }

    public static <T extends TServiceClient> T getClient(ThriftClientTypes<T> type, HostAndPort address, ClientContext context, long timeout) throws TTransportException {
        TTransport transport = context.getTransportPool().getTransport(address, timeout, context);
        return ThriftUtil.createClient(type, transport);
    }

    public static void close(TServiceClient client, ClientContext context) {
        if (client != null && client.getInputProtocol() != null && client.getInputProtocol().getTransport() != null) {
            context.getTransportPool().returnTransport(client.getInputProtocol().getTransport());
        } else {
            log.debug("Attempt to close null connection to a server", (Throwable)new Exception());
        }
    }

    public static void returnClient(TServiceClient iface, ClientContext context) {
        if (iface != null) {
            context.getTransportPool().returnTransport(iface.getInputProtocol().getTransport());
        }
    }

    public static TTransport createTransport(HostAndPort address, ClientContext context) throws TException {
        return ThriftUtil.createClientTransport(address, (int)context.getClientTimeoutInMillis(), context.getClientSslParams(), context.getSaslParams());
    }

    public static synchronized TTransportFactory transportFactory(long maxFrameSize) {
        if (maxFrameSize > Integer.MAX_VALUE || maxFrameSize < 1L) {
            throw new RuntimeException("Thrift transport frames are limited to 2147483647");
        }
        int maxFrameSize1 = (int)maxFrameSize;
        TTransportFactory factory = factoryCache.get(maxFrameSize1);
        if (factory == null) {
            factory = new TFramedTransport.Factory(maxFrameSize1);
            factoryCache.put(maxFrameSize1, factory);
        }
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TTransport createClientTransport(HostAndPort address, int timeout, SslConnectionParams sslParams, SaslConnectionParams saslParams) throws TTransportException {
        boolean success2 = false;
        TTransport transport = null;
        try {
            if (sslParams != null) {
                if (saslParams != null) {
                    throw new IllegalStateException("Cannot use both SSL and SASL");
                }
                log.trace("Creating SSL client transport");
                if (sslParams.useJsse()) {
                    transport = TSSLTransportFactory.getClientSocket((String)address.getHost(), (int)address.getPort(), (int)timeout);
                } else {
                    SSLContext sslContext = ThriftUtil.createSSLContext(sslParams);
                    SSLSocketFactory sslSockFactory = sslContext.getSocketFactory();
                    ProtocolOverridingSSLSocketFactory wrappingSslSockFactory = new ProtocolOverridingSSLSocketFactory(sslSockFactory, new String[]{sslParams.getClientProtocol()});
                    transport = ThriftUtil.createClient(wrappingSslSockFactory, address.getHost(), address.getPort(), timeout);
                }
                transport = ThriftUtil.transportFactory().getTransport(transport);
            } else {
                if (saslParams != null) {
                    if (!UserGroupInformation.isSecurityEnabled()) {
                        throw new IllegalStateException("Expected Kerberos security to be enabled if SASL is in use");
                    }
                    log.trace("Creating SASL connection to {}:{}", (Object)address.getHost(), (Object)address.getPort());
                    try {
                        transport = TTimeoutTransport.create(address, timeout);
                    }
                    catch (TTransportException e) {
                        log.warn("Failed to open transport to {}", (Object)address);
                        throw e;
                    }
                    try {
                        UserGroupInformation userForRpc;
                        UserGroupInformation currentUser = UserGroupInformation.getCurrentUser();
                        if (currentUser.getAuthenticationMethod() == UserGroupInformation.AuthenticationMethod.PROXY) {
                            if (currentUser.getRealUser() != null) {
                                userForRpc = currentUser.getRealUser();
                                log.trace("{} is a proxy user, using real user instead {}", (Object)currentUser, (Object)userForRpc);
                            } else {
                                log.warn("The current user is a proxy user but there is no underlying real user (likely that RPCs will fail): {}", (Object)currentUser);
                                userForRpc = currentUser;
                            }
                        } else {
                            userForRpc = currentUser;
                        }
                        String hostname = InetAddress.getByName(address.getHost()).getCanonicalHostName();
                        SaslConnectionParams.SaslMechanism mechanism = saslParams.getMechanism();
                        log.trace("Opening transport to server as {} to {}/{} using {}", new Object[]{userForRpc, saslParams.getKerberosServerPrimary(), hostname, mechanism});
                        transport = new TSaslClientTransport(mechanism.getMechanismName(), null, saslParams.getKerberosServerPrimary(), hostname, saslParams.getSaslProperties(), saslParams.getCallbackHandler(), transport);
                        transport = new UGIAssumingTransport(transport, userForRpc);
                        transport.open();
                    }
                    catch (TTransportException e) {
                        log.warn("Failed to open SASL transport", (Throwable)e);
                        log.debug("Caught TTransportException opening SASL transport, checking if re-login is necessary before propagating the exception.");
                        ThriftUtil.attemptClientReLogin();
                        throw e;
                    }
                    catch (IOException e) {
                        log.warn("Failed to open SASL transport", (Throwable)e);
                        ThriftUtil.checkIOExceptionCause(e);
                        throw new TTransportException((Throwable)e);
                    }
                }
                log.trace("Opening normal transport");
                if (timeout == 0) {
                    transport = new TSocket(address.getHost(), address.getPort());
                    transport.open();
                } else {
                    try {
                        transport = TTimeoutTransport.create(address, timeout);
                    }
                    catch (TTransportException ex) {
                        log.warn("Failed to open transport to {}", (Object)address);
                        throw ex;
                    }
                    transport.open();
                }
                transport = ThriftUtil.transportFactory().getTransport(transport);
            }
            success2 = true;
        }
        finally {
            if (!success2 && transport != null) {
                transport.close();
            }
        }
        return transport;
    }

    private static void attemptClientReLogin() {
        block8: {
            try {
                UserGroupInformation loginUser = UserGroupInformation.getLoginUser();
                if (loginUser == null || !loginUser.hasKerberosCredentials()) {
                    throw new IllegalStateException("Expected to find Kerberos UGI credentials, but did not");
                }
                UserGroupInformation currentUser = UserGroupInformation.getCurrentUser();
                UserGroupInformation realUser = currentUser.getRealUser();
                if (loginUser.equals((Object)currentUser) || loginUser.equals((Object)realUser)) {
                    if (UserGroupInformation.isLoginKeytabBased()) {
                        log.info("Performing keytab-based Kerberos re-login");
                        loginUser.reloginFromKeytab();
                    } else {
                        log.info("Performing ticket-cache-based Kerberos re-login");
                        loginUser.reloginFromTicketCache();
                    }
                    try {
                        Thread.sleep(LazySingletons.RANDOM.get().nextInt(5000) + 1);
                        break block8;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
                log.debug("Not attempting Kerberos re-login: loginUser={}, currentUser={}, realUser={}", new Object[]{loginUser, currentUser, realUser});
            }
            catch (IOException e) {
                log.warn("Failed to check (and/or perform) Kerberos client re-login", (Throwable)e);
                throw new UncheckedIOException(e);
            }
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="code runs in same security context as user who providing the keystore files")
    private static SSLContext createSSLContext(SslConnectionParams params) throws TTransportException {
        try {
            FileInputStream fis;
            SSLContext ctx = SSLContext.getInstance(params.getClientProtocol());
            TrustManagerFactory tmf = null;
            KeyManagerFactory kmf = null;
            if (params.isTrustStoreSet()) {
                tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                KeyStore ts = KeyStore.getInstance(params.getTrustStoreType());
                fis = new FileInputStream(params.getTrustStorePath());
                try {
                    ts.load(fis, params.getTrustStorePass().toCharArray());
                }
                finally {
                    fis.close();
                }
                tmf.init(ts);
            }
            if (params.isKeyStoreSet()) {
                kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                KeyStore ks = KeyStore.getInstance(params.getKeyStoreType());
                fis = new FileInputStream(params.getKeyStorePath());
                try {
                    ks.load(fis, params.getKeyStorePass().toCharArray());
                }
                finally {
                    fis.close();
                }
                kmf.init(ks, params.getKeyStorePass().toCharArray());
            }
            if (params.isKeyStoreSet() && params.isTrustStoreSet()) {
                ctx.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
            } else if (params.isKeyStoreSet()) {
                ctx.init(kmf.getKeyManagers(), null, null);
            } else {
                ctx.init(null, tmf.getTrustManagers(), null);
            }
            return ctx;
        }
        catch (Exception e) {
            throw new TTransportException("Error creating the transport", (Throwable)e);
        }
    }

    private static TSocket createClient(SSLSocketFactory factory, String host, int port, int timeout) throws TTransportException {
        SSLSocket socket = null;
        try {
            socket = (SSLSocket)factory.createSocket(host, port);
            socket.setSoTimeout(timeout);
            return new TSocket((Socket)socket);
        }
        catch (Exception e) {
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new TTransportException("Could not connect to " + host + " on port " + port, (Throwable)e);
        }
    }

    public static void checkIOExceptionCause(IOException e) {
        if (e instanceof ClosedByInterruptException) {
            Thread.currentThread().interrupt();
            throw new UncheckedIOException(e);
        }
    }
}

