/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Base64;
import java.util.Objects;

public class ByteArrayToBase64TypeAdapter
implements JsonSerializer<byte[]>,
JsonDeserializer<byte[]> {
    private static final Base64.Decoder decoder = Base64.getUrlDecoder();
    private static final Base64.Encoder encoder = Base64.getUrlEncoder();

    public byte[] deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        return decoder.decode(json.getAsString());
    }

    public JsonElement serialize(byte[] src, Type typeOfSrc, JsonSerializationContext context) {
        return new JsonPrimitive(encoder.encodeToString(src));
    }

    public static Gson createBase64Gson() {
        return ByteArrayToBase64TypeAdapter.registerBase64TypeAdapter(new GsonBuilder()).create();
    }

    public static GsonBuilder registerBase64TypeAdapter(GsonBuilder gsonBuilder) {
        return Objects.requireNonNull(gsonBuilder).registerTypeHierarchyAdapter(byte[].class, (Object)new ByteArrayToBase64TypeAdapter());
    }
}

