/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.federation;

import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.core.postoffice.impl.DivertBinding;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerAddressPlugin;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederation;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationAddressConsumer;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationConsumer;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationConsumerManager;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationGenericConsumerInfo;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationLocalPolicyManager;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationMetrics;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationPolicySupport;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationConsumerInfo;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationReceiveFromAddressPolicy;
import org.apache.activemq.artemis.utils.CompositeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AMQPFederationAddressPolicyManager
extends AMQPFederationLocalPolicyManager
implements ActiveMQServerAddressPlugin {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final String remoteQueueFilter;
    protected final FederationReceiveFromAddressPolicy policy;
    protected final Map<String, AMQPFederationAddressConsumerManager> federationConsumers = new HashMap<String, AMQPFederationAddressConsumerManager>();
    protected final Map<DivertBinding, Set<QueueBinding>> divertsTracking = new HashMap<DivertBinding, Set<QueueBinding>>();

    public AMQPFederationAddressPolicyManager(AMQPFederation federation, AMQPFederationMetrics metrics, FederationReceiveFromAddressPolicy addressPolicy) throws ActiveMQException {
        super(federation, metrics, addressPolicy);
        Objects.requireNonNull(addressPolicy, "The Address match policy cannot be null");
        this.policy = addressPolicy;
        this.remoteQueueFilter = AMQPFederationPolicySupport.generateAddressFilter(this.policy.getMaxHops());
    }

    @Override
    public FederationReceiveFromAddressPolicy getPolicy() {
        return this.policy;
    }

    @Override
    protected void safeCleanupManagerResources(boolean force) {
        try {
            this.federationConsumers.values().forEach(entry -> {
                if (entry != null) {
                    if (this.isConnected() && !force) {
                        entry.shutdown();
                    } else {
                        entry.shutdownNow();
                    }
                }
            });
        }
        finally {
            this.federationConsumers.clear();
            this.divertsTracking.clear();
        }
    }

    public synchronized void afterRemoveAddress(SimpleString address, AddressInfo addressInfo) throws ActiveMQException {
        AMQPFederationAddressConsumerManager entry;
        if (this.isActive() && (entry = this.federationConsumers.remove(address.toString())) != null) {
            logger.trace("Federated address {} was removed, closing federation consumer", (Object)address);
            entry.shutdownNow();
        }
    }

    public synchronized void afterRemoveBinding(Binding binding, Transaction tx, boolean deleteData) throws ActiveMQException {
        if (this.isActive()) {
            DivertBinding divert;
            if (binding instanceof QueueBinding) {
                AMQPFederationAddressConsumerManager entry = this.federationConsumers.get(binding.getAddress().toString());
                logger.trace("Federated address {} binding was removed, reducing demand.", (Object)binding.getAddress());
                if (entry != null) {
                    this.tryRemoveDemandOnAddress(entry, binding);
                } else if (this.policy.isEnableDivertBindings()) {
                    this.divertsTracking.entrySet().forEach(divertEntry -> {
                        String sourceAddress = ((DivertBinding)divertEntry.getKey()).getAddress().toString();
                        SimpleString forwardAddress = ((DivertBinding)divertEntry.getKey()).getDivert().getForwardAddress();
                        if (AMQPFederationAddressPolicyManager.isAddressInDivertForwards(binding.getAddress(), forwardAddress)) {
                            ((Set)divertEntry.getValue()).remove(binding);
                            if (((Set)divertEntry.getValue()).isEmpty()) {
                                this.tryRemoveDemandOnAddress(this.federationConsumers.get(sourceAddress), (Binding)divertEntry.getKey());
                            }
                        }
                    });
                }
            } else if (this.policy.isEnableDivertBindings() && binding instanceof DivertBinding && this.divertsTracking.remove(divert = (DivertBinding)binding) != null) {
                try {
                    this.tryRemoveDemandOnAddress(this.federationConsumers.get(divert.getAddress().toString()), (Binding)divert);
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.federationBindingsLookupError(divert.getDivert().getForwardAddress(), (Throwable)e);
                }
            }
        }
    }

    private void tryRemoveDemandOnAddress(AMQPFederationAddressConsumerManager entry, Binding binding) {
        if (entry != null) {
            logger.trace("Reducing demand on federated address {}", (Object)entry.getAddress());
            entry.removeDemand(binding);
        }
    }

    @Override
    protected void scanAllBindings() {
        this.server.getPostOffice().getAllBindings().filter(binding -> binding instanceof QueueBinding || this.policy.isEnableDivertBindings() && binding instanceof DivertBinding).forEach(binding -> this.afterAddBinding((Binding)binding));
    }

    public synchronized void afterAddAddress(AddressInfo addressInfo, boolean reload) {
        if (this.isActive() && this.policy.isEnableDivertBindings() && this.policy.test(addressInfo)) {
            try {
                this.server.getPostOffice().getDirectBindings(addressInfo.getName()).stream().filter(binding -> binding instanceof DivertBinding).forEach(this::checkBindingForMatch);
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.federationBindingsLookupError(addressInfo.getName(), (Throwable)e);
            }
        }
    }

    public synchronized void afterAddBinding(Binding binding) {
        if (this.isActive()) {
            this.checkBindingForMatch(binding);
        }
    }

    private void checkBindingForMatch(Binding binding) {
        if (binding instanceof QueueBinding) {
            QueueBinding queueBinding = (QueueBinding)binding;
            AddressInfo addressInfo = this.server.getPostOffice().getAddressInfo(binding.getAddress());
            if (this.testIfAddressMatchesPolicy(addressInfo)) {
                if (this.isPluginBlockingFederationConsumerCreate(queueBinding.getQueue())) {
                    return;
                }
                this.createOrUpdateFederatedAddressConsumerForBinding(addressInfo, (Binding)queueBinding);
            } else {
                this.reactIfQueueBindingMatchesAnyDivertTarget(queueBinding);
            }
        } else if (binding instanceof DivertBinding) {
            DivertBinding divertBinding = (DivertBinding)binding;
            this.reactIfAnyQueueBindingMatchesDivertTarget(divertBinding);
        }
    }

    private void reactIfAnyQueueBindingMatchesDivertTarget(DivertBinding divertBinding) {
        if (!this.policy.isEnableDivertBindings()) {
            return;
        }
        AddressInfo addressInfo = this.server.getPostOffice().getAddressInfo(divertBinding.getAddress());
        if (!this.testIfAddressMatchesPolicy(addressInfo)) {
            return;
        }
        if (this.divertsTracking.get(divertBinding) == null) {
            HashSet matchingQueues = new HashSet();
            this.divertsTracking.put(divertBinding, matchingQueues);
            SimpleString forwardAddress = divertBinding.getDivert().getForwardAddress();
            SimpleString[] forwardAddresses = forwardAddress.split(',');
            try {
                for (SimpleString forward : forwardAddresses) {
                    this.server.getPostOffice().getBindingsForAddress(forward).getBindings().stream().filter(b -> b instanceof QueueBinding).map(b -> (QueueBinding)b).forEach(queueBinding -> {
                        if (this.isPluginBlockingFederationConsumerCreate(divertBinding.getDivert(), queueBinding.getQueue())) {
                            return;
                        }
                        if (this.isPluginBlockingFederationConsumerCreate(queueBinding.getQueue())) {
                            return;
                        }
                        matchingQueues.add(queueBinding);
                        this.createOrUpdateFederatedAddressConsumerForBinding(addressInfo, (Binding)divertBinding);
                    });
                }
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.federationBindingsLookupError(forwardAddress, (Throwable)e);
            }
        }
    }

    private void reactIfQueueBindingMatchesAnyDivertTarget(QueueBinding queueBinding) {
        if (!this.policy.isEnableDivertBindings()) {
            return;
        }
        SimpleString queueAddress = queueBinding.getAddress();
        this.divertsTracking.entrySet().forEach(e -> {
            SimpleString forwardAddress = ((DivertBinding)e.getKey()).getDivert().getForwardAddress();
            DivertBinding divertBinding = (DivertBinding)e.getKey();
            if (!((Set)e.getValue()).contains(queueBinding) && AMQPFederationAddressPolicyManager.isAddressInDivertForwards(queueAddress, forwardAddress)) {
                if (this.isPluginBlockingFederationConsumerCreate(divertBinding.getDivert(), queueBinding.getQueue())) {
                    return;
                }
                if (this.isPluginBlockingFederationConsumerCreate(queueBinding.getQueue())) {
                    return;
                }
                ((Set)e.getValue()).add(queueBinding);
                AddressInfo addressInfo = this.server.getPostOffice().getAddressInfo(divertBinding.getAddress());
                this.createOrUpdateFederatedAddressConsumerForBinding(addressInfo, (Binding)divertBinding);
            }
        });
    }

    private void createOrUpdateFederatedAddressConsumerForBinding(AddressInfo addressInfo, Binding binding) {
        AMQPFederationAddressConsumerManager entry;
        logger.trace("Federation Address Policy matched on for demand on address: {} : binding: {}", (Object)addressInfo, (Object)binding);
        String addressName = addressInfo.getName().toString();
        if (this.federationConsumers.containsKey(addressName)) {
            entry = this.federationConsumers.get(addressName);
        } else {
            entry = new AMQPFederationAddressConsumerManager(this, addressInfo);
            this.federationConsumers.put(addressName, entry);
        }
        entry.addDemand(binding);
    }

    synchronized void afterRemoteAddressAdded(String addressName) throws Exception {
        AMQPFederationAddressConsumerManager entry;
        if (this.isActive() && this.testIfAddressMatchesPolicy(addressName, RoutingType.MULTICAST) && (entry = this.federationConsumers.get(addressName)) != null) {
            entry.recover();
        }
    }

    private boolean testIfAddressMatchesPolicy(AddressInfo addressInfo) {
        if (!this.policy.test(addressInfo)) {
            return false;
        }
        if (this.configuration.getReceiverCredits() <= 0) {
            logger.debug("Federation address policy rejecting match on {} because credit is set to zero:", (Object)addressInfo.getName());
            return false;
        }
        return true;
    }

    private boolean testIfAddressMatchesPolicy(String address, RoutingType type) {
        return this.policy.test(address, type);
    }

    private AMQPFederationGenericConsumerInfo createConsumerInfo(AddressInfo address) {
        String addressName = address.getName().toString();
        String generatedQueueName = this.generateQueueName(address);
        return new AMQPFederationGenericConsumerInfo(FederationConsumerInfo.Role.ADDRESS_CONSUMER, addressName, generatedQueueName, address.getRoutingType(), this.remoteQueueFilter, CompositeAddress.toFullyQualified((String)addressName, (String)generatedQueueName), ActiveMQDefaultConfiguration.getDefaultConsumerPriority());
    }

    @Override
    protected AMQPFederationConsumer createFederationConsumer(FederationConsumerInfo consumerInfo) {
        Objects.requireNonNull(consumerInfo, "Federation Address consumer information object was null");
        if (logger.isTraceEnabled()) {
            logger.trace("AMQP Federation {} creating address consumer: {} for policy: {}", new Object[]{this.federation.getName(), consumerInfo, this.policy.getPolicyName()});
        }
        return new AMQPFederationAddressConsumer(this, this.configuration, this.session, consumerInfo, this.metrics.newConsumerMetrics());
    }

    private String generateQueueName(AddressInfo address) {
        return "federation." + this.federation.getName() + ".policy." + this.getPolicyName() + ".address." + String.valueOf(address.getName()) + ".node." + String.valueOf(this.server.getNodeID());
    }

    private static boolean isAddressInDivertForwards(SimpleString targetAddress, SimpleString forwardAddress) {
        SimpleString[] forwardAddresses;
        for (SimpleString forward : forwardAddresses = forwardAddress.split(',')) {
            if (!targetAddress.equals((Object)forward)) continue;
            return true;
        }
        return false;
    }

    private static class AMQPFederationAddressConsumerManager
    extends AMQPFederationConsumerManager<Binding> {
        private final AMQPFederationAddressPolicyManager manager;
        private final AddressInfo addressInfo;

        AMQPFederationAddressConsumerManager(AMQPFederationAddressPolicyManager manager, AddressInfo addressInfo) {
            super(manager);
            this.manager = manager;
            this.addressInfo = addressInfo;
        }

        public AddressInfo getAddressInfo() {
            return this.addressInfo;
        }

        public String getAddress() {
            return this.getAddressInfo().getName().toString();
        }

        @Override
        protected AMQPFederationConsumer createFederationConsumer() {
            return this.manager.createFederationConsumer(this.manager.createConsumerInfo(this.addressInfo));
        }

        @Override
        protected boolean isPluginBlockingFederationConsumerCreate() {
            return this.manager.isPluginBlockingFederationConsumerCreate(this.addressInfo);
        }

        @Override
        protected void whenDemandTrackingEntryAdded(Binding entry) {
        }

        @Override
        protected void whenDemandTrackingEntryRemoved(Binding entry) {
        }
    }
}

