/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.cli.kahadb.exporter.artemis;

import org.apache.activemq.cli.artemis.schema.ArtemisJournalMarshaller;
import org.apache.activemq.cli.kahadb.exporter.artemis.OpenWireCoreMessageTypeConverter;
import org.apache.activemq.cli.schema.MessageType;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.store.MessageRecoveryListener;
import org.apache.activemq.store.kahadb.KahaDBStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtemisXmlMessageRecoveryListener
implements MessageRecoveryListener {
    static final Logger LOG = LoggerFactory.getLogger(ArtemisXmlMessageRecoveryListener.class);
    private final ArtemisJournalMarshaller xmlMarshaller;
    private final OpenWireCoreMessageTypeConverter converter;

    public ArtemisXmlMessageRecoveryListener(KahaDBStore store, ArtemisJournalMarshaller xmlMarshaller) {
        this.xmlMarshaller = xmlMarshaller;
        this.converter = new OpenWireCoreMessageTypeConverter(store);
    }

    public boolean recoverMessage(Message message) throws Exception {
        try {
            MessageType messageType = this.converter.convert(message);
            this.xmlMarshaller.appendMessage(messageType);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean recoverMessageReference(MessageId ref) throws Exception {
        return false;
    }

    public boolean hasSpace() {
        return true;
    }

    public boolean isDuplicate(MessageId ref) {
        return false;
    }
}

