/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.operations;

import com.hazelcast.collection.CollectionProxyId;
import com.hazelcast.collection.CollectionRecord;
import com.hazelcast.collection.operations.CollectionKeyBasedOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.BackupOperation;
import java.io.IOException;
import java.util.List;

public class SetBackupOperation
extends CollectionKeyBasedOperation
implements BackupOperation {
    int index;
    long recordId;
    Data value;

    public SetBackupOperation() {
    }

    public SetBackupOperation(CollectionProxyId proxyId, Data dataKey, long recordId, int index, Data value) {
        super(proxyId, dataKey);
        this.index = index;
        this.recordId = recordId;
        this.value = value;
    }

    @Override
    public void run() throws Exception {
        CollectionRecord record = new CollectionRecord(this.recordId, this.isBinary() ? this.value : this.toObject(this.value));
        List list = (List)this.getOrCreateCollectionWrapper().getCollection();
        list.set(this.index, record);
        this.response = true;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.index);
        out.writeLong(this.recordId);
        this.value.writeData(out);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.index = in.readInt();
        this.recordId = in.readLong();
        this.value = new Data();
        this.value.readData(in);
    }

    @Override
    public int getId() {
        return 23;
    }
}

